/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.clouddrive.ecms.filters;

import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.exoplatform.clouddrive.CloudDrive;
import org.exoplatform.clouddrive.CloudDriveService;
import org.exoplatform.clouddrive.DriveRemovedException;
import org.exoplatform.clouddrive.ecms.filters.AbstractCloudDriveNodeFilter;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

public class CloudDriveFilter
extends AbstractCloudDriveNodeFilter {
    protected static final Log LOG = ExoLogger.getLogger(CloudDriveFilter.class);

    public CloudDriveFilter() {
    }

    public CloudDriveFilter(List<String> providers) {
        super(providers);
    }

    @Override
    protected boolean accept(Node node) throws RepositoryException {
        CloudDriveService driveService = (CloudDriveService)WCMCoreUtils.getService(CloudDriveService.class);
        CloudDrive drive = driveService.findDrive(node);
        try {
            return drive != null && this.acceptProvider(drive.getUser().getProvider()) && drive.getPath().equals(node.getPath());
        }
        catch (DriveRemovedException e) {
            return false;
        }
    }
}

