/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.clouddrive.ecms.filters;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.exoplatform.clouddrive.CloudDrive;
import org.exoplatform.clouddrive.CloudDriveService;
import org.exoplatform.clouddrive.DriveRemovedException;
import org.exoplatform.clouddrive.NotCloudDriveException;
import org.exoplatform.clouddrive.NotCloudFileException;
import org.exoplatform.clouddrive.NotYetCloudFileException;
import org.exoplatform.clouddrive.ecms.filters.AbstractCloudDriveNodeFilter;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

public class NotCloudDriveOrFileFilter
extends AbstractCloudDriveNodeFilter {
    protected static final Log LOG = ExoLogger.getLogger(NotCloudDriveOrFileFilter.class);

    @Override
    protected boolean accept(Node node) throws RepositoryException {
        block11: {
            CloudDriveService driveService;
            CloudDrive drive;
            if (node != null && (drive = (driveService = (CloudDriveService)WCMCoreUtils.getService(CloudDriveService.class)).findDrive(node)) != null) {
                try {
                    if (this.acceptProvider(drive.getUser().getProvider())) {
                        if (drive.getPath().equals(node.getPath())) {
                            return false;
                        }
                        drive.getFile(node.getPath());
                        return false;
                    }
                }
                catch (DriveRemovedException e) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)(">> NotCloudDriveOrFileFilter.accept(" + node.getPath() + ") drive removed " + drive + ": " + e.getMessage()));
                    }
                    return false;
                }
                catch (NotYetCloudFileException e) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)(">> NotCloudDriveOrFileFilter.accept(" + node.getPath() + ") not yet cloud file: " + e.getMessage()));
                    }
                    return false;
                }
                catch (NotCloudFileException e) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)(">> NotCloudDriveOrFileFilter.accept(" + node.getPath() + ") not cloud file: " + e.getMessage()));
                    }
                }
                catch (NotCloudDriveException e) {
                    if (!LOG.isDebugEnabled()) break block11;
                    LOG.debug((Object)(">> NotCloudDriveOrFileFilter.accept(" + node.getPath() + ") not in cloud drive: " + e.getMessage()));
                }
            }
        }
        return true;
    }
}

