/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.clouddrive.sharepoint;

import javax.jcr.RepositoryException;
import org.exoplatform.clouddrive.CloudDriveException;
import org.exoplatform.clouddrive.CloudProvider;
import org.exoplatform.clouddrive.cmis.CMISAPI;
import org.exoplatform.clouddrive.cmis.CMISUser;
import org.exoplatform.clouddrive.sharepoint.SharepointAPI;

public class SharepointUser
extends CMISUser {
    public SharepointUser(String id, String username, String email, CloudProvider provider, SharepointAPI api) {
        super(id, username, email, provider, (CMISAPI)api);
    }

    protected SharepointAPI api() {
        return (SharepointAPI)this.api;
    }

    public String createDriveTitle() throws RepositoryException, CloudDriveException {
        StringBuilder title = new StringBuilder();
        String siteTitle = this.getSiteTitle();
        if (siteTitle != null && siteTitle.length() > 0) {
            title.append(siteTitle);
            title.append(" - ");
        } else {
            String predefinedName = this.getPredefinedRepositoryName();
            if (predefinedName != null) {
                title.append(predefinedName);
            } else {
                return super.createDriveTitle();
            }
        }
        title.append(this.getRepositoryName());
        title.append(" - ");
        title.append(this.getUserTitle());
        return title.toString();
    }

    public String getEmail() {
        return this.getSiteUser().getEmail();
    }

    public String getServiceName() {
        return this.getProvider().getName();
    }

    public String getSiteTitle() {
        return this.api().getSiteTitle();
    }

    public String getSiteURL() {
        return this.api().getSiteURL();
    }

    public SharepointAPI.User getSiteUser() {
        return this.api().getSiteUser();
    }
}

