/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.clouddrive.sharepoint;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.security.KeyStore;
import java.util.Iterator;
import java.util.List;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.chemistry.opencmis.client.api.ChangeEvent;
import org.apache.chemistry.opencmis.client.api.ChangeEvents;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.ObjectFactory;
import org.apache.chemistry.opencmis.client.api.Property;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.Properties;
import org.apache.chemistry.opencmis.commons.data.PropertyData;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ObjectDataImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertiesImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyIdImpl;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.exoplatform.clouddrive.CloudDriveAccessException;
import org.exoplatform.clouddrive.CloudDriveException;
import org.exoplatform.clouddrive.cmis.CMISAPI;
import org.exoplatform.clouddrive.cmis.CMISException;
import org.exoplatform.clouddrive.sharepoint.SharepointException;
import org.exoplatform.clouddrive.sharepoint.SharepointServiceNotFound;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.ws.frameworks.json.JsonHandler;
import org.exoplatform.ws.frameworks.json.impl.JsonDefaultHandler;
import org.exoplatform.ws.frameworks.json.impl.JsonException;
import org.exoplatform.ws.frameworks.json.impl.JsonParserImpl;
import org.exoplatform.ws.frameworks.json.value.JsonValue;

public class SharepointAPI
extends CMISAPI {
    protected static final Log LOG = ExoLogger.getLogger(SharepointAPI.class);
    protected static final String MAJOR_VERSION_ID_SUFFIX = "-512";
    protected static final String REST_CONTEXTINFO = "%s/_api/contextinfo";
    protected static final String REST_CURRENTUSER = "%s/_api/Web/CurrentUser";
    protected static final String REST_SITETITLE = "%s/_api/Web/Title";
    protected final String siteURL;
    protected final String userName;
    protected final String password;
    protected final HttpHost siteHost;
    protected final RESTClient nativeClient;
    protected final User siteUser;
    protected final String siteTitle;

    protected SharepointAPI(String serviceURL, String userName, String password) throws CMISException, CloudDriveException {
        super(serviceURL, userName, password);
        this.userName = userName;
        this.password = password;
        try {
            URI uri = new URI(serviceURL);
            String scheme = uri.getScheme();
            String hostname = uri.getHost();
            int port = uri.getPort();
            this.siteHost = new HttpHost(hostname, port, scheme);
            this.siteURL = this.siteHost.toURI().toString();
        }
        catch (URISyntaxException e) {
            throw new CMISException("Error parsing service URL", (Throwable)e);
        }
        this.nativeClient = new RESTClient();
        this.siteTitle = this.readSiteTitle();
        this.siteUser = this.readSiteUser();
    }

    protected ChangesIterator getChanges(CMISAPI.ChangeToken changeToken) throws CMISException, CloudDriveAccessException {
        return new ChangesIterator(changeToken);
    }

    public String getUserTitle() {
        if (this.siteUser != null) {
            return this.siteUser.getTitle();
        }
        return super.getUserTitle();
    }

    protected String getUser() {
        return super.getUser();
    }

    protected String getPassword() {
        return super.getPassword();
    }

    protected String getServiceURL() {
        return super.getServiceURL();
    }

    public String getRepositoryId() {
        return super.getRepositoryId();
    }

    public User getSiteUser() {
        return this.siteUser;
    }

    public String getSiteTitle() {
        return this.siteTitle;
    }

    public String getSiteURL() {
        return this.siteURL;
    }

    protected String readSiteTitle() throws SharepointServiceNotFound, SharepointException, CloudDriveAccessException {
        String reqURI = String.format(REST_SITETITLE, this.siteURL);
        try {
            HttpResponse resp = this.nativeClient.get(reqURI, "Web Site title");
            StatusLine status = resp.getStatusLine();
            if (status != null) {
                if (status.getStatusCode() == 401) {
                    String message = status.getReasonPhrase();
                    if (message == null || message.length() == 0) {
                        message = resp.getEntity().toString();
                    }
                    try {
                        message = message + ". " + this.readError(this.readJson(resp));
                    }
                    catch (SharepointException sharepointException) {
                        // empty catch block
                    }
                    throw new CloudDriveAccessException("Unauthorized for reading site title. " + message);
                }
                JsonValue json = this.readJson(resp);
                JsonValue dv = json.getElement("d");
                if (dv != null && !dv.isNull()) {
                    JsonValue tv = dv.getElement("Title");
                    if (tv != null) {
                        return tv.isNull() ? tv.toString() : tv.getStringValue();
                    }
                    throw new SharepointException("Title request doesn't return a title value");
                }
                throw new SharepointException("Title request doesn't return an expected body (d)");
            }
            throw new SharepointException("Cannot read site title: response without status");
        }
        catch (ClientProtocolException e) {
            throw new SharepointException("Protocol error reading site title", e);
        }
        catch (IOException e) {
            throw new SharepointException("Error reading site title (" + e.getMessage() + ")", e);
        }
        catch (IllegalStateException e) {
            throw new SharepointException("Error fetching site title content (" + e.getMessage() + ")", e);
        }
        catch (JsonException e) {
            throw new SharepointException("Error reading site title content (" + e.getMessage() + ")", e);
        }
    }

    protected User readSiteUser() throws SharepointException, SharepointServiceNotFound, CloudDriveAccessException {
        String reqURI = String.format(REST_CURRENTUSER, this.siteURL);
        try {
            HttpResponse resp = this.nativeClient.get(reqURI, "Web Site current user");
            StatusLine status = resp.getStatusLine();
            if (status != null) {
                if (status.getStatusCode() == 401) {
                    String message = status.getReasonPhrase();
                    if (message == null || message.length() == 0) {
                        message = resp.getEntity().toString();
                    }
                    try {
                        message = message + ". " + this.readError(this.readJson(resp));
                    }
                    catch (SharepointException sharepointException) {
                        // empty catch block
                    }
                    throw new CloudDriveAccessException("Unauthorized for reading current user: " + message);
                }
                JsonValue json = this.readJson(resp);
                JsonValue dv = json.getElement("d");
                if (dv != null && !dv.isNull()) {
                    JsonValue v = dv.getElement("Id");
                    if (v == null || v.isNull()) {
                        throw new SharepointException("Current user request doesn't return Id");
                    }
                    String id = v.getStringValue();
                    v = dv.getElement("LoginName");
                    if (v == null || v.isNull()) {
                        throw new SharepointException("Current user request doesn't return LoginName");
                    }
                    String loginName = v.getStringValue();
                    v = dv.getElement("Title");
                    if (v == null || v.isNull()) {
                        throw new SharepointException("Current user request doesn't return Title");
                    }
                    String title = v.getStringValue();
                    v = dv.getElement("Email");
                    String email = v == null || v.isNull() ? "" : v.getStringValue();
                    v = dv.getElement("IsSiteAdmin");
                    boolean isAdmin = v == null || v.isNull() ? false : v.getBooleanValue();
                    return new User(id, loginName, title, email, isAdmin);
                }
                throw new SharepointException("Current user request doesn't return an expected body (d)");
            }
            throw new SharepointException("Cannot read current user: response without status");
        }
        catch (ClientProtocolException e) {
            throw new SharepointException("Protocol error reading curent user", e);
        }
        catch (IOException e) {
            throw new SharepointException("Error reading curent user (" + e.getMessage() + ")", e);
        }
        catch (IllegalStateException e) {
            throw new SharepointException("Error fetching curent user (" + e.getMessage() + ")", e);
        }
        catch (JsonException e) {
            throw new SharepointException("Error reading curent user data (" + e.getMessage() + ")", e);
        }
    }

    protected JsonValue readJson(HttpResponse resp) throws JsonException, IllegalStateException, IOException, SharepointException {
        HttpEntity entity = resp.getEntity();
        Header contentType = entity.getContentType();
        if (contentType != null && contentType.getValue() != null && contentType.getValue().startsWith("application/json")) {
            InputStream content = entity.getContent();
            JsonParserImpl jsonParser = new JsonParserImpl();
            JsonDefaultHandler handler = new JsonDefaultHandler();
            jsonParser.parse((Reader)new InputStreamReader(content), (JsonHandler)handler);
            return handler.getJsonObject();
        }
        throw new SharepointException("Not JSON content");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String readText(HttpResponse resp) throws IllegalStateException, IOException {
        HttpEntity entity = resp.getEntity();
        Header contentType = entity.getContentType();
        StringBuilder text = new StringBuilder();
        if (contentType == null || contentType.getValue() == null || contentType.getValue().startsWith("text/plain")) {
            Charset charset;
            try {
                String contentCharset = contentType.getElements()[0].getParameterByName("charset").getValue();
                charset = Charset.forName(contentCharset);
            }
            catch (Throwable e) {
                LOG.warn((Object)("Error reading SharePoint response content type charset: " + e.getMessage() + ". JVM default chartset will be used."));
                charset = Charset.defaultCharset();
            }
            try (InputStream content = entity.getContent();){
                byte[] buff = new byte[1024];
                int r = 0;
                while ((r = content.read(buff)) != -1) {
                    text.append(new String(buff, 0, r, charset));
                }
            }
        }
        return text.toString();
    }

    protected String readError(JsonValue json) {
        JsonValue error = json.getElement("error");
        if (error != null) {
            JsonValue errorMsg = error.getElement("message");
            if (errorMsg != null) {
                JsonValue emv = errorMsg.getElement("value");
                if (errorMsg != null) {
                    return emv.getStringValue();
                }
            }
            return error.getStringValue();
        }
        return "".intern();
    }

    protected CMISAPI.ChangeToken readToken(String tokenString) throws CMISException {
        return new SPChangeToken(tokenString);
    }

    protected CmisObject rename(String newName, CmisObject obj, Session session) {
        ObjectDataImpl data = new ObjectDataImpl();
        PropertiesImpl props = new PropertiesImpl();
        ObjectFactory factory = session.getObjectFactory();
        Property objectId = obj.getProperty("cmis:objectId");
        props.addProperty((PropertyData)factory.createProperty(objectId.getDefinition(), objectId.getValues()));
        Property name = obj.getProperty("cmis:name");
        props.addProperty((PropertyData)factory.createProperty(name.getDefinition(), name.getValues()));
        Property baseTypeId = obj.getProperty("cmis:baseTypeId");
        props.addProperty((PropertyData)factory.createProperty(baseTypeId.getDefinition(), baseTypeId.getValues()));
        Property objTypeId = obj.getProperty("cmis:objectTypeId");
        PropertyIdImpl objTypeIdProp = new PropertyIdImpl("cmis:objectTypeId", objTypeId.getValues());
        props.addProperty((PropertyData)objTypeIdProp);
        data.setProperties((Properties)props);
        data.setAcl(obj.getAcl());
        data.setAllowableActions(obj.getAllowableActions());
        CmisObject newObj = factory.convertObject((ObjectData)data, this.fileContext);
        CmisObject renamed = super.rename(newName, newObj, session);
        if (renamed == newObj) {
            obj.refresh();
            return obj;
        }
        if (renamed == obj) {
            return obj;
        }
        return renamed;
    }

    @Deprecated
    protected String documentId(String id) {
        if (id.endsWith(MAJOR_VERSION_ID_SUFFIX)) {
            return id;
        }
        StringBuilder did = new StringBuilder();
        did.append(id);
        did.append(MAJOR_VERSION_ID_SUFFIX);
        return did.toString();
    }

    @Deprecated
    protected String simpleId(String id) {
        int i = id.lastIndexOf(MAJOR_VERSION_ID_SUFFIX);
        if (i > 0) {
            return id.substring(0, i);
        }
        return id;
    }

    public class User {
        final String id;
        final String loginName;
        final String title;
        final String email;
        final boolean isSiteAdmin;

        User(String id, String loginName, String title, String email, boolean isSiteAdmin) {
            this.id = id;
            this.loginName = loginName;
            this.title = title;
            this.email = email;
            this.isSiteAdmin = isSiteAdmin;
        }

        public String getId() {
            return this.id;
        }

        public String getLoginName() {
            return this.loginName;
        }

        public String getTitle() {
            return this.title;
        }

        public String getEmail() {
            return this.email;
        }

        public boolean getIsSiteAdmin() {
            return this.isSiteAdmin;
        }
    }

    protected class RESTClient {
        protected final HttpClient httpClient;
        protected final HttpContext context;

        protected RESTClient() {
            SSLSocketFactory socketFactory;
            SchemeRegistry schemeReg = new SchemeRegistry();
            schemeReg.register(new Scheme("http", 80, (SchemeSocketFactory)PlainSocketFactory.getSocketFactory()));
            try {
                SSLContext sslContext = SSLContext.getInstance("TLS");
                KeyManagerFactory kmfactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                kmfactory.init(null, null);
                KeyManager[] keymanagers = kmfactory.getKeyManagers();
                TrustManagerFactory tmfactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                tmfactory.init((KeyStore)null);
                TrustManager[] trustmanagers = tmfactory.getTrustManagers();
                sslContext.init(keymanagers, trustmanagers, null);
                socketFactory = new SSLSocketFactory(sslContext, SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
            }
            catch (Exception ex) {
                throw new IllegalStateException("Failure initializing default SSL context for SharePoint REST client", ex);
            }
            schemeReg.register(new Scheme("https", 443, (SchemeSocketFactory)socketFactory));
            ThreadSafeClientConnManager connectionManager = new ThreadSafeClientConnManager(schemeReg);
            connectionManager.setDefaultMaxPerRoute(4);
            connectionManager.setMaxTotal(40);
            DefaultHttpClient client = new DefaultHttpClient((ClientConnectionManager)connectionManager);
            client.getCredentialsProvider().setCredentials(new AuthScope(SharepointAPI.this.siteHost.getHostName(), SharepointAPI.this.siteHost.getPort()), (Credentials)new UsernamePasswordCredentials(SharepointAPI.this.userName, SharepointAPI.this.password));
            this.httpClient = client;
            BasicAuthCache authCache = new BasicAuthCache();
            BasicScheme basicAuth = new BasicScheme();
            authCache.put(SharepointAPI.this.siteHost, (AuthScheme)basicAuth);
            this.context = new BasicHttpContext();
            this.context.setAttribute("http.auth.auth-cache", (Object)authCache);
        }

        HttpResponse execute(HttpUriRequest request) throws ClientProtocolException, IOException {
            return this.httpClient.execute(request, this.context);
        }

        HttpResponse get(String uri, String opName) throws ClientProtocolException, IOException, IllegalStateException, SharepointServiceNotFound, SharepointException {
            HttpGet httpget = new HttpGet(uri);
            httpget.setHeader("accept", "application/json;odata=verbose");
            HttpResponse resp = this.execute((HttpUriRequest)httpget);
            this.checkError(resp, opName);
            return resp;
        }

        void checkError(HttpResponse resp, String opName) throws IllegalStateException, IOException, SharepointException, SharepointServiceNotFound {
            int statusCode = resp.getStatusLine().getStatusCode();
            switch (statusCode) {
                case 404: {
                    throw new SharepointServiceNotFound("SharePoint service " + opName + " not found");
                }
                case 403: {
                    throw new SharepointException("Access to SharePoint " + opName + " forbidden. " + SharepointAPI.this.readText(resp));
                }
            }
        }
    }

    protected class SPChangeToken
    extends CMISAPI.ChangeToken {
        protected final long timestamp;
        protected final long index;

        protected SPChangeToken(String token) throws CMISException {
            super((CMISAPI)SharepointAPI.this, token);
            String[] ta = this.token.split(";");
            if (ta.length >= 6) {
                try {
                    this.timestamp = Long.valueOf(ta[3]);
                }
                catch (NumberFormatException e) {
                    throw new CMISException("Cannot parse change token timestamp: " + this.token, (Throwable)e);
                }
                try {
                    this.index = Long.valueOf(ta[4]);
                }
                catch (NumberFormatException e) {
                    throw new CMISException("Cannot parse change token index: " + this.token, (Throwable)e);
                }
            }
            this.timestamp = 0L;
            this.index = 0L;
        }

        public boolean equals(CMISAPI.ChangeToken other) {
            if (!this.isEmpty() && !other.isEmpty() && other instanceof SPChangeToken) {
                SPChangeToken otherSP = (SPChangeToken)other;
                return this.getIndex() == otherSP.getIndex() && this.getTimestamp() == otherSP.getTimestamp();
            }
            return false;
        }

        public boolean equals(SPChangeToken other) {
            if (!this.isEmpty() && !other.isEmpty()) {
                return this.getIndex() == other.getIndex() && this.getTimestamp() == other.getTimestamp();
            }
            return false;
        }

        public boolean isAfter(CMISAPI.ChangeToken other) {
            if (other instanceof SPChangeToken) {
                SPChangeToken otherSP = (SPChangeToken)other;
                return this.getIndex() >= otherSP.getIndex();
            }
            return super.isAfter(other);
        }

        public boolean isBefore(CMISAPI.ChangeToken other) {
            if (other instanceof SPChangeToken) {
                SPChangeToken otherSP = (SPChangeToken)other;
                return this.getIndex() <= otherSP.getIndex();
            }
            return super.isBefore(other);
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public long getIndex() {
            return this.index;
        }
    }

    protected class ChangesIterator
    extends CMISAPI.ChangesIterator {
        ChangesIterator(CMISAPI.ChangeToken startChangeToken) throws CMISException, CloudDriveAccessException {
            super((CMISAPI)SharepointAPI.this, startChangeToken);
        }

        protected Iterator<ChangeEvent> nextChunk() throws CMISException, CloudDriveAccessException {
            ChangeEvents allEvents;
            List allChanges;
            CMISAPI.ChangeToken startChangeToken = this.changeToken;
            Iterator nextChunk = super.nextChunk();
            if (!nextChunk.hasNext() && this.firstRun && (allChanges = (allEvents = SharepointAPI.this.session(true).getContentChanges(null, true, Integer.MAX_VALUE)).getChangeEvents()).size() > 0) {
                for (int i = allChanges.size() - 1; i >= 0; --i) {
                    CMISAPI.ChangeToken et = SharepointAPI.this.readToken((ChangeEvent)allChanges.get(i));
                    if (!et.isBefore(startChangeToken)) continue;
                    this.changeToken = et;
                    nextChunk = super.nextChunk();
                    break;
                }
            }
            return nextChunk;
        }
    }
}

