/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.moxtra.oauth2;

import java.util.Calendar;
import java.util.LinkedHashSet;
import java.util.Set;
import org.exoplatform.moxtra.oauth2.AccessTokenRefreshListener;

public class AccessToken {
    private String accessToken;
    private String refreshToken;
    private Calendar expirationTime;
    private String scope;
    private Set<AccessTokenRefreshListener> listeners = new LinkedHashSet<AccessTokenRefreshListener>();

    public static AccessToken newToken() {
        return new AccessToken();
    }

    public static AccessToken createToken(String accessToken, String refreshToken, Long expiresInSeconds, String scope) {
        AccessToken token = new AccessToken();
        token.init(accessToken, refreshToken, expiresInSeconds, scope);
        return token;
    }

    public static AccessToken copyToken(AccessToken otherToken) {
        AccessToken token = new AccessToken();
        token.merge(otherToken);
        return token;
    }

    protected AccessToken() {
    }

    public void addListener(AccessTokenRefreshListener listener, boolean fireNow) {
        this.listeners.add(listener);
        if (fireNow) {
            listener.onTokenRefresh(this);
        }
    }

    public void removeListener(AccessTokenRefreshListener listener) {
        this.listeners.remove(listener);
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public Calendar getExpirationTime() {
        return this.expirationTime;
    }

    public String getScope() {
        return this.scope;
    }

    public void merge(AccessToken newToken) {
        if (newToken.isInitialized()) {
            newToken.removeListeners();
            this.load(newToken.getAccessToken(), newToken.getRefreshToken(), newToken.getExpirationTime(), newToken.getScope());
            this.fireListeners();
        }
    }

    public void init(String accessToken, String refreshToken, Long expiresInSeconds, String scope) {
        if (accessToken == null) {
            throw new NullPointerException("Not null accessToken required");
        }
        if (expiresInSeconds == null) {
            throw new NullPointerException("Not null expiresInSeconds required");
        }
        Calendar expirationTime = Calendar.getInstance();
        int expiresIn = expiresInSeconds.intValue();
        expirationTime.add(13, expiresIn > 120 ? expiresIn - 120 : expiresIn);
        this.load(accessToken, refreshToken, expirationTime, scope);
        this.fireListeners();
    }

    public void load(String accessToken, String refreshToken, Calendar expirationTime, String scope) {
        this.accessToken = accessToken;
        this.refreshToken = refreshToken;
        this.scope = scope;
        this.expirationTime = expirationTime;
    }

    public boolean isExpired() {
        return this.isExpired(Calendar.getInstance());
    }

    public boolean isExpired(Calendar toDate) {
        return this.expirationTime.after(toDate);
    }

    public boolean isInitialized() {
        return this.accessToken != null;
    }

    protected void removeListeners() {
        this.listeners.clear();
    }

    protected void fireListeners() {
        for (AccessTokenRefreshListener listener : this.listeners) {
            listener.onTokenRefresh(this);
        }
    }
}

