/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.moxtra.calendar;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.oltu.oauth2.common.exception.OAuthProblemException;
import org.apache.oltu.oauth2.common.exception.OAuthSystemException;
import org.exoplatform.calendar.service.Calendar;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.calendar.service.CalendarSetting;
import org.exoplatform.calendar.service.impl.CalendarServiceImpl;
import org.exoplatform.commons.utils.MimeTypeResolver;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.moxtra.Moxtra;
import org.exoplatform.moxtra.MoxtraException;
import org.exoplatform.moxtra.MoxtraService;
import org.exoplatform.moxtra.calendar.MoxtraCalendarApplication;
import org.exoplatform.moxtra.calendar.MoxtraCalendarException;
import org.exoplatform.moxtra.calendar.MoxtraMeetDownloadJob;
import org.exoplatform.moxtra.calendar.MoxtraMeetNotFoundException;
import org.exoplatform.moxtra.client.MoxtraAuthenticationException;
import org.exoplatform.moxtra.client.MoxtraClient;
import org.exoplatform.moxtra.client.MoxtraClientException;
import org.exoplatform.moxtra.client.MoxtraMeet;
import org.exoplatform.moxtra.client.MoxtraMeetRecording;
import org.exoplatform.moxtra.client.MoxtraUser;
import org.exoplatform.moxtra.jcr.JCR;
import org.exoplatform.services.cms.drives.DriveData;
import org.exoplatform.services.cms.drives.ManageDriveService;
import org.exoplatform.services.cms.impl.Utils;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.jcr.util.Text;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.scheduler.JobInfo;
import org.exoplatform.services.scheduler.impl.JobSchedulerServiceImpl;
import org.exoplatform.services.security.ConversationState;
import org.quartz.JobDetail;
import org.quartz.Trigger;
import org.quartz.impl.JobDetailImpl;
import org.quartz.impl.triggers.SimpleTriggerImpl;

public class MoxtraCalendarService {
    public static final String MEET_VIDEO_DOWNLOAD_JOB_GROUP_NAME = "moxtra_meet_download";
    protected static final Log LOG = ExoLogger.getLogger(MoxtraCalendarService.class);
    protected final ThreadLocal<MoxtraCalendarApplication> contextApp = new ThreadLocal();
    protected final MimeTypeResolver mimetypeResolver = new MimeTypeResolver();
    protected final Environment jobEnvironment = new Environment();
    protected final MoxtraService moxtraService;
    protected final CalendarServiceImpl calendar;
    protected final OrganizationService orgService;
    protected final JobSchedulerServiceImpl schedulerService;
    protected final NodeHierarchyCreator hierarchyCreator;
    protected final SessionProviderService sessionProviderService;
    protected final ManageDriveService driveService;

    public MoxtraCalendarService(MoxtraService moxtra, SessionProviderService sessionProviderService, NodeHierarchyCreator hierarchyCreator, CalendarServiceImpl calendar, OrganizationService orgService, JobSchedulerServiceImpl schedulerService, ManageDriveService driveService) {
        this.moxtraService = moxtra;
        this.sessionProviderService = sessionProviderService;
        this.hierarchyCreator = hierarchyCreator;
        this.calendar = calendar;
        this.orgService = orgService;
        this.schedulerService = schedulerService;
        this.driveService = driveService;
    }

    public String getOAuth2Link() throws OAuthSystemException {
        return this.moxtraService.getClient().authorizer().authorizationLink();
    }

    public CalendarEvent getEvent(String eventId) throws Exception {
        return this.calendar.getEventById(eventId);
    }

    public CalendarEvent getGroupEvent(String eventId) throws Exception {
        return this.calendar.getGroupEvent(eventId);
    }

    public CalendarSetting getCalendarSetting() throws Exception {
        String userName = ConversationState.getCurrent().getIdentity().getUserId();
        return this.calendar.getCalendarSetting(userName);
    }

    public MoxtraMeet getMeet(CalendarEvent event) throws MoxtraCalendarException {
        try {
            MoxtraMeet existing;
            String userName = ConversationState.getCurrent().getIdentity().getUserId();
            Node eventNode = this.readEventNode(userName, String.valueOf(2), event.getCalendarId(), event.getId());
            if (eventNode == null) {
                eventNode = this.readEventNode(userName, String.valueOf(0), event.getCalendarId(), event.getId());
            }
            if (eventNode == null) {
                eventNode = this.readEventNode(userName, String.valueOf(1), event.getCalendarId(), event.getId());
            }
            if (eventNode != null && JCR.isServices((Node)eventNode)) {
                try {
                    Node meetNode = JCR.getMeet((Node)eventNode);
                    existing = this.readMeet(meetNode);
                }
                catch (PathNotFoundException e) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Meet not found or not complete for event " + event.getSummary() + " in " + eventNode.getName() + ". " + e.getMessage()));
                    }
                    existing = null;
                }
            } else {
                existing = null;
            }
            return existing;
        }
        catch (Exception e) {
            throw new MoxtraCalendarException("Error reading event node", e);
        }
    }

    public MoxtraMeet newMeet() {
        return new MoxtraMeet().editor();
    }

    void initContext(MoxtraCalendarApplication app) {
        this.contextApp.set(app);
    }

    void cleanContext(MoxtraCalendarApplication app) {
        this.contextApp.remove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void saveMeet(String calendarId, CalendarEvent event) {
        MoxtraCalendarApplication app = this.contextApp.get();
        if (app != null) {
            this.contextApp.remove();
            try {
                if (!CalendarEvent.TYPE_EVENT.equals(event.getEventType())) return;
                String userName = ConversationState.getCurrent().getIdentity().getUserId();
                try {
                    MoxtraMeet meet = app.getMeet();
                    String calType = app.getCalendarType();
                    Node eventNode = this.readEventNode(userName, calType != null ? calType : event.getCalType(), calendarId != null ? calendarId : event.getCalendarId(), event.getId());
                    if (eventNode != null) {
                        MoxtraClient moxtra = this.moxtraService.getClient();
                        if (meet.hasDeleted()) {
                            if (!meet.isNew()) {
                                boolean cancelVideoDownload = meet.isAutoRecording() || meet.hasAutoRecordingChanged();
                                moxtra.deleteMeet(meet);
                                JCR.removeServices((Node)eventNode);
                                if (cancelVideoDownload) {
                                    this.removeDownloadJob(event, meet);
                                }
                            }
                        } else {
                            this.initEventMeet(meet, event);
                            if (meet.isNew()) {
                                if (!JCR.isServices((Node)eventNode)) {
                                    JCR.addServices((Node)eventNode);
                                } else if (JCR.hasMeet((Node)eventNode)) {
                                    throw new MoxtraCalendarException("Meet already created for this event " + event.getSummary());
                                }
                                moxtra.createMeet(meet);
                                eventNode.save();
                                Node meetNode = JCR.addMeet((Node)eventNode);
                                MoxtraMeet remoteMeet = moxtra.getMeet(meet.getSessionKey());
                                this.writeMeet(meetNode, meet, remoteMeet.getUsers());
                                if (meet.isAutoRecording()) {
                                    this.createDownloadJob(event, meet, meetNode, null);
                                }
                            } else {
                                if (!JCR.isServices((Node)eventNode)) {
                                    throw new MoxtraCalendarException("Meet not enabled for this event " + event.getSummary());
                                }
                                boolean updateVideoDownload = meet.isAutoRecording() && meet.hasEndTimeChanged();
                                boolean cancelVideoDownload = !meet.isAutoRecording() && meet.hasAutoRecordingChanged();
                                moxtra.updateMeet(meet);
                                Node meetNode = JCR.getMeet((Node)eventNode);
                                this.writeMeet(meetNode, meet, null);
                                if (updateVideoDownload) {
                                    this.updateDownloadJob(event, meet);
                                }
                                if (cancelVideoDownload) {
                                    this.removeDownloadJob(event, meet);
                                }
                            }
                        }
                        eventNode.save();
                        return;
                    }
                    LOG.error((Object)("Event node cannot be found for user " + userName + " event " + event.getSummary()));
                    return;
                }
                catch (MoxtraMeetNotFoundException e) {
                    if (!LOG.isDebugEnabled()) return;
                    LOG.debug((Object)("<<< " + e.getMessage()));
                }
                return;
            }
            catch (MoxtraCalendarException e) {
                LOG.error((Object)"Error getting calendar data", (Throwable)e);
                return;
            }
            catch (MoxtraClientException e) {
                LOG.error((Object)"Error saving even meet", (Throwable)e);
                return;
            }
            catch (MoxtraException e) {
                LOG.error((Object)"Error saving even meet", (Throwable)e);
                return;
            }
            catch (OAuthSystemException e) {
                LOG.error((Object)"Cannot save even meet due to authorization error", (Throwable)e);
                return;
            }
            catch (OAuthProblemException e) {
                LOG.error((Object)"Cannot save even meet due to authorization failure", (Throwable)e);
                return;
            }
            catch (RepositoryException e) {
                LOG.error((Object)"Cannot save even meet due to storage error", (Throwable)e);
                return;
            }
            catch (Exception e) {
                LOG.error((Object)"Error saving even meet", (Throwable)e);
                return;
            }
            finally {
                app.reset();
            }
        } else {
            if (!LOG.isDebugEnabled()) return;
            LOG.debug((Object)("No moxtra app found in context for even " + event.getSummary()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void deleteMeet(String calendarId, CalendarEvent event) {
        MoxtraCalendarApplication app = this.contextApp.get();
        if (app != null) {
            this.contextApp.remove();
            try {
                MoxtraMeet meet = this.getMeet(event);
                if (meet != null) {
                    this.moxtraService.getClient().deleteMeet(meet);
                } else {
                    LOG.error((Object)("Cannot delete event meet " + event.getSummary() + ", it is not found in calendar " + calendarId));
                }
            }
            catch (MoxtraCalendarException e) {
                LOG.error((Object)"Error deleting event meet", (Throwable)e);
            }
            catch (MoxtraClientException e) {
                LOG.error((Object)"Error deleting event meet", (Throwable)e);
            }
            catch (MoxtraException e) {
                LOG.error((Object)"Error deleting event meet", (Throwable)e);
            }
            catch (OAuthSystemException e) {
                LOG.error((Object)"Cannot delete event meet due to authorization error", (Throwable)e);
            }
            catch (OAuthProblemException e) {
                LOG.error((Object)"Cannot delete event meet due to authorization failure", (Throwable)e);
            }
            finally {
                app.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void deleteMeet() {
        MoxtraCalendarApplication app = this.contextApp.get();
        if (app != null) {
            if (!app.isActivated()) return;
            this.contextApp.remove();
            try {
                if (!app.hasMeet()) return;
                this.moxtraService.getClient().deleteMeet(app.getMeet());
                return;
            }
            catch (MoxtraCalendarException e) {
                LOG.error((Object)"Error deleting context meet", (Throwable)e);
                return;
            }
            catch (MoxtraClientException e) {
                LOG.error((Object)"Error deleting context meet", (Throwable)e);
                return;
            }
            catch (MoxtraException e) {
                LOG.error((Object)"Error deleting context meet", (Throwable)e);
                return;
            }
            catch (OAuthSystemException e) {
                LOG.error((Object)"Cannot delete context meet due to authorization error", (Throwable)e);
                return;
            }
            catch (OAuthProblemException e) {
                LOG.error((Object)"Cannot delete context meet due to authorization failure", (Throwable)e);
                return;
            }
            finally {
                app.reset();
            }
        } else {
            if (!LOG.isDebugEnabled()) return;
            LOG.debug((Object)"Moxtra app not activated in the context. It may be already reset.");
        }
    }

    public String downloadMeetVideo(String userName, CalendarEvent event) throws MoxtraCalendarException {
        block23: {
            Node eventNode = this.readEventNode(userName, event.getCalType(), event.getCalendarId(), event.getId());
            try {
                if (JCR.isServices((Node)eventNode)) {
                    try {
                        Node meetNode = JCR.getMeet((Node)eventNode);
                        MoxtraMeet meet = this.readMeet(meetNode);
                        if (meet.isAutoRecording()) {
                            MoxtraClient moxtra;
                            List recs;
                            if (MoxtraMeet.SESSION_ENDED.equals(meet.getStatus()) && (recs = (moxtra = this.moxtraService.getClient()).getMeetRecordings(meet)).size() > 0) {
                                MoxtraMeetRecording rec = (MoxtraMeetRecording)recs.get(0);
                                if (rec.getContentLength() > 0L) {
                                    Node meetings;
                                    String destPath = meet.getVideoPath();
                                    if (destPath == null) {
                                        Node documents;
                                        try {
                                            Calendar spaceCal = this.calendar.getGroupCalendar(event.getCalendarId());
                                            documents = this.getSpaceDocumentsNode(userName, spaceCal.getCalendarOwner());
                                            if (documents == null) {
                                                throw new MoxtraCalendarException("Unable to save meet video recordings for event " + event.getSummary() + ": cannot find Documents for space " + spaceCal.getCalendarOwner());
                                            }
                                            meetings = this.getMeetingsFolder(documents, "Meetings");
                                        }
                                        catch (Exception ce) {
                                            if (LOG.isDebugEnabled()) {
                                                LOG.debug((Object)("Error getting " + event.getSummary() + " calendar. " + ce.getMessage()));
                                            }
                                            try {
                                                documents = this.getUserDocumentsNode(userName);
                                                if (documents == null) {
                                                    throw new MoxtraCalendarException("Unable to save meet video recordings for event " + event.getSummary() + ": cannot find Personal Documents for user " + userName);
                                                }
                                                meetings = this.getMeetingsFolder(documents, "My Meetings");
                                            }
                                            catch (Exception he) {
                                                throw new MoxtraCalendarException("Error creating meetings folder in user home " + userName + ". " + he.getMessage(), he);
                                            }
                                        }
                                    } else {
                                        meetings = (Node)eventNode.getSession().getItem(destPath);
                                    }
                                    String meetNodeName = Text.escapeIllegalJcrChars((String)meet.getName());
                                    Node meetFolder = meetings.addNode(meetNodeName, "nt:folder");
                                    meetings.save();
                                    meetFolder.setProperty("exo:title", meet.getName());
                                    meetFolder.setProperty("exo:name", meet.getName());
                                    String mimeType = rec.getContentType();
                                    String fileExt = this.mimetypeResolver.getExtension(mimeType);
                                    fileExt = fileExt.length() > 0 ? "." + fileExt : fileExt;
                                    InputStream is = moxtra.requestGet(rec.getDownloadLink(), rec.getContentType());
                                    Node video = meetFolder.addNode(meetNodeName + fileExt, "nt:file");
                                    Node content = video.addNode("jcr:content", "nt:resource");
                                    content.setProperty("jcr:mimeType", mimeType);
                                    java.util.Calendar created = java.util.Calendar.getInstance();
                                    created.setTime(rec.getCreatedTime());
                                    content.setProperty("jcr:lastModified", created);
                                    content.setProperty("jcr:data", is);
                                    meetings.save();
                                    String videoTitle = meet.getName() + fileExt;
                                    meetFolder.setProperty("exo:title", videoTitle);
                                    meetFolder.setProperty("exo:name", videoTitle);
                                } else {
                                    LOG.warn((Object)("Moxtra meet recording empty for given event '" + event.getSummary() + "' (" + event.getId() + ")"));
                                    return null;
                                }
                            }
                            return meet.getStatus();
                        }
                        break block23;
                    }
                    catch (OAuthSystemException e) {
                        throw new MoxtraCalendarException("Error accessing meet for event " + event.getSummary() + ". " + e.getMessage(), e);
                    }
                    catch (OAuthProblemException e) {
                        throw new MoxtraCalendarException("Error accessing meet for event " + event.getSummary() + ". " + e.getMessage(), e);
                    }
                    catch (MoxtraException e) {
                        throw new MoxtraCalendarException("Error downloading meet video for event " + event.getSummary() + ". " + e.getMessage(), e);
                    }
                }
                LOG.warn((Object)("Moxtra meet not enabled for given event '" + event.getSummary() + "' (" + event.getId() + ")"));
            }
            catch (RepositoryException e) {
                if (LOG.isDebugEnabled()) {
                    try {
                        LOG.debug((Object)("Error reading saved meet for event " + event.getSummary() + " in " + eventNode.getName() + ". " + e.getMessage()));
                    }
                    catch (RepositoryException re) {
                        // empty catch block
                    }
                }
                throw new MoxtraCalendarException("Error reading saved meet for event " + event.getSummary() + ". " + e.getMessage(), e);
            }
        }
        return null;
    }

    public List<MoxtraUser> getContacts() throws MoxtraCalendarException, MoxtraAuthenticationException, MoxtraException {
        return this.moxtraService.getClient().getContacts(this.getUser());
    }

    public boolean isAuthorized() {
        return this.moxtraService.getClient().isAuthorized();
    }

    public MoxtraUser getUser() throws MoxtraException {
        return this.moxtraService.getClient().getCurrentUser();
    }

    public void prepareJobEnvironment(JobDetail job) throws MoxtraCalendarException {
        String exoUserId = job.getJobDataMap().getString("user_id");
        this.jobEnvironment.prepare(exoUserId);
    }

    public void cleanupJobEnvironment(JobDetail job) throws MoxtraCalendarException {
        String exoUserId = job.getJobDataMap().getString("user_id");
        this.jobEnvironment.cleanup(exoUserId);
    }

    protected Node readEventNode(String userName, String calType, String calId, String eventId) throws MoxtraCalendarException {
        try {
            return this.calendar.getDataStorage().getCalendarEventNode(userName, calType, calId, eventId);
        }
        catch (Exception e) {
            throw new MoxtraCalendarException("Error reading event node", e);
        }
    }

    protected void initEventMeet(MoxtraMeet meet, CalendarEvent event) throws Exception {
        meet.editName(event.getSummary());
        meet.editAgenda(event.getDescription());
        meet.editStartTime(event.getFromDateTime());
        meet.editEndTime(event.getToDateTime());
        List currentUsers = meet.getUsers();
        HashSet<String> alreadyUsers = new HashSet<String>();
        ArrayList<MoxtraUser> newUsers = new ArrayList<MoxtraUser>();
        block0: for (String nameOrEmail : event.getParticipant()) {
            String name;
            String email;
            User user = this.orgService.getUserHandler().findUserByName(nameOrEmail);
            if (user != null) {
                email = user.getEmail();
                for (MoxtraUser participant : currentUsers) {
                    if (!participant.getEmail().equals(email)) continue;
                    alreadyUsers.add(email);
                    continue block0;
                }
                name = user.getDisplayName();
                if (name == null && (name = user.getFirstName() + " " + user.getLastName()).trim().length() == 0) {
                    name = email;
                }
            } else if (nameOrEmail.indexOf(64) > 0) {
                email = name = nameOrEmail;
            } else {
                LOG.warn((Object)("Cannot recognize user " + nameOrEmail + " for Moxtra Meet. User skipped."));
                continue;
            }
            newUsers.add(new MoxtraUser(name, email));
        }
        block2: for (String email : event.getInvitation()) {
            for (MoxtraUser participant : currentUsers) {
                if (!participant.getEmail().equals(email)) continue;
                alreadyUsers.add(email);
                continue block2;
            }
            for (MoxtraUser newUser : newUsers) {
                if (!newUser.getEmail().equals(email)) continue;
                continue block2;
            }
            newUsers.add(new MoxtraUser(email));
        }
        MoxtraUser hostUser = this.getHostUser(meet);
        for (MoxtraUser participant : currentUsers) {
            if (alreadyUsers.contains(participant.getEmail()) || hostUser != null && hostUser.equals((Object)participant)) continue;
            meet.removeUser(participant);
        }
        for (MoxtraUser newUser : newUsers) {
            meet.addUser(newUser);
        }
    }

    protected void writeMeet(Node meetNode, MoxtraMeet meet, List<MoxtraUser> users) throws RepositoryException {
        block14: {
            block15: {
                block13: {
                    JCR.setId((Node)meetNode, (String)meet.getBinderId());
                    JCR.setName((Node)meetNode, (String)meet.getName());
                    JCR.setRevision((Node)meetNode, (Long)meet.getRevision());
                    JCR.setCreatedTime((Node)meetNode, (Date)meet.getCreatedTime());
                    JCR.setUpdatedTime((Node)meetNode, (Date)meet.getUpdatedTime());
                    JCR.setAgenda((Node)meetNode, (String)meet.getAgenda());
                    JCR.setStartTime((Node)meetNode, (Date)meet.getStartTime());
                    Date endTime = meet.getEndTime();
                    if (endTime != null) {
                        JCR.setEndTime((Node)meetNode, (Date)endTime);
                    }
                    JCR.setStartMeetUrl((Node)meetNode, (String)meet.getStartMeetUrl());
                    JCR.setSessionKey((Node)meetNode, (String)meet.getSessionKey());
                    if (!meet.isNew()) break block13;
                    JCR.setAutoRecording((Node)meetNode, (Boolean)meet.isAutoRecording());
                    Node usersNode = JCR.addUsers((Node)meetNode);
                    for (MoxtraUser participant : users.size() > 0 ? users : meet.getUsers()) {
                        Node pnode = usersNode.addNode(participant.getEmail());
                        JCR.setId((Node)pnode, (String)participant.getId());
                        JCR.setName((Node)pnode, (String)participant.getName());
                        JCR.setEmail((Node)pnode, (String)participant.getEmail());
                        JCR.setType((Node)pnode, (String)participant.getType());
                    }
                    break block14;
                }
                Boolean autorec = meet.getAutoRecording();
                if (autorec != null) {
                    JCR.setAutoRecording((Node)meetNode, (Boolean)autorec);
                }
                if (!meet.isEditor()) break block15;
                Node usersNode = JCR.getUsers((Node)meetNode);
                if (meet.hasUsersRemoved()) {
                    for (MoxtraUser removed : meet.getRemovedUsers()) {
                        try {
                            usersNode.getNode(removed.getEmail()).remove();
                        }
                        catch (PathNotFoundException e) {}
                    }
                }
                if (!meet.hasUsersAdded()) break block14;
                for (MoxtraUser participant : meet.getAddedUsers()) {
                    Node pnode = usersNode.addNode(participant.getEmail());
                    JCR.setId((Node)pnode, (String)participant.getId());
                    JCR.setName((Node)pnode, (String)participant.getName());
                    JCR.setEmail((Node)pnode, (String)participant.getEmail());
                    JCR.setType((Node)pnode, (String)participant.getType());
                }
                break block14;
            }
            List meetUsers = meet.getUsers();
            if (meetUsers.size() > 0) {
                Node usersNode = JCR.getUsers((Node)meetNode);
                HashSet<String> existingEmails = new HashSet<String>();
                for (MoxtraUser participant : meetUsers) {
                    Node pnode;
                    String email = participant.getEmail();
                    existingEmails.add(email);
                    try {
                        pnode = usersNode.getNode(email);
                    }
                    catch (PathNotFoundException e) {
                        pnode = usersNode.addNode(email);
                    }
                    JCR.setId((Node)pnode, (String)participant.getId());
                    JCR.setName((Node)pnode, (String)participant.getName());
                    JCR.setEmail((Node)pnode, (String)email);
                    JCR.setType((Node)pnode, (String)participant.getType());
                }
                NodeIterator piter = usersNode.getNodes();
                while (piter.hasNext()) {
                    Node pnode = piter.nextNode();
                    if (existingEmails.contains(pnode.getName())) continue;
                    pnode.remove();
                }
            }
        }
    }

    protected MoxtraMeet readMeet(Node meetNode) throws RepositoryException, MoxtraClientException, OAuthSystemException, OAuthProblemException, MoxtraException {
        Boolean autorec;
        Date endTime;
        String agenda;
        String binderId = JCR.getId((Node)meetNode).getString();
        String name = JCR.getName((Node)meetNode).getString();
        long revision = JCR.getRevision((Node)meetNode).getLong();
        Date createdTime = JCR.getCreatedTime((Node)meetNode).getDate().getTime();
        Date updatedTime = JCR.getUpdatedTime((Node)meetNode).getDate().getTime();
        try {
            agenda = JCR.getAgenda((Node)meetNode).getString();
        }
        catch (PathNotFoundException e) {
            agenda = null;
        }
        Date startTime = JCR.getStartTime((Node)meetNode).getDate().getTime();
        try {
            endTime = JCR.getEndTime((Node)meetNode).getDate().getTime();
        }
        catch (PathNotFoundException e) {
            endTime = null;
        }
        String startMeetUrl = JCR.getStartMeetUrl((Node)meetNode).getString();
        String sessionKey = JCR.getSessionKey((Node)meetNode).getString();
        try {
            autorec = JCR.getAutoRecording((Node)meetNode).getBoolean();
        }
        catch (PathNotFoundException e) {
            autorec = null;
        }
        ArrayList<MoxtraUser> users = new ArrayList<MoxtraUser>();
        Node usersNode = JCR.getUsers((Node)meetNode);
        NodeIterator piter = usersNode.getNodes();
        while (piter.hasNext()) {
            Node pnode = piter.nextNode();
            users.add(new MoxtraUser(JCR.getId((Node)pnode).getString(), JCR.getName((Node)pnode).getString(), JCR.getEmail((Node)pnode).getString(), JCR.getType((Node)pnode).getString()));
        }
        MoxtraMeet localMeet = MoxtraMeet.create((String)sessionKey, null, (String)binderId, (String)name, (String)agenda, (Long)revision, (String)startMeetUrl, (Date)createdTime, (Date)updatedTime, (Date)startTime, (Date)endTime, (Boolean)autorec, users);
        MoxtraClient moxtra = this.moxtraService.getClient();
        if (moxtra.isAuthorized()) {
            moxtra.refreshMeet(localMeet);
            this.writeMeet(meetNode, localMeet, localMeet.getUsers());
        }
        return localMeet;
    }

    protected String createDownloadJob(CalendarEvent event, MoxtraMeet meet, Node meetNode, Date jobTime) throws Exception {
        String jobName = this.meetJobName(event, meet);
        JobDetailImpl job = new JobDetailImpl();
        job.setName(jobName);
        job.setGroup(MEET_VIDEO_DOWNLOAD_JOB_GROUP_NAME);
        job.setJobClass(MoxtraMeetDownloadJob.class);
        job.setDescription("Download meet video in job");
        String userName = ConversationState.getCurrent().getIdentity().getUserId();
        job.getJobDataMap().put("user_id", userName);
        job.getJobDataMap().put("calendar_id", event.getCalendarId());
        job.getJobDataMap().put("event_id", event.getId());
        SimpleTriggerImpl trigger = new SimpleTriggerImpl();
        trigger.setName(jobName);
        trigger.setGroup(MEET_VIDEO_DOWNLOAD_JOB_GROUP_NAME);
        if (jobTime != null) {
            trigger.setStartTime(jobTime);
        } else {
            java.util.Calendar downloadTime = Moxtra.getCalendar();
            downloadTime.setTime(meet.getEndTime());
            downloadTime.add(12, 7);
            trigger.setStartTime(downloadTime.getTime());
        }
        this.jobEnvironment.configure(userName);
        this.schedulerService.addJob((JobDetail)job, (Trigger)trigger);
        return jobName;
    }

    protected void updateDownloadJob(CalendarEvent event, MoxtraMeet meet) throws Exception {
        String jobName = this.meetJobName(event, meet);
        SimpleTriggerImpl trigger = new SimpleTriggerImpl();
        trigger.setName(jobName);
        trigger.setGroup(MEET_VIDEO_DOWNLOAD_JOB_GROUP_NAME);
        java.util.Calendar downloadTime = java.util.Calendar.getInstance();
        downloadTime.setTime(meet.getEndTime());
        downloadTime.add(12, 7);
        trigger.setStartTime(downloadTime.getTime());
        this.schedulerService.rescheduleJob(jobName, MEET_VIDEO_DOWNLOAD_JOB_GROUP_NAME, (Trigger)trigger);
    }

    protected void removeDownloadJob(CalendarEvent event, MoxtraMeet meet) throws Exception {
        String jobName = this.meetJobName(event, meet);
        JobInfo jobInfo = new JobInfo(jobName, MEET_VIDEO_DOWNLOAD_JOB_GROUP_NAME, MoxtraMeetDownloadJob.class);
        this.schedulerService.removeJob(jobInfo);
    }

    protected String meetJobName(CalendarEvent event, MoxtraMeet meet) {
        return "Meet_" + meet.getSessionKey() + "@" + event.getId() + "." + event.getCalendarId();
    }

    protected Node getUserDocumentsNode(String userName) throws Exception {
        for (DriveData userDrive : this.driveService.getPersonalDrives(userName)) {
            String homePath = userDrive.getHomePath();
            if (!userDrive.getHomePath().endsWith("/Private")) continue;
            SessionProvider sessionProvider = this.sessionProviderService.getSystemSessionProvider(null);
            Node userNode = this.hierarchyCreator.getUserNode(sessionProvider, userName);
            String driveRootPath = Utils.getPersonalDrivePath((String)homePath, (String)userName);
            String driveSubPath = driveRootPath.substring(userNode.getPath().length());
            return userNode.getNode(driveSubPath);
        }
        return null;
    }

    protected Node getSpaceDocumentsNode(String userName, String groupName) throws Exception {
        DriveData groupDrive = this.driveService.getDriveByName(groupName);
        SessionProvider sessionProvider = this.sessionProviderService.getSystemSessionProvider(null);
        Session session = this.hierarchyCreator.getUserNode(sessionProvider, userName).getSession();
        return (Node)session.getItem(groupDrive.getHomePath() + "/Documents");
    }

    protected Node getMeetingsFolder(Node parent, String name) throws RepositoryException {
        Node meetings;
        try {
            meetings = parent.getNode(name);
        }
        catch (PathNotFoundException e) {
            meetings = parent.addNode(name, "nt:folder");
            parent.save();
        }
        return meetings;
    }

    @Deprecated
    protected java.util.Calendar getUserMoxtraCalendar() throws Exception {
        CalendarSetting setting = this.getCalendarSetting();
        java.util.Calendar calendar = Moxtra.getCalendar();
        calendar.setLenient(false);
        calendar.setFirstDayOfWeek(Integer.parseInt(setting.getWeekStartOn()));
        calendar.setMinimalDaysInFirstWeek(4);
        return calendar;
    }

    protected MoxtraUser getHostUser(MoxtraMeet meet) {
        block3: {
            if (!meet.isNew()) {
                try {
                    return meet.getHostUser();
                }
                catch (MoxtraException e) {
                    if (!LOG.isDebugEnabled()) break block3;
                    LOG.warn((Object)("Cannot get host user from meet " + meet), (Throwable)e);
                }
            }
        }
        return null;
    }

    protected class Environment {
        protected final Map<String, UserSettings> config = new ConcurrentHashMap<String, UserSettings>();

        protected Environment() {
        }

        protected void configure(String userName) throws MoxtraCalendarException {
            ConversationState conversation = ConversationState.getCurrent();
            if (conversation == null) {
                throw new MoxtraCalendarException("Error configuring user environment for " + userName + ". User identity not set.");
            }
            this.config.put(userName, new UserSettings(conversation, ExoContainerContext.getCurrentContainer()));
        }

        protected void prepare(String userName) throws MoxtraCalendarException {
            UserSettings settings = this.config.get(userName);
            if (settings == null) {
                throw new MoxtraCalendarException("User setting not configured to prepare " + userName + " environment.");
            }
            settings.prevConversation = ConversationState.getCurrent();
            ConversationState.setCurrent((ConversationState)settings.conversation);
            settings.prevContainer = ExoContainerContext.getCurrentContainerIfPresent();
            ExoContainerContext.setCurrentContainer((ExoContainer)settings.container);
            settings.prevSessions = MoxtraCalendarService.this.sessionProviderService.getSessionProvider(null);
            SessionProvider sp = new SessionProvider(settings.conversation);
            MoxtraCalendarService.this.sessionProviderService.setSessionProvider(null, sp);
        }

        protected void cleanup(String userName) throws MoxtraCalendarException {
            UserSettings settings = this.config.get(userName);
            if (settings == null) {
                throw new MoxtraCalendarException("User setting not configured to clean " + userName + " environment.");
            }
            ConversationState.setCurrent((ConversationState)settings.prevConversation);
            ExoContainerContext.setCurrentContainer((ExoContainer)settings.prevContainer);
            SessionProvider sp = MoxtraCalendarService.this.sessionProviderService.getSessionProvider(null);
            MoxtraCalendarService.this.sessionProviderService.setSessionProvider(null, settings.prevSessions);
            sp.close();
        }
    }

    protected class UserSettings {
        final ConversationState conversation;
        final ExoContainer container;
        ConversationState prevConversation;
        ExoContainer prevContainer;
        SessionProvider prevSessions;

        UserSettings(ConversationState conversation, ExoContainer container) {
            this.conversation = conversation;
            this.container = container;
        }
    }
}

