/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.moxtra.client;

import java.util.Date;

public class MoxtraUser {
    public static final String USER_TYPE_NORMAL = "USER_TYPE_NORMAL";
    protected final String id;
    protected final String name;
    protected final String email;
    protected final String firstName;
    protected final String lastName;
    protected final String type;
    protected final String status;
    protected final Date createdTime;
    protected final Date updatedTime;
    protected final int hashCode;

    public MoxtraUser(String id, String name, String email, String firstName, String lastName, String type, String status, Date createdTime, Date updatedTime) {
        this.email = email;
        this.id = id;
        this.name = name != null && name.length() > 0 ? name : (email != null && email.length() > 0 ? email : id);
        this.firstName = firstName;
        this.lastName = lastName;
        this.type = type != null ? type : USER_TYPE_NORMAL;
        this.status = status;
        this.createdTime = createdTime;
        this.updatedTime = updatedTime;
        int hc = 1;
        if (id != null) {
            hc = hc * 31 + id.hashCode();
        }
        hc = hc * 31 + name.hashCode();
        hc = hc * 31 + email.hashCode();
        if (type != null) {
            hc = hc * 31 + type.hashCode();
        }
        if (createdTime != null) {
            hc = hc * 31 + createdTime.hashCode();
        }
        if (updatedTime != null) {
            hc = hc * 31 + updatedTime.hashCode();
        }
        this.hashCode = hc;
    }

    public MoxtraUser(String id, String name, String email) {
        this(id, name, email, null, null, USER_TYPE_NORMAL, null, null, null);
    }

    public MoxtraUser(String id, String name, String email, String type) {
        this(id, name, email, null, null, type, null, null, null);
    }

    public MoxtraUser(String email) {
        this(email, email, email, null, null, USER_TYPE_NORMAL, null, null, null);
    }

    public MoxtraUser(String name, String email) {
        this(email, name, email, null, null, USER_TYPE_NORMAL, null, null, null);
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof MoxtraUser) {
            return this.isSameUser((MoxtraUser)obj);
        }
        return false;
    }

    public String toString() {
        String name = this.getName();
        String email = this.getEmail();
        String id = this.getId();
        if (email != null && (email.equals(id) || email.equals(name))) {
            return email;
        }
        StringBuilder str = new StringBuilder();
        str.append(name);
        str.append(" (");
        str.append(email);
        str.append(") ");
        str.append(id);
        return str.toString();
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getEmail() {
        return this.email;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getType() {
        return this.type;
    }

    public String getStatus() {
        return this.status;
    }

    public Date getCreatedTime() {
        return this.createdTime;
    }

    public Date getUpdatedTime() {
        return this.updatedTime;
    }

    protected boolean isSameUser(MoxtraUser user) {
        String id = this.getId();
        if (id != null && id.equals(user.getId())) {
            return true;
        }
        String email = this.getEmail();
        return email != null && email.equals(user.getEmail());
    }
}

