/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.moxtra.webui.component;

import org.exoplatform.moxtra.webui.MoxtraAction;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.input.UICheckBoxInput;

@ComponentConfig(events={@EventConfig(listeners={OnChangeActionListener.class})})
public class UIActionCheckBoxInput
extends UICheckBoxInput {
    public static final String ACTION_ON_CHANGE = "OnChange".intern();
    protected static final Log LOG = ExoLogger.getLogger(UIActionCheckBoxInput.class);
    protected MoxtraAction<Event<UIActionCheckBoxInput>, Boolean> action;
    protected boolean disabled;

    public UIActionCheckBoxInput() {
        super(UIActionCheckBoxInput.class.getSimpleName(), UIActionCheckBoxInput.class.getSimpleName(), Boolean.valueOf(false));
    }

    public void initMoxtra(MoxtraAction<Event<UIActionCheckBoxInput>, Boolean> action, boolean disabled, boolean initialValue) {
        this.action = action;
        this.setDisabled(disabled);
        this.setChecked(initialValue);
        this.setOnChange(ACTION_ON_CHANGE);
    }

    public String renderOnChangeEvent(UIForm uiForm) throws Exception {
        return this.event(ACTION_ON_CHANGE, String.valueOf(!this.isChecked()));
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        super.processRender(context);
    }

    protected MoxtraAction<Event<UIActionCheckBoxInput>, Boolean> action() {
        return this.action;
    }

    public static class OnChangeActionListener
    extends EventListener<UIActionCheckBoxInput> {
        public void execute(Event<UIActionCheckBoxInput> event) throws Exception {
            UIActionCheckBoxInput checkbox = (UIActionCheckBoxInput)((Object)event.getSource());
            checkbox.setChecked(Boolean.parseBoolean(event.getRequestContext().getRequestParameter("objectId")));
            boolean checked = checkbox.action().execute(event);
            if (checked != checkbox.isChecked()) {
                checkbox.setChecked(checked);
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)checkbox);
            }
        }
    }
}

