/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.onlyoffice.rest;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.security.RolesAllowed;
import javax.jcr.RepositoryException;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.exoplatform.onlyoffice.BadParameterException;
import org.exoplatform.onlyoffice.ChangeState;
import org.exoplatform.onlyoffice.Config;
import org.exoplatform.onlyoffice.DocumentContent;
import org.exoplatform.onlyoffice.DocumentStatus;
import org.exoplatform.onlyoffice.OnlyofficeEditorException;
import org.exoplatform.onlyoffice.OnlyofficeEditorService;
import org.exoplatform.onlyoffice.rest.DriveServiceLocator;
import org.exoplatform.onlyoffice.rest.ServiceResponse;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

@Path(value="/onlyoffice/editor")
public class EditorService
implements ResourceContainer {
    public static final String INIT_COOKIE_PATH = "/portal/rest/onlyoffice/editor";
    protected static final Log LOG = ExoLogger.getLogger(EditorService.class);
    protected final OnlyofficeEditorService editors;
    protected final DriveServiceLocator locator;
    protected final Map<UUID, Config> initiated = new ConcurrentHashMap<UUID, Config>();

    public EditorService(OnlyofficeEditorService editors, DriveServiceLocator locator) {
        this.editors = editors;
        this.locator = locator;
    }

    @POST
    @Path(value="/status/{userId}/{key}")
    @Produces(value={"application/json"})
    public Response status(@Context UriInfo uriInfo, @Context HttpServletRequest request, @PathParam(value="userId") String userId, @PathParam(value="key") String key, String statusText) {
        EditorResponse resp;
        block13: {
            String clientHost = this.getClientHost(request);
            String clientIp = this.getClientIpAddr(request);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("> Onlyoffice document status: " + userId + "@" + key + " " + statusText + " from " + clientHost + "(" + clientIp + ")"));
            }
            resp = new EditorResponse();
            if (this.editors.canDownloadBy(clientHost) || this.editors.canDownloadBy(clientIp)) {
                try {
                    DocumentStatus status = new DocumentStatus();
                    JSONParser parser = new JSONParser();
                    Object obj = parser.parse(statusText);
                    JSONObject jsonObj = (JSONObject)obj;
                    String statusKey = (String)jsonObj.get((Object)"key");
                    long statusCode = (Long)jsonObj.get((Object)"status");
                    String statusUrl = (String)jsonObj.get((Object)"url");
                    JSONArray statusUsersArray = (JSONArray)jsonObj.get((Object)"users");
                    Object[] statusUsers = new String[statusUsersArray.size()];
                    statusUsersArray.toArray(statusUsers);
                    if (key != null && key.length() > 0) {
                        if (userId != null && userId.length() > 0) {
                            status.setKey(statusKey != null && statusKey.length() > 0 ? statusKey : key);
                            status.setStatus(statusCode);
                            status.setUrl(statusUrl);
                            status.setUsers((String[])statusUsers);
                            try {
                                this.editors.updateDocument(userId, status);
                                resp.entity("{\"error\": 0}");
                            }
                            catch (BadParameterException e) {
                                LOG.error((Object)("Bad parameter to update status for " + key), (Throwable)e);
                                resp.error(e.getMessage()).status(Response.Status.BAD_REQUEST);
                            }
                            catch (OnlyofficeEditorException e) {
                                LOG.error((Object)("Error handling status for " + key), (Throwable)e);
                                resp.error("Error handling status. " + e.getMessage()).status(Response.Status.INTERNAL_SERVER_ERROR);
                            }
                            catch (RepositoryException e) {
                                LOG.error((Object)("Storage error while handling status for " + key), (Throwable)e);
                                resp.error("Storage error.").status(Response.Status.INTERNAL_SERVER_ERROR);
                            }
                            catch (Throwable e) {
                                LOG.error((Object)("Runtime error while handling status for " + key), e);
                                resp.error("Runtime error.").status(Response.Status.INTERNAL_SERVER_ERROR);
                            }
                        } else {
                            LOG.error((Object)"Error processing editor status. User not provided");
                            resp.error("User not provided").status(Response.Status.BAD_REQUEST);
                        }
                        break block13;
                    }
                    resp.status(Response.Status.BAD_REQUEST).error("Null or empty file key.");
                }
                catch (ParseException e) {
                    LOG.error((Object)("JSON parse error while handling status for " + key + ". JSON: " + statusText), (Throwable)e);
                    resp.error("JSON parse error: " + e.getMessage()).status(Response.Status.BAD_REQUEST);
                }
            } else {
                LOG.warn((Object)("Attempt to update status by not allowed host: " + clientHost));
                resp.error("Not a document server").status(Response.Status.UNAUTHORIZED);
            }
        }
        return resp.build();
    }

    @GET
    @Path(value="/content/{userId}/{key}")
    public Response content(@Context UriInfo uriInfo, @Context HttpServletRequest request, @PathParam(value="userId") String userId, @PathParam(value="key") String key) {
        EditorResponse resp;
        block11: {
            String clientHost = this.getClientHost(request);
            String clientIp = this.getClientIpAddr(request);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("> Onlyoffice document content: " + userId + "@" + key + " to " + clientHost + "(" + clientIp + ")"));
            }
            resp = new EditorResponse();
            if (this.editors.canDownloadBy(clientHost) || this.editors.canDownloadBy(clientIp)) {
                if (key != null && key.length() > 0) {
                    try {
                        if (userId != null && userId.length() > 0) {
                            DocumentContent content = this.editors.getContent(userId, key);
                            resp.entity(content.getData()).type(content.getType()).ok();
                            break block11;
                        }
                        LOG.error((Object)"Error downloading content. User identity not provided");
                        resp.error("User not provided").status(Response.Status.BAD_REQUEST);
                    }
                    catch (BadParameterException e) {
                        LOG.error((Object)("Bad parameter to downloading content for " + key), (Throwable)e);
                        resp.error(e.getMessage()).status(Response.Status.BAD_REQUEST);
                    }
                    catch (OnlyofficeEditorException e) {
                        LOG.error((Object)("Error downloading content for " + key), (Throwable)e);
                        resp.error("Error downloading content. " + e.getMessage()).status(Response.Status.INTERNAL_SERVER_ERROR);
                    }
                    catch (RepositoryException e) {
                        LOG.error((Object)("Storage error while downloading content for " + key), (Throwable)e);
                        resp.error("Storage error.").status(Response.Status.INTERNAL_SERVER_ERROR);
                    }
                    catch (Throwable e) {
                        LOG.error((Object)("Runtime error while downloading content for " + key), e);
                        resp.error("Runtime error.").status(Response.Status.INTERNAL_SERVER_ERROR);
                    }
                } else {
                    resp.status(Response.Status.BAD_REQUEST).error("Null or empty file key.");
                }
            } else {
                LOG.warn((Object)("Attempt to download content by not allowed host: " + clientHost));
                resp.error("Not a document server").status(Response.Status.UNAUTHORIZED);
            }
        }
        return resp.build();
    }

    @GET
    @Path(value="/config/{workspace}/{path:.*}")
    @RolesAllowed(value={"users"})
    @Produces(value={"application/json"})
    public Response config(@Context UriInfo uriInfo, @PathParam(value="workspace") String workspace, @PathParam(value="path") String path) {
        EditorResponse resp;
        block13: {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("> Onlyoffice config: " + workspace + ":" + path));
            }
            resp = new EditorResponse();
            if (workspace != null) {
                if (path != null) {
                    if (!path.startsWith("/")) {
                        path = "/" + path;
                    }
                    try {
                        ConversationState convo = ConversationState.getCurrent();
                        if (convo != null) {
                            String username = convo.getIdentity().getUserId();
                            Config config = this.editors.createEditor(username, workspace, path);
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)("> Onlyoffice document config: " + workspace + ":" + path + " -> " + config.getDocument().getKey()));
                            }
                            resp.config(config).ok();
                            break block13;
                        }
                        LOG.warn((Object)"ConversationState not set to create editor config");
                        resp.error("User not authenticated").status(Response.Status.UNAUTHORIZED);
                    }
                    catch (BadParameterException e) {
                        LOG.error((Object)("Bad parameter for creating editor config " + workspace + ":" + path), (Throwable)e);
                        resp.error(e.getMessage()).status(Response.Status.BAD_REQUEST);
                    }
                    catch (OnlyofficeEditorException e) {
                        LOG.error((Object)("Error creating editor config " + workspace + ":" + path), (Throwable)e);
                        resp.error("Error creating editor config. " + e.getMessage()).status(Response.Status.INTERNAL_SERVER_ERROR);
                    }
                    catch (RepositoryException e) {
                        LOG.error((Object)("Storage error while creating editor config " + workspace + ":" + path), (Throwable)e);
                        resp.error("Storage error.").status(Response.Status.INTERNAL_SERVER_ERROR);
                    }
                    catch (Throwable e) {
                        LOG.error((Object)("Runtime error while creating editor config " + workspace + ":" + path), e);
                        resp.error("Error creating editor config.").status(Response.Status.INTERNAL_SERVER_ERROR);
                    }
                } else {
                    resp.status(Response.Status.BAD_REQUEST).error("Null path.");
                }
            } else {
                resp.status(Response.Status.BAD_REQUEST).error("Null workspace.");
            }
        }
        return resp.build();
    }

    @GET
    @Path(value="/state/{userId}/{key}")
    @RolesAllowed(value={"users"})
    @Produces(value={"application/json"})
    public Response localState(@Context UriInfo uriInfo, @PathParam(value="userId") String userId, @PathParam(value="key") String key) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("> localState: " + userId + "@" + key));
        }
        EditorResponse resp = new EditorResponse();
        if (userId != null) {
            if (key != null) {
                try {
                    ChangeState status = this.editors.getState(userId, key);
                    resp.entity(status).ok();
                }
                catch (BadParameterException e) {
                    LOG.error((Object)("Bad parameter for getting document state " + userId + "@" + key), (Throwable)e);
                    resp.error(e.getMessage()).status(Response.Status.BAD_REQUEST);
                }
                catch (OnlyofficeEditorException e) {
                    LOG.error((Object)("Error getting document state " + userId + "@" + key), (Throwable)e);
                    resp.error("Error getting document state. " + e.getMessage()).status(Response.Status.INTERNAL_SERVER_ERROR);
                }
                catch (Throwable e) {
                    LOG.error((Object)("Runtime error while getting document state " + userId + "@" + key), e);
                    resp.error("Error getting document state.").status(Response.Status.INTERNAL_SERVER_ERROR);
                }
            } else {
                resp.status(Response.Status.BAD_REQUEST).error("Null or empty file key.");
            }
        } else {
            LOG.error((Object)"Error getting document state. User identity not provided");
            resp.error("User not provided").status(Response.Status.BAD_REQUEST);
        }
        return resp.build();
    }

    protected String getClientIpAddr(HttpServletRequest request) {
        String ip = request.getHeader("X-Forwarded-For");
        if (this.isValidName(ip)) {
            return ip;
        }
        ip = request.getHeader("Proxy-Client-IP");
        if (this.isValidName(ip)) {
            return ip;
        }
        ip = request.getHeader("WL-Proxy-Client-IP");
        if (this.isValidName(ip)) {
            return ip;
        }
        ip = request.getHeader("HTTP_CLIENT_IP");
        if (this.isValidName(ip)) {
            return ip;
        }
        ip = request.getHeader("HTTP_X_FORWARDED_FOR");
        if (this.isValidName(ip)) {
            return ip;
        }
        ip = request.getHeader("HTTP_X_FORWARDED");
        if (this.isValidName(ip)) {
            return ip;
        }
        ip = request.getHeader("HTTP_X_CLUSTER_CLIENT_IP");
        if (this.isValidName(ip)) {
            return ip;
        }
        ip = request.getHeader("HTTP_FORWARDED_FOR");
        if (this.isValidName(ip)) {
            return ip;
        }
        ip = request.getHeader("HTTP_FORWARDED");
        if (this.isValidName(ip)) {
            return ip;
        }
        ip = request.getHeader("REMOTE_ADDR");
        if (this.isValidName(ip)) {
            return ip;
        }
        ip = request.getRemoteAddr();
        if (this.isValidName(ip)) {
            return ip;
        }
        return null;
    }

    protected String getClientHost(HttpServletRequest request) {
        String host = request.getHeader("X-Forwarded-Host");
        if (this.isValidName(host)) {
            return host;
        }
        host = request.getRemoteHost();
        if (this.isValidName(host)) {
            return host;
        }
        return null;
    }

    protected boolean isValidName(String hostName) {
        return hostName != null && hostName.length() > 0 && !"unknown".equalsIgnoreCase(hostName);
    }

    class EditorResponse
    extends ServiceResponse {
        Config config;
        String error;

        EditorResponse() {
        }

        EditorResponse config(Config config) {
            this.config = config;
            return this;
        }

        EditorResponse error(String error) {
            this.error = error;
            return this;
        }

        EditorResponse error(String error, String host) {
            this.error = error;
            return this;
        }

        @Override
        Response build() {
            if (this.config != null) {
                super.entity(this.config);
            } else if (this.error != null) {
                super.entity("{\"error\":\"" + this.error + "\"}");
            }
            return super.build();
        }
    }
}

