/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.onlyoffice.webui;

import java.util.Arrays;
import java.util.List;
import org.exoplatform.ecm.webui.component.explorer.UIDocumentWorkspace;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.control.UIActionBar;
import org.exoplatform.onlyoffice.webui.CanOpenOnlyofficeFilter;
import org.exoplatform.onlyoffice.webui.OnlyofficeEditorContext;
import org.exoplatform.onlyoffice.webui.OnlyofficeEditorUIService;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.web.application.Parameter;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIContainerLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.ext.filter.UIExtensionFilter;
import org.exoplatform.webui.ext.filter.UIExtensionFilters;
import org.exoplatform.webui.ext.manager.UIAbstractManager;
import org.exoplatform.webui.ext.manager.UIAbstractManagerComponent;

@ComponentConfig(lifecycle=UIContainerLifecycle.class, events={@EventConfig(listeners={OnlyofficeOpenActionListener.class})})
public class OnlyofficeOpenManageComponent
extends UIAbstractManagerComponent {
    protected static final Log LOG = ExoLogger.getLogger(OnlyofficeOpenManageComponent.class);
    private static final List<UIExtensionFilter> FILTERS = Arrays.asList(new UIExtensionFilter[]{new CanOpenOnlyofficeFilter()});

    @UIExtensionFilters
    public List<UIExtensionFilter> getFilters() {
        return FILTERS;
    }

    public String renderEventURL(boolean ajax, String name, String beanId, Parameter[] params) throws Exception {
        this.initContext(PortalRequestContext.getCurrentInstance());
        return super.renderEventURL(ajax, name, beanId, params);
    }

    protected void initContext(RequestContext context) throws Exception {
        UIJCRExplorer uiExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
        if (uiExplorer != null) {
            String path = uiExplorer.getCurrentNode().getPath();
            String workspace = uiExplorer.getCurrentNode().getSession().getWorkspace().getName();
            OnlyofficeEditorContext.init(context, workspace, path);
        } else {
            LOG.error((Object)("Cannot find ancestor of type UIJCRExplorer in component " + (Object)((Object)this) + ", parent: " + this.getParent()));
        }
    }

    public Class<? extends UIAbstractManager> getUIAbstractManagerClass() {
        return null;
    }

    public static class OnlyofficeOpenActionListener
    extends EventListener<OnlyofficeOpenManageComponent> {
        public void execute(Event<OnlyofficeOpenManageComponent> event) throws Exception {
            WebuiRequestContext context = event.getRequestContext();
            UIJCRExplorer explorer = (UIJCRExplorer)((OnlyofficeOpenManageComponent)((Object)event.getSource())).getAncestorOfType(UIJCRExplorer.class);
            OnlyofficeEditorUIService editorsUI = (OnlyofficeEditorUIService)WCMCoreUtils.getService(OnlyofficeEditorUIService.class);
            String workspace = explorer.getCurrentWorkspace();
            String path = explorer.getCurrentNode().getPath();
            editorsUI.open(context.getRemoteUser(), workspace, path);
            OnlyofficeEditorContext.init((RequestContext)context, workspace, path);
            OnlyofficeEditorContext.open((RequestContext)context);
            UIDocumentWorkspace docWorkspace = (UIDocumentWorkspace)explorer.findFirstComponentOfType(UIDocumentWorkspace.class);
            context.addUIComponentToUpdateByAjax((UIComponent)docWorkspace);
            UIActionBar actionBar = (UIActionBar)explorer.findFirstComponentOfType(UIActionBar.class);
            context.addUIComponentToUpdateByAjax((UIComponent)actionBar);
        }
    }
}

