/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.onlyoffice;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.locks.ReentrantLock;
import javax.jcr.AccessDeniedException;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.lock.Lock;
import org.apache.commons.io.input.AutoCloseInputStream;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.configuration.ConfigurationException;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.onlyoffice.BadParameterException;
import org.exoplatform.onlyoffice.ChangeState;
import org.exoplatform.onlyoffice.Config;
import org.exoplatform.onlyoffice.ConflictException;
import org.exoplatform.onlyoffice.DocumentContent;
import org.exoplatform.onlyoffice.DocumentStatus;
import org.exoplatform.onlyoffice.OnlyofficeEditorException;
import org.exoplatform.onlyoffice.OnlyofficeEditorListener;
import org.exoplatform.onlyoffice.OnlyofficeEditorService;
import org.exoplatform.onlyoffice.jcr.NodeFinder;
import org.exoplatform.services.cache.CacheListener;
import org.exoplatform.services.cache.CacheListenerContext;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserProfile;
import org.exoplatform.services.organization.UserProfileHandler;
import org.exoplatform.services.security.Authenticator;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityRegistry;
import org.picocontainer.Startable;

public class OnlyofficeEditorServiceImpl
implements OnlyofficeEditorService,
Startable {
    protected static final Log LOG = ExoLogger.getLogger(OnlyofficeEditorServiceImpl.class);
    protected static final Random RANDOM = new Random();
    public static final String CONFIG_DS_HOST = "documentserver-host";
    public static final String CONFIG_DS_SCHEMA = "documentserver-schema";
    public static final String CONFIG_DS_ACCESS_ONLY = "documentserver-access-only";
    public static final String CONFIG_DS_ALLOWEDHOSTS = "documentserver-allowedhosts";
    protected static final char HTTP_PORT_DELIMITER = ':';
    protected static final String TYPE_TEXT = "text";
    protected static final String TYPE_SPREADSHEET = "spreadsheet";
    protected static final String TYPE_PRESENTATION = "presentation";
    protected static final int LOCK_WAIT_ATTEMTS = 20;
    protected static final long LOCK_WAIT_TIMEOUT = 250L;
    protected static final String EMPTY_TEXT = "".intern();
    public static final String CACHE_NAME = "onlyoffice.EditorCache".intern();
    protected final RepositoryService jcrService;
    protected final SessionProviderService sessionProviders;
    protected final IdentityRegistry identityRegistry;
    protected final NodeFinder finder;
    protected final OrganizationService organization;
    protected final Authenticator authenticator;
    protected final ExoCache<String, ConcurrentHashMap<String, Config>> activeCache;
    protected final ReentrantLock activeLock = new ReentrantLock();
    protected final Map<String, String> config;
    protected final String uploadUrl;
    protected final String documentserverHostName;
    protected final String documentserverUrl;
    protected final boolean documentserverAccessOnly;
    protected final Set<String> documentserverAllowedhosts;
    protected final Map<String, String> fileTypes = new ConcurrentHashMap<String, String>();
    protected final MessageFormat uploadParams = new MessageFormat("?url={0}&outputtype={1}&filetype={2}&title={3}&key={4}");
    protected final ConcurrentLinkedQueue<OnlyofficeEditorListener> listeners = new ConcurrentLinkedQueue();

    public OnlyofficeEditorServiceImpl(RepositoryService jcrService, SessionProviderService sessionProviders, IdentityRegistry identityRegistry, NodeFinder finder, OrganizationService organization, Authenticator authenticator, CacheService cacheService, InitParams params) throws ConfigurationException {
        String dsHost;
        this.jcrService = jcrService;
        this.sessionProviders = sessionProviders;
        this.identityRegistry = identityRegistry;
        this.finder = finder;
        this.organization = organization;
        this.authenticator = authenticator;
        this.activeCache = cacheService.getCacheInstance(CACHE_NAME);
        if (LOG.isDebugEnabled()) {
            this.activeCache.addCacheListener((CacheListener)new CacheListener<String, ConcurrentHashMap<String, Config>>(){

                public void onExpire(CacheListenerContext context, String key, ConcurrentHashMap<String, Config> obj) throws Exception {
                    LOG.debug((Object)(CACHE_NAME + " onExpire > " + key + ": " + obj));
                }

                public void onRemove(CacheListenerContext context, String key, ConcurrentHashMap<String, Config> obj) throws Exception {
                    LOG.debug((Object)(CACHE_NAME + " onRemove > " + key + ": " + obj));
                }

                public void onPut(CacheListenerContext context, String key, ConcurrentHashMap<String, Config> obj) throws Exception {
                    LOG.debug((Object)(CACHE_NAME + " onPut > " + key + ": " + obj));
                }

                public void onGet(CacheListenerContext context, String key, ConcurrentHashMap<String, Config> obj) throws Exception {
                    LOG.debug((Object)(CACHE_NAME + " onGet > " + key + ": " + obj));
                }

                public void onClearCache(CacheListenerContext context) throws Exception {
                    LOG.debug((Object)(CACHE_NAME + " onClearCache"));
                }
            });
        }
        this.fileTypes.put("docx", TYPE_TEXT);
        this.fileTypes.put("doc", TYPE_TEXT);
        this.fileTypes.put("odt", TYPE_TEXT);
        this.fileTypes.put("txt", TYPE_TEXT);
        this.fileTypes.put("rtf", TYPE_TEXT);
        this.fileTypes.put("mht", TYPE_TEXT);
        this.fileTypes.put("html", TYPE_TEXT);
        this.fileTypes.put("htm", TYPE_TEXT);
        this.fileTypes.put("epub", TYPE_TEXT);
        this.fileTypes.put("pdf", TYPE_TEXT);
        this.fileTypes.put("djvu", TYPE_TEXT);
        this.fileTypes.put("xps", TYPE_TEXT);
        this.fileTypes.put("xlsx", TYPE_SPREADSHEET);
        this.fileTypes.put("xls", TYPE_SPREADSHEET);
        this.fileTypes.put("ods", TYPE_SPREADSHEET);
        this.fileTypes.put("pptx", TYPE_PRESENTATION);
        this.fileTypes.put("ppt", TYPE_PRESENTATION);
        this.fileTypes.put("ppsx", TYPE_PRESENTATION);
        this.fileTypes.put("pps", TYPE_PRESENTATION);
        this.fileTypes.put("odp", TYPE_PRESENTATION);
        PropertiesParam param = params.getPropertiesParam("editor-configuration");
        if (param == null) {
            throw new ConfigurationException("Property parameters editor-configuration required.");
        }
        this.config = Collections.unmodifiableMap(param.getProperties());
        String dsSchema = this.config.get(CONFIG_DS_SCHEMA);
        if (dsSchema == null || (dsSchema = dsSchema.trim()).length() == 0) {
            dsSchema = "http";
        }
        if ((dsHost = this.config.get(CONFIG_DS_HOST)) == null || (dsHost = dsHost.trim()).length() == 0) {
            throw new ConfigurationException("Configuration of documentserver-host required");
        }
        int portIndex = dsHost.indexOf(58);
        this.documentserverHostName = portIndex > 0 ? dsHost.substring(0, portIndex) : dsHost;
        this.documentserverAccessOnly = Boolean.parseBoolean(this.config.get(CONFIG_DS_ACCESS_ONLY));
        String dsAllowedHost = this.config.get(CONFIG_DS_ALLOWEDHOSTS);
        if (dsAllowedHost != null && !dsAllowedHost.isEmpty()) {
            HashSet<String> allowedhosts = new HashSet<String>();
            for (String ahost : dsAllowedHost.split(",")) {
                if ((ahost = ahost.trim()).isEmpty()) continue;
                allowedhosts.add(this.lowerCase(ahost));
            }
            this.documentserverAllowedhosts = Collections.unmodifiableSet(allowedhosts);
        } else {
            this.documentserverAllowedhosts = Collections.emptySet();
        }
        StringBuilder documentserverUrl = new StringBuilder();
        documentserverUrl.append(dsSchema);
        documentserverUrl.append("://");
        documentserverUrl.append(dsHost);
        this.uploadUrl = new StringBuilder(documentserverUrl).append("/FileUploader.ashx").toString();
        this.documentserverUrl = new StringBuilder(documentserverUrl).append("/OfficeWeb/").toString();
    }

    @Override
    public void addListener(OnlyofficeEditorListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(OnlyofficeEditorListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public Config getEditor(String userId, String workspace, String path) throws OnlyofficeEditorException, RepositoryException {
        return this.getEditor(userId, this.nodePath(workspace, path), false);
    }

    @Override
    public Config getEditorByKey(String userId, String key) throws OnlyofficeEditorException, RepositoryException {
        Config config;
        ConcurrentHashMap configs = (ConcurrentHashMap)this.activeCache.get((Serializable)((Object)key));
        if (configs != null && (config = (Config)configs.get(userId)) != null) {
            this.validateUser(userId, config);
            return config;
        }
        return null;
    }

    protected Config getEditor(String userId, String nodePath, boolean createCoEditing) throws OnlyofficeEditorException, RepositoryException {
        ConcurrentHashMap configs = (ConcurrentHashMap)this.activeCache.get((Serializable)((Object)nodePath));
        if (configs != null) {
            Config config = (Config)configs.get(userId);
            if (config == null && createCoEditing) {
                try {
                    Config another = (Config)configs.values().iterator().next();
                    User user = this.getUser(userId);
                    if (user != null) {
                        config = another.forUser(user.getUserName(), user.getFirstName(), user.getLastName(), this.getUserLang(userId));
                        Config existing = configs.putIfAbsent(userId, config);
                        if (existing == null) {
                            this.activeCache.put((Serializable)((Object)nodePath), (Object)configs);
                            this.activeCache.put((Serializable)((Object)config.getDocument().getKey()), (Object)configs);
                        } else {
                            config = existing;
                        }
                    } else {
                        LOG.warn((Object)("Attempt to obtain document editor (" + this.nodePath(another) + ") under not existing user " + userId));
                        throw new BadParameterException("User not found for " + another.getDocument().getTitle());
                    }
                    this.fireGet(config);
                }
                catch (NoSuchElementException e) {
                    config = null;
                }
            } else if (createCoEditing) {
                this.fireGet(config);
            }
            return config;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Config createEditor(String schema, String host, String userId, String workspace, String path) throws OnlyofficeEditorException, RepositoryException {
        Node node = this.node(workspace, path);
        String nodePath = this.nodePath(workspace, path);
        if (!node.isNodeType("nt:file")) {
            throw new OnlyofficeEditorException("Only nt:file supported " + nodePath);
        }
        Config config = this.getEditor(userId, nodePath, true);
        if (config == null) {
            block11: {
                this.activeLock.lock();
                try {
                    ConcurrentHashMap<String, Config> configs = (ConcurrentHashMap<String, Config>)this.activeCache.get((Serializable)((Object)nodePath));
                    if (configs != null) {
                        config = this.getEditor(userId, nodePath, true);
                        if (config == null) {
                            throw new ConflictException("Cannot obtain configuration for already existing editor");
                        }
                        break block11;
                    }
                    User user = this.getUser(userId);
                    String fileType = this.fileType(node);
                    String docType = this.documentType(fileType);
                    Config.Builder builder = Config.editor(this.documentserverUrl, workspace, path, docType);
                    builder.author(userId);
                    builder.fileType(fileType);
                    builder.created(this.nodeCreated(node));
                    try {
                        builder.folder(node.getParent().getName());
                    }
                    catch (AccessDeniedException e) {
                        String owner;
                        try {
                            owner = node.getProperty("exo:owner").getString();
                        }
                        catch (PathNotFoundException oe) {
                            owner = "?";
                        }
                        LOG.warn((Object)("Cannot read document parent node: " + this.nodePath(workspace, node.getPath() + ". Owner: " + owner + ". Error: " + e.getMessage())));
                        builder.folder(EMPTY_TEXT);
                    }
                    builder.lang(this.getUserLang(userId));
                    builder.mode("edit");
                    builder.title(this.nodeTitle(node));
                    builder.userId(user.getUserName());
                    builder.userFirstName(user.getFirstName());
                    builder.userLastName(user.getLastName());
                    String key = this.generateId(workspace, path).toString();
                    builder.key(key);
                    builder.generateUrls(this.editorUrl(schema, host).toString());
                    config = builder.build();
                    configs = new ConcurrentHashMap<String, Config>();
                    configs.put(userId, config);
                    this.activeCache.put((Serializable)((Object)nodePath), configs);
                    this.activeCache.put((Serializable)((Object)key), configs);
                }
                finally {
                    this.activeLock.unlock();
                }
            }
            this.fireCreated(config);
        }
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DocumentContent getContent(String userId, String key) throws OnlyofficeEditorException, RepositoryException {
        ConcurrentHashMap configs = (ConcurrentHashMap)this.activeCache.get((Serializable)((Object)key));
        if (configs != null) {
            Config config = (Config)configs.get(userId);
            if (config != null) {
                this.validateUser(userId, config);
                ConversationState contextState = ConversationState.getCurrent();
                SessionProvider contextProvider = this.sessionProviders.getSessionProvider(null);
                try {
                    Identity userIdentity = this.userIdentity(userId);
                    if (userIdentity == null) {
                        LOG.warn((Object)("User identity not found " + userId + " for content of " + config.getDocument().getKey() + " " + config.getPath()));
                        throw new OnlyofficeEditorException("User identity not found " + userId);
                    }
                    ConversationState state = new ConversationState(userIdentity);
                    state.setAttribute("subject", (Object)userIdentity.getSubject());
                    ConversationState.setCurrent((ConversationState)state);
                    SessionProvider userProvider = new SessionProvider(state);
                    this.sessionProviders.setSessionProvider(null, userProvider);
                    Node node = this.node(config.getWorkspace(), config.getPath());
                    Node content = this.nodeContent(node);
                    final String mimeType = content.getProperty("jcr:mimeType").getString();
                    AutoCloseInputStream data = new AutoCloseInputStream(content.getProperty("jcr:data").getStream());
                    DocumentContent documentContent = new DocumentContent((InputStream)data){
                        final /* synthetic */ InputStream val$data;
                        {
                            this.val$data = inputStream;
                        }

                        @Override
                        public String getType() {
                            return mimeType;
                        }

                        @Override
                        public InputStream getData() {
                            return this.val$data;
                        }
                    };
                    return documentContent;
                }
                finally {
                    ConversationState.setCurrent((ConversationState)contextState);
                    this.sessionProviders.setSessionProvider(null, contextProvider);
                }
            }
            throw new BadParameterException("User editor not found or already closed " + userId);
        }
        throw new BadParameterException("File key not found " + key);
    }

    @Override
    public boolean canDownloadBy(String hostName) {
        if (this.documentserverAccessOnly) {
            return this.documentserverHostName.equalsIgnoreCase(hostName) || this.documentserverAllowedhosts.contains(this.lowerCase(hostName));
        }
        return true;
    }

    @Override
    public ChangeState getState(String userId, String key) throws OnlyofficeEditorException {
        ConcurrentHashMap configs = (ConcurrentHashMap)this.activeCache.get((Serializable)((Object)key));
        if (configs != null) {
            Config config = (Config)configs.get(userId);
            if (config != null) {
                this.validateUser(userId, config);
                String[] users = this.getActiveUsers(configs);
                return new ChangeState(false, config.getError(), users);
            }
            throw new BadParameterException("User editor not found " + userId);
        }
        return new ChangeState(true, null, new String[0]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void updateDocument(String userId, DocumentStatus status) throws OnlyofficeEditorException, RepositoryException {
        String key = status.getKey();
        ConcurrentHashMap configs = (ConcurrentHashMap)this.activeCache.get((Serializable)((Object)key));
        if (configs == null) throw new BadParameterException("File key not found " + key);
        Config config = (Config)configs.get(userId);
        if (config == null) throw new BadParameterException("User editor not found " + userId);
        this.validateUser(userId, config);
        String nodePath = this.nodePath(config.getWorkspace(), config.getPath());
        long statusCode = status.getStatus();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(">> Onlyoffice status " + statusCode + " for " + key + ". URL: " + status.getUrl() + ". Users: " + Arrays.toString(status.getUsers()) + " << Local file: " + nodePath));
        }
        if (statusCode == 0L) {
            this.activeCache.remove((Serializable)((Object)key));
            this.activeCache.remove((Serializable)((Object)nodePath));
            LOG.warn((Object)("Received Onlyoffice status: no document with the key identifier could be found. Key: " + key + ". Document " + nodePath));
            throw new OnlyofficeEditorException("Error editing document: document ID not found");
        }
        if (statusCode == 1L) {
            String[] users = status.getUsers();
            if (!this.syncUsers(configs, users)) return;
            this.activeCache.put((Serializable)((Object)key), (Object)configs);
            this.activeCache.put((Serializable)((Object)nodePath), (Object)configs);
            return;
        } else if (statusCode == 2L) {
            this.download(config, status);
            this.activeCache.remove((Serializable)((Object)key));
            this.activeCache.remove((Serializable)((Object)nodePath));
            return;
        } else if (statusCode == 3L) {
            this.syncUsers(configs, status.getUsers());
            if (configs.size() <= 1) {
                String url = status.getUrl();
                if (url != null && url.length() > 0) {
                    this.download(config, status);
                    this.activeCache.remove((Serializable)((Object)key));
                    this.activeCache.remove((Serializable)((Object)nodePath));
                    config.setError("Error in editor. Last change was successfully saved");
                    this.fireError(config);
                    LOG.warn((Object)("Received Onlyoffice error of saving document. Key: " + key + ". Users: " + Arrays.toString(status.getUsers()) + ". Last change was successfully saved for " + nodePath));
                    return;
                } else {
                    LOG.warn((Object)("Received Onlyoffice error of saving document without changes URL. Key: " + key + ". Users: " + Arrays.toString(status.getUsers()) + ". Document " + nodePath));
                    config.setError("Error in editor. No changes saved");
                    this.activeCache.put((Serializable)((Object)key), (Object)configs);
                    this.activeCache.put((Serializable)((Object)nodePath), (Object)configs);
                    this.fireError(config);
                }
                return;
            } else {
                LOG.warn((Object)("Received Onlyoffice error of saving document with several editors. Key: " + key + ". Users: " + Arrays.toString(status.getUsers()) + ". Document " + nodePath));
                config.setError("Error in editor. Document still in editing state");
                this.activeCache.put((Serializable)((Object)key), (Object)configs);
                this.activeCache.put((Serializable)((Object)nodePath), (Object)configs);
                this.fireError(config);
            }
            return;
        } else if (statusCode == 4L) {
            this.syncUsers(configs, status.getUsers());
            this.activeCache.remove((Serializable)((Object)key));
            this.activeCache.remove((Serializable)((Object)nodePath));
            return;
        } else {
            LOG.warn((Object)("Received Onlyoffice unexpected status. Key: " + key + ". URL: " + status.getUrl() + ". Users: " + status.getUsers() + ". Document " + nodePath));
        }
    }

    public void start() {
        LOG.info((Object)"Onlyoffice Editor service successfuly started");
    }

    public void stop() {
        LOG.info((Object)"Onlyoffice  Editor service successfuly stopped");
    }

    protected String nodeTitle(Node node) throws RepositoryException {
        String title = null;
        if (node.hasProperty("exo:title")) {
            title = node.getProperty("exo:title").getString();
        } else if (node.hasProperty("jcr:content/dc:title")) {
            Property dcTitle = node.getProperty("jcr:content/dc:title");
            if (dcTitle.getDefinition().isMultiple()) {
                Value[] dctValues = dcTitle.getValues();
                if (dctValues.length > 0) {
                    title = dctValues[0].getString();
                }
            } else {
                title = dcTitle.getString();
            }
        } else if (node.hasProperty("exo:name")) {
            title = node.getProperty("exo:name").getString();
        }
        if (title == null) {
            title = node.getName();
        }
        return title;
    }

    protected String fileType(Node node) throws RepositoryException {
        String fileExt;
        String title = this.nodeTitle(node);
        int dotIndex = title.lastIndexOf(46);
        if (dotIndex >= 0 && dotIndex < title.length() && this.fileTypes.containsKey(fileExt = title.substring(dotIndex + 1).trim())) {
            return fileExt;
        }
        return null;
    }

    protected String documentType(String fileType) {
        String docType = this.fileTypes.get(fileType);
        if (docType != null) {
            return docType;
        }
        return TYPE_TEXT;
    }

    protected Node nodeContent(Node node) throws RepositoryException {
        return node.getNode("jcr:content");
    }

    protected Calendar nodeCreated(Node node) throws RepositoryException {
        return node.getProperty("jcr:created").getDate();
    }

    protected String mimeType(Node content) throws RepositoryException {
        return content.getProperty("jcr:mimeType").getString();
    }

    protected Property data(Node content) throws RepositoryException {
        return content.getProperty("jcr:data");
    }

    protected UUID generateId(String workspace, String path) {
        StringBuilder s = new StringBuilder();
        s.append(workspace);
        s.append(path);
        s.append(System.currentTimeMillis());
        s.append(String.valueOf(RANDOM.nextLong()));
        return UUID.nameUUIDFromBytes(s.toString().getBytes());
    }

    protected String nodePath(String workspace, String path) {
        return workspace + ":" + path;
    }

    protected String nodePath(Config config) {
        return this.nodePath(config.getWorkspace(), config.getPath());
    }

    protected User getUser(String username) throws OnlyofficeEditorException {
        try {
            return this.organization.getUserHandler().findUserByName(username);
        }
        catch (Exception e) {
            throw new OnlyofficeEditorException("Error searching user " + username, e);
        }
    }

    protected String webdavUrl(String schema, String host, String workspace, String path) throws OnlyofficeEditorException, RepositoryException {
        StringBuilder filePath = new StringBuilder();
        try {
            URI baseWebdavUri = this.webdavUri(schema, host);
            filePath.append(baseWebdavUri.getPath());
            filePath.append('/');
            filePath.append(this.jcrService.getCurrentRepository().getConfiguration().getName());
            filePath.append('/');
            filePath.append(workspace);
            filePath.append(path);
            URI uri = new URI(baseWebdavUri.getScheme(), null, baseWebdavUri.getHost(), baseWebdavUri.getPort(), filePath.toString(), null, null);
            return uri.toASCIIString();
        }
        catch (URISyntaxException e) {
            throw new OnlyofficeEditorException("Error creating content link (WebDAV) for " + path + " in " + workspace, e);
        }
    }

    protected boolean syncUsers(ConcurrentHashMap<String, Config> configs, String[] users) {
        HashSet<String> editors = new HashSet<String>(Arrays.asList(users));
        boolean updated = false;
        for (Map.Entry<String, Config> ce : configs.entrySet()) {
            String user = ce.getKey();
            Config config = ce.getValue();
            if (editors.contains(user)) {
                if (!config.isCreated() && !config.isClosed()) continue;
                config.open();
                this.fireJoined(config);
                updated = true;
                continue;
            }
            if (!config.isClosing() && !config.isOpen()) continue;
            config.closed();
            this.fireLeaved(config);
            updated = true;
        }
        return updated;
    }

    protected String[] getActiveUsers(ConcurrentHashMap<String, Config> configs) {
        LinkedHashSet userIds = new LinkedHashSet(configs.keySet());
        Iterator uiter = userIds.iterator();
        while (uiter.hasNext()) {
            String userId = (String)uiter.next();
            Config config = configs.get(userId);
            if (config != null && !config.isCreated() && !config.isClosed()) continue;
            uiter.remove();
        }
        return userIds.toArray(new String[userIds.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void download(Config config, DocumentStatus status) throws OnlyofficeEditorException, RepositoryException {
        InputStream data;
        HttpURLConnection connection;
        config.closing();
        String workspace = config.getWorkspace();
        String path = config.getPath();
        String nodePath = this.nodePath(workspace, path);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(">> download(" + nodePath + ", " + config.getDocument().getKey() + ")"));
        }
        String userId = status.getUsers()[0];
        this.validateUser(userId, config);
        String contentUrl = status.getUrl();
        Calendar editedTime = Calendar.getInstance();
        try {
            URL url = new URL(contentUrl);
            connection = (HttpURLConnection)url.openConnection();
            data = connection.getInputStream();
            if (data == null) {
                throw new OnlyofficeEditorException("Content stream is null");
            }
        }
        catch (MalformedURLException e) {
            throw new OnlyofficeEditorException("Error parsing content URL " + contentUrl + " for " + nodePath, e);
        }
        catch (IOException e) {
            throw new OnlyofficeEditorException("Error reading content stream " + contentUrl + " for " + nodePath, e);
        }
        ConversationState contextState = ConversationState.getCurrent();
        SessionProvider contextProvider = this.sessionProviders.getSessionProvider(null);
        try {
            Identity userIdentity = this.userIdentity(userId);
            if (userIdentity != null) {
                ConversationState state = new ConversationState(userIdentity);
                state.setAttribute("subject", (Object)userIdentity.getSubject());
                ConversationState.setCurrent((ConversationState)state);
                SessionProvider userProvider = new SessionProvider(state);
                this.sessionProviders.setSessionProvider(null, userProvider);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(">>> download under user " + userIdentity.getUserId() + " (" + nodePath + ", " + config.getDocument().getKey() + ")"));
                }
            } else {
                LOG.warn((Object)("User identity not found " + userId + " for downloading " + config.getDocument().getKey() + " " + nodePath));
                throw new OnlyofficeEditorException("User identity not found " + userId);
            }
            Node node = this.node(workspace, path);
            Node content = this.nodeContent(node);
            Lock lock = this.lock(node, config);
            if (lock == null) {
                throw new OnlyofficeEditorException("Document locked " + nodePath);
            }
            boolean checkIn = this.checkout(node);
            try {
                content.setProperty("jcr:data", data);
                content.setProperty("jcr:lastModified", editedTime);
                if (content.hasProperty("exo:dateModified")) {
                    content.setProperty("exo:dateModified", editedTime);
                }
                if (content.hasProperty("exo:lastModifiedDate")) {
                    content.setProperty("exo:lastModifiedDate", editedTime);
                }
                if (node.hasProperty("exo:lastModifiedDate")) {
                    node.setProperty("exo:lastModifiedDate", editedTime);
                }
                if (node.hasProperty("exo:dateModified")) {
                    node.setProperty("exo:dateModified", editedTime);
                }
                if (node.hasProperty("exo:lastModifier")) {
                    node.setProperty("exo:lastModifier", userId);
                }
                node.save();
                if (checkIn) {
                    node.checkin();
                    node.checkout();
                }
                config.closed();
                this.fireSaved(config);
            }
            catch (RepositoryException e) {
                try {
                    node.refresh(false);
                }
                catch (Throwable re) {
                    LOG.warn((Object)("Error rolling back failed change for " + nodePath), re);
                }
                throw e;
            }
            finally {
                try {
                    data.close();
                }
                catch (Throwable e) {
                    LOG.warn((Object)("Error closing exported content stream for " + nodePath), e);
                }
                try {
                    connection.disconnect();
                }
                catch (Throwable e) {
                    LOG.warn((Object)("Error closing export connection for " + nodePath), e);
                }
                try {
                    if (lock != null && node.isLocked()) {
                        node.unlock();
                    }
                }
                catch (Throwable e) {
                    LOG.warn((Object)("Error unlocking edited document " + this.nodePath(workspace, path)), e);
                }
            }
        }
        finally {
            ConversationState.setCurrent((ConversationState)contextState);
            this.sessionProviders.setSessionProvider(null, contextProvider);
        }
    }

    protected Node node(String workspace, String path) throws BadParameterException, RepositoryException {
        SessionProvider sp = this.sessionProviders.getSessionProvider(null);
        Session userSession = sp.getSession(workspace, this.jcrService.getCurrentRepository());
        Item item = this.finder.findItem(userSession, path);
        if (item.isNode()) {
            return (Node)item;
        }
        throw new BadParameterException("Not a node " + path);
    }

    protected Node systemNode(String workspace, String path) throws BadParameterException, RepositoryException {
        SessionProvider sp = this.sessionProviders.getSystemSessionProvider(null);
        Session sysSession = sp.getSession(workspace, this.jcrService.getCurrentRepository());
        Item item = this.finder.findItem(sysSession, path);
        if (item.isNode()) {
            return (Node)item;
        }
        throw new BadParameterException("Not a node " + path);
    }

    protected boolean checkout(Node node) throws RepositoryException {
        if (node.isNodeType("mix:versionable")) {
            if (!node.isCheckedOut()) {
                node.checkout();
            }
            return true;
        }
        return false;
    }

    protected Lock lock(Node node, Config config) throws OnlyofficeEditorException, RepositoryException {
        Lock lock;
        if (!node.isNodeType("mix:lockable")) {
            if (!node.isCheckedOut() && node.isNodeType("mix:versionable")) {
                node.checkout();
            }
            node.addMixin("mix:lockable");
            node.save();
        }
        Config.Editor.User user = config.getEditorConfig().getUser();
        int attempts = 0;
        try {
            do {
                ++attempts;
                if (node.isLocked()) {
                    String lockToken = user.getLockToken();
                    if (node.getLock().getLockOwner().equals(user.getId()) && lockToken != null) {
                        node.getSession().addLockToken(lockToken);
                        lock = node.getLock();
                        continue;
                    }
                    Thread.sleep(250L);
                    lock = null;
                    continue;
                }
                lock = node.lock(true, false);
                user.setLockToken(lock.getLockToken());
            } while (lock == null && attempts <= 20);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new OnlyofficeEditorException("Error waiting for lock of " + this.nodePath(config.getWorkspace(), config.getPath()), e);
        }
        return lock;
    }

    protected void validateUser(String userId, Config config) throws BadParameterException, OnlyofficeEditorException {
        User user = this.getUser(userId);
        if (user == null) {
            LOG.warn((Object)("Attempt to access editor document (" + this.nodePath(config) + ") under not existing user " + userId));
            throw new BadParameterException("User not found for " + config.getDocument().getTitle());
        }
    }

    protected String getUserLang(String userId) {
        UserProfileHandler hanlder = this.organization.getUserProfileHandler();
        try {
            UserProfile userProfile = hanlder.findUserProfileByName(userId);
            if (userProfile != null) {
                String lang = userProfile.getAttribute("user.language");
                if (lang != null) {
                    int cci = lang.indexOf("_");
                    if (cci > 0) {
                        lang = lang.substring(0, cci);
                    }
                } else {
                    lang = null;
                }
                return lang;
            }
            return null;
        }
        catch (Exception e) {
            LOG.warn((Object)("Error searching user profile " + userId), (Throwable)e);
            return null;
        }
    }

    protected StringBuilder platformUrl(String schema, String host) {
        StringBuilder platformUrl = new StringBuilder();
        platformUrl.append(schema);
        platformUrl.append("://");
        platformUrl.append(host);
        platformUrl.append('/');
        platformUrl.append(PortalContainer.getCurrentPortalContainerName());
        platformUrl.append('/');
        platformUrl.append(PortalContainer.getCurrentRestContextName());
        return platformUrl;
    }

    protected StringBuilder editorUrl(String schema, String host) {
        return this.platformUrl(schema, host).append("/onlyoffice/editor");
    }

    protected URI webdavUri(String schema, String host) throws URISyntaxException {
        StringBuilder webdavUrl = new StringBuilder();
        webdavUrl.append((CharSequence)this.platformUrl(schema, host));
        webdavUrl.append("/jcr");
        return new URI(webdavUrl.toString());
    }

    protected void fireCreated(Config config) {
        for (OnlyofficeEditorListener l : this.listeners) {
            try {
                l.onCreate(config);
            }
            catch (Throwable t) {
                LOG.warn((Object)"Creation listener error", t);
            }
        }
    }

    protected void fireGet(Config config) {
        for (OnlyofficeEditorListener l : this.listeners) {
            try {
                l.onGet(config);
            }
            catch (Throwable t) {
                LOG.warn((Object)"Read (Get) listener error", t);
            }
        }
    }

    protected void fireJoined(Config config) {
        for (OnlyofficeEditorListener l : this.listeners) {
            try {
                l.onJoined(config);
            }
            catch (Throwable t) {
                LOG.warn((Object)"User joining listener error", t);
            }
        }
    }

    protected void fireLeaved(Config config) {
        for (OnlyofficeEditorListener l : this.listeners) {
            try {
                l.onLeaved(config);
            }
            catch (Throwable t) {
                LOG.warn((Object)"User leaving listener error", t);
            }
        }
    }

    protected void fireSaved(Config config) {
        for (OnlyofficeEditorListener l : this.listeners) {
            try {
                l.onSaved(config);
            }
            catch (Throwable t) {
                LOG.warn((Object)"Saving listener error", t);
            }
        }
    }

    protected void fireError(Config config) {
        for (OnlyofficeEditorListener l : this.listeners) {
            try {
                l.onError(config);
            }
            catch (Throwable t) {
                LOG.warn((Object)"Error listener error", t);
            }
        }
    }

    protected Identity userIdentity(String userId) {
        Identity userIdentity = this.identityRegistry.getIdentity(userId);
        if (userIdentity == null) {
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("User identity not registered, trying to create it for: " + userId));
                }
                userIdentity = this.authenticator.createIdentity(userId);
            }
            catch (Exception e) {
                LOG.warn((Object)("Failed to create user identity: " + userId), (Throwable)e);
            }
        }
        return userIdentity;
    }

    protected String lowerCase(String str) {
        return str.toUpperCase().toLowerCase();
    }
}

