/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.onlyoffice.webui;

import java.util.Arrays;
import java.util.List;
import org.exoplatform.ecm.webui.component.explorer.UIDocumentWorkspace;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.control.UIActionBar;
import org.exoplatform.ecm.webui.component.explorer.control.listener.UIActionBarActionListener;
import org.exoplatform.onlyoffice.webui.AbstractOnlyofficeManageComponent;
import org.exoplatform.onlyoffice.webui.CanOpenOnlyofficeFilter;
import org.exoplatform.onlyoffice.webui.OnlyofficeEditorContext;
import org.exoplatform.onlyoffice.webui.OnlyofficeEditorUIService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIContainerLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.ext.filter.UIExtensionFilter;
import org.exoplatform.webui.ext.filter.UIExtensionFilters;

@ComponentConfig(lifecycle=UIContainerLifecycle.class, events={@EventConfig(listeners={OnlyofficeOpenActionListener.class})})
public class OnlyofficeOpenManageComponent
extends AbstractOnlyofficeManageComponent {
    protected static final Log LOG = ExoLogger.getLogger(OnlyofficeOpenManageComponent.class);
    private static final List<UIExtensionFilter> FILTERS = Arrays.asList(new UIExtensionFilter[]{new CanOpenOnlyofficeFilter()});

    @UIExtensionFilters
    public List<UIExtensionFilter> getFilters() {
        return FILTERS;
    }

    public static class OnlyofficeOpenActionListener
    extends UIActionBarActionListener<OnlyofficeOpenManageComponent> {
        public void processEvent(Event<OnlyofficeOpenManageComponent> event) throws Exception {
            WebuiRequestContext context = event.getRequestContext();
            UIJCRExplorer explorer = (UIJCRExplorer)((OnlyofficeOpenManageComponent)((Object)event.getSource())).getAncestorOfType(UIJCRExplorer.class);
            OnlyofficeEditorUIService editorsUI = (OnlyofficeEditorUIService)WCMCoreUtils.getService(OnlyofficeEditorUIService.class);
            String workspace = explorer.getCurrentWorkspace();
            String path = explorer.getCurrentNode().getPath();
            editorsUI.open(context.getRemoteUser(), workspace, path);
            OnlyofficeEditorContext.init((RequestContext)context, workspace, path);
            OnlyofficeEditorContext.open((RequestContext)context);
            UIDocumentWorkspace docWorkspace = (UIDocumentWorkspace)explorer.findFirstComponentOfType(UIDocumentWorkspace.class);
            context.addUIComponentToUpdateByAjax((UIComponent)docWorkspace);
            UIActionBar actionBar = (UIActionBar)explorer.findFirstComponentOfType(UIActionBar.class);
            context.addUIComponentToUpdateByAjax((UIComponent)actionBar);
        }
    }
}

