/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.onlyoffice.webui;

import java.util.concurrent.ConcurrentHashMap;
import org.exoplatform.onlyoffice.Config;
import org.exoplatform.onlyoffice.OnlyofficeEditorListener;
import org.exoplatform.onlyoffice.OnlyofficeEditorService;

public class OnlyofficeEditorUIService {
    protected final ConcurrentHashMap<String, State> editors = new ConcurrentHashMap();
    protected final OnlyofficeEditorService editorService;

    public OnlyofficeEditorUIService(OnlyofficeEditorService editorService) {
        this.editorService = editorService;
        editorService.addListener(new EditorListener());
    }

    public boolean open(String userId, String workspace, String path) {
        State state;
        String id = this.editorId(userId, workspace, path);
        State prev = this.editors.putIfAbsent(id, state = State.OPENING);
        return prev != null ? State.OPENING == prev : true;
    }

    public boolean opened(String userId, String workspace, String path) {
        String id = this.editorId(userId, workspace, path);
        return this.editors.replace(id, State.OPENING, State.OPEN);
    }

    public boolean close(String userId, String workspace, String path) {
        String id = this.editorId(userId, workspace, path);
        if (!this.editors.replace(id, State.OPEN, State.CLOSING)) {
            return this.editors.remove(id, (Object)State.OPENING);
        }
        return true;
    }

    public boolean closed(String userId, String workspace, String path) {
        String id = this.editorId(userId, workspace, path);
        return this.editors.remove(id, (Object)State.CLOSING);
    }

    public boolean reset(String userId, String workspace, String path) {
        String id = this.editorId(userId, workspace, path);
        State state = this.editors.remove(id);
        return state != null;
    }

    public boolean isOpening(String userId, String workspace, String path) {
        String id = this.editorId(userId, workspace, path);
        return State.OPENING == this.editors.get(id);
    }

    public boolean isOpen(String userId, String workspace, String path) {
        String id = this.editorId(userId, workspace, path);
        return State.OPEN == this.editors.get(id);
    }

    public boolean isClosing(String userId, String workspace, String path) {
        String id = this.editorId(userId, workspace, path);
        return State.CLOSING == this.editors.get(id);
    }

    public boolean isClosed(String userId, String workspace, String path) {
        String id = this.editorId(userId, workspace, path);
        return !this.editors.containsKey(id);
    }

    public boolean canShow(String userId, String workspace, String path) {
        String id = this.editorId(userId, workspace, path);
        State state = this.editors.get(id);
        return State.OPENING == state || State.OPEN == state || State.CLOSING == state;
    }

    public boolean canOpen(String userId, String workspace, String path) {
        String id = this.editorId(userId, workspace, path);
        State state = this.editors.get(id);
        return state == null || State.CLOSING == state;
    }

    public boolean canClose(String userId, String workspace, String path) {
        String id = this.editorId(userId, workspace, path);
        State state = this.editors.get(id);
        return State.OPENING == state || State.OPEN == state;
    }

    protected String editorId(String userId, String workspace, String path) {
        StringBuilder id = new StringBuilder();
        id.append(userId);
        id.append(':');
        id.append(workspace);
        id.append(':');
        id.append(path);
        return id.toString();
    }

    protected class EditorListener
    implements OnlyofficeEditorListener {
        protected EditorListener() {
        }

        @Override
        public void onCreate(Config config) {
            OnlyofficeEditorUIService.this.open(config.getEditorConfig().getUser().getId(), config.getWorkspace(), config.getPath());
        }

        @Override
        public void onGet(Config config) {
            OnlyofficeEditorUIService.this.open(config.getEditorConfig().getUser().getId(), config.getWorkspace(), config.getPath());
        }

        @Override
        public void onJoined(Config config) {
            OnlyofficeEditorUIService.this.opened(config.getEditorConfig().getUser().getId(), config.getWorkspace(), config.getPath());
        }

        @Override
        public void onLeaved(Config config) {
            OnlyofficeEditorUIService.this.reset(config.getEditorConfig().getUser().getId(), config.getWorkspace(), config.getPath());
        }

        @Override
        public void onSaved(Config config) {
            OnlyofficeEditorUIService.this.reset(config.getEditorConfig().getUser().getId(), config.getWorkspace(), config.getPath());
        }

        @Override
        public void onError(Config config) {
        }
    }

    protected static enum State {
        OPENING,
        OPEN,
        CLOSING;

    }
}

