/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.videocalls.skype.portlet;

import java.io.IOException;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletException;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.videocalls.VideoCallsService;
import org.exoplatform.videocalls.VideoCallsUtils;
import org.exoplatform.videocalls.skype.SkypeProvider;
import org.exoplatform.videocalls.skype.SkypeSettings;
import org.exoplatform.web.application.JavascriptManager;
import org.exoplatform.webui.application.WebuiRequestContext;

public class SkypeProviderPortlet
extends GenericPortlet {
    private static final Log LOG = ExoLogger.getLogger(SkypeProviderPortlet.class);
    private VideoCallsService videoCalls;
    private SkypeProvider provider;

    public void init() throws PortletException {
        super.init();
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        this.videoCalls = (VideoCallsService)container.getComponentInstanceOfType(VideoCallsService.class);
        try {
            this.provider = (SkypeProvider)this.videoCalls.getProvider("skype");
        }
        catch (ClassCastException e) {
            LOG.error((Object)("Provider skype isn't an instance of " + SkypeProvider.class.getName()), (Throwable)e);
        }
    }

    protected void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        if (this.provider != null) {
            try {
                SkypeSettings settings = this.provider.getSettings().build();
                String settingsJson = VideoCallsUtils.asJSON((Object)settings);
                JavascriptManager js = ((WebuiRequestContext)WebuiRequestContext.getCurrentInstance()).getJavascriptManager();
                js.require("SHARED/videoCalls", "videoCalls").require("SHARED/videoCalls_skype", "skypeProvider").addScripts("if (skypeProvider) { skypeProvider.configure(" + settingsJson + "); videoCalls.addProvider(skypeProvider); videoCalls.update(); }");
            }
            catch (Exception e) {
                LOG.error((Object)("Error processing Skype Calls portlet for user " + request.getRemoteUser()), (Throwable)e);
            }
        }
    }
}

