/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.videocalls.rest;

import java.util.Arrays;
import java.util.LinkedHashSet;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.videocalls.CallInfo;
import org.exoplatform.videocalls.IdentityNotFound;
import org.exoplatform.videocalls.UserInfo;
import org.exoplatform.videocalls.VideoCallsService;
import org.exoplatform.videocalls.rest.ErrorInfo;

@Path(value="/videocalls")
@Produces(value={"application/json"})
public class RESTVideoCallsService
implements ResourceContainer {
    public static final String ME = "me";
    protected static final Log LOG = ExoLogger.getLogger(RESTVideoCallsService.class);
    protected final VideoCallsService videoCalls;

    public RESTVideoCallsService(VideoCallsService skype) {
        this.videoCalls = skype;
    }

    @GET
    @RolesAllowed(value={"users"})
    @Path(value="/user/{name}")
    public Response getUserInfo(@Context UriInfo uriInfo, @PathParam(value="name") String userName) {
        ConversationState convo = ConversationState.getCurrent();
        if (convo != null) {
            String currentUserName = convo.getIdentity().getUserId();
            if (userName != null) {
                if (ME.equals(userName)) {
                    userName = currentUserName;
                }
                try {
                    UserInfo user = this.videoCalls.getUserInfo(userName);
                    if (user != null) {
                        return Response.ok().entity((Object)user).build();
                    }
                    return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)ErrorInfo.notFoundError("User not found or not accessible")).build();
                }
                catch (Throwable e) {
                    LOG.error((Object)("Error reading user info of '" + userName + "' by '" + currentUserName + "'"), e);
                    return Response.serverError().entity((Object)ErrorInfo.serverError("Error reading user " + userName)).build();
                }
            }
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ErrorInfo.clientError("Wrong request parameters: name")).build();
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)ErrorInfo.accessError("Unauthorized user")).build();
    }

    @GET
    @RolesAllowed(value={"users"})
    @Path(value="/users")
    @Deprecated
    public Response getUsersInfo(@Context UriInfo uriInfo, @QueryParam(value="names") String names) {
        ConversationState convo = ConversationState.getCurrent();
        if (convo != null) {
            String currentUserName = convo.getIdentity().getUserId();
            if (names != null) {
                try {
                    LinkedHashSet<UserInfo> users = new LinkedHashSet<UserInfo>();
                    for (String userName : names.trim().split(";")) {
                        UserInfo user;
                        if (ME.equals(userName)) {
                            userName = currentUserName;
                        }
                        if ((user = this.videoCalls.getUserInfo(userName)) == null) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)("Skipped not found user: " + userName));
                            }
                            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)ErrorInfo.notFoundError("User " + userName + " not found or not accessible")).build();
                        }
                        users.add(user);
                    }
                    return Response.ok().entity((Object)users.toArray()).build();
                }
                catch (Throwable e) {
                    LOG.error((Object)("Error reading users info of '" + names + "' by '" + currentUserName + "'"), e);
                    return Response.serverError().entity((Object)ErrorInfo.serverError("Error reading users " + names)).build();
                }
            }
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ErrorInfo.clientError("Wrong request parameters: names")).build();
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)ErrorInfo.accessError("Unauthorized user")).build();
    }

    @GET
    @RolesAllowed(value={"users"})
    @Path(value="/space/{spaceName}")
    public Response getSpaceInfo(@Context UriInfo uriInfo, @PathParam(value="spaceName") String spaceName) {
        ConversationState convo = ConversationState.getCurrent();
        if (convo != null) {
            String currentUserName = convo.getIdentity().getUserId();
            if (spaceName != null && spaceName.length() > 0) {
                try {
                    VideoCallsService.SpaceInfo space = this.videoCalls.getSpaceInfo(spaceName);
                    if (space != null) {
                        if (space.getMembers().containsKey(currentUserName)) {
                            return Response.ok().entity((Object)space).build();
                        }
                        return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)ErrorInfo.accessError("Not space member")).build();
                    }
                    return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)ErrorInfo.notFoundError("Space not found or not accessible")).build();
                }
                catch (Throwable e) {
                    LOG.error((Object)("Error reading space info of '" + spaceName + "' by '" + currentUserName + "'"), e);
                    return Response.serverError().entity((Object)ErrorInfo.serverError("Error reading space " + spaceName)).build();
                }
            }
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ErrorInfo.clientError("Wrong request parameters: name")).build();
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)ErrorInfo.accessError("Unauthorized user")).build();
    }

    @GET
    @RolesAllowed(value={"users"})
    @Path(value="/room/{name}/{id}")
    public Response getRoomInfo(@Context UriInfo uriInfo, @PathParam(value="name") String roomName, @PathParam(value="id") String roomId, @QueryParam(value="title") String roomTitle, @QueryParam(value="members") String roomMembers) {
        ConversationState convo = ConversationState.getCurrent();
        if (convo != null) {
            String currentUserName = convo.getIdentity().getUserId();
            if (roomId != null && roomId.length() > 0) {
                if (roomName != null && roomName.length() > 0) {
                    if (roomTitle == null || roomTitle.length() == 0) {
                        roomTitle = roomName.replace('_', ' ');
                    }
                    if (roomMembers != null && roomMembers.length() > 0) {
                        try {
                            VideoCallsService.RoomInfo room = this.videoCalls.getRoomInfo(roomId, roomName, roomTitle, roomMembers.trim().split(";"));
                            if (room != null) {
                                if (room.getMembers().containsKey(currentUserName)) {
                                    return Response.ok().entity((Object)room).build();
                                }
                                return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)ErrorInfo.accessError("Not room member")).build();
                            }
                            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)ErrorInfo.notFoundError("Room not found or not accessible")).build();
                        }
                        catch (IdentityNotFound e) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)"Room member not found", (Throwable)e);
                            }
                            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)ErrorInfo.notFoundError(e.getMessage())).build();
                        }
                        catch (Throwable e) {
                            LOG.error((Object)("Error reading room info of '" + roomName + "' by '" + currentUserName + "'"), e);
                            return Response.serverError().entity((Object)ErrorInfo.serverError("Error reading room " + roomName)).build();
                        }
                    }
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ErrorInfo.clientError("Wrong request parameters: members")).build();
                }
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ErrorInfo.clientError("Wrong request parameters: name")).build();
            }
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ErrorInfo.clientError("Wrong request parameters: id")).build();
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)ErrorInfo.accessError("Unauthorized user")).build();
    }

    @GET
    @RolesAllowed(value={"users"})
    @Path(value="/call/{type}/{id}")
    public Response getCallInfo(@Context UriInfo uriInfo, @PathParam(value="type") String type, @PathParam(value="id") String id) {
        ConversationState convo = ConversationState.getCurrent();
        if (convo != null) {
            String callId = this.callId(type, id);
            String currentUserName = convo.getIdentity().getUserId();
            try {
                CallInfo call = this.videoCalls.getCallInfo(callId);
                if (call != null) {
                    return Response.ok().entity((Object)call).build();
                }
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)ErrorInfo.notFoundError("Call not found")).build();
            }
            catch (Throwable e) {
                LOG.error((Object)("Error reading call info for '" + callId + "' by '" + currentUserName + "'"), e);
                return Response.serverError().entity((Object)ErrorInfo.serverError("Error reading call information")).build();
            }
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)ErrorInfo.accessError("Unauthorized user")).build();
    }

    @DELETE
    @RolesAllowed(value={"users"})
    @Path(value="/call/{type}/{id}")
    public Response deleteCallInfo(@Context UriInfo uriInfo, @PathParam(value="type") String type, @PathParam(value="id") String id) {
        ConversationState convo = ConversationState.getCurrent();
        if (convo != null) {
            String callId = this.callId(type, id);
            String currentUserName = convo.getIdentity().getUserId();
            try {
                CallInfo call = this.videoCalls.removeCallInfo(callId);
                if (call != null) {
                    return Response.ok().entity((Object)call).build();
                }
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)ErrorInfo.notFoundError("Call not found")).build();
            }
            catch (Throwable e) {
                LOG.error((Object)("Error removing call info for '" + callId + "' by '" + currentUserName + "'"), e);
                return Response.serverError().entity((Object)ErrorInfo.serverError("Error removing call information")).build();
            }
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)ErrorInfo.accessError("Unauthorized user")).build();
    }

    @POST
    @RolesAllowed(value={"users"})
    @Path(value="/call/{type}/{id}")
    public Response postCallInfo(@Context UriInfo uriInfo, @PathParam(value="type") String type, @PathParam(value="id") String id, @FormParam(value="title") String title, @FormParam(value="provider") String providerType, @FormParam(value="owner") String ownerId, @FormParam(value="ownerType") String ownerType, @FormParam(value="participants") String participants) {
        ConversationState convo = ConversationState.getCurrent();
        if (convo != null) {
            String callId = this.callId(type, id);
            if (title != null) {
                if (providerType != null) {
                    if (ownerId != null) {
                        if (ownerType != null) {
                            if (participants != null) {
                                String currentUserName = convo.getIdentity().getUserId();
                                try {
                                    CallInfo call = this.videoCalls.addCallInfo(callId, ownerId, ownerType, title, providerType, Arrays.asList(participants.split(";")));
                                    return Response.ok().entity((Object)call).build();
                                }
                                catch (Throwable e) {
                                    LOG.error((Object)("Error creating call info for '" + callId + "' by '" + currentUserName + "'"), e);
                                    return Response.serverError().entity((Object)ErrorInfo.serverError("Error creating call record")).build();
                                }
                            }
                            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ErrorInfo.clientError("Wrong request parameters: participants")).build();
                        }
                        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ErrorInfo.clientError("Wrong request parameters: ownerType")).build();
                    }
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ErrorInfo.clientError("Wrong request parameters: owner")).build();
                }
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ErrorInfo.clientError("Wrong request parameters: provider")).build();
            }
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ErrorInfo.clientError("Wrong request parameters: title")).build();
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)ErrorInfo.accessError("Unauthorized user")).build();
    }

    private String callId(String type, String id) {
        return new StringBuffer(type).append('/').append(id).toString();
    }
}

