/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.videocalls;

import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.services.cms.drives.ManageDriveService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.service.LinkProvider;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.videocalls.CallInfo;
import org.exoplatform.videocalls.CallInfoException;
import org.exoplatform.videocalls.CallState;
import org.exoplatform.videocalls.GroupInfo;
import org.exoplatform.videocalls.IdentityInfo;
import org.exoplatform.videocalls.IdentityNotFound;
import org.exoplatform.videocalls.ParticipantInfo;
import org.exoplatform.videocalls.UserCallListener;
import org.exoplatform.videocalls.UserInfo;
import org.exoplatform.videocalls.VideoCallsProvider;
import org.exoplatform.videocalls.VideoCallsProviderException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.picocontainer.Startable;

public class VideoCallsService
implements Startable {
    public static final String SPACE_TYPE_NAME = "space".intern();
    public static final String CHAT_ROOM_TYPE_NAME = "chat_room".intern();
    protected static final String GROUP_CALL_TYPE = "group".intern();
    protected static final String CALL_OWNER_SCOPE_NAME = "videocalls.callOwner".intern();
    protected static final String CALL_ID_SCOPE_NAME = "videocalls.callId".intern();
    protected static final String USER_CALLS_SCOPE_NAME = "videocalls.user.calls".intern();
    public static final String OWNER_TYPE_SPACE = "space";
    public static final String OWNER_TYPE_CHATROOM = "chat_room";
    protected static final Log LOG = ExoLogger.getLogger(VideoCallsService.class);
    protected final RepositoryService jcrService;
    protected final SessionProviderService sessionProviders;
    protected final NodeHierarchyCreator hierarchyCreator;
    protected final OrganizationService organization;
    protected final IdentityManager socialIdentityManager;
    protected final ManageDriveService driveService;
    protected final ListenerService listenerService;
    protected final SettingService settingService;
    protected final Map<String, VideoCallsProvider> providers = new ConcurrentHashMap<String, VideoCallsProvider>();
    protected SpaceService spaceService;
    protected final Map<String, Set<UserCallListener>> userListeners = new ConcurrentHashMap<String, Set<UserCallListener>>();

    public VideoCallsService(RepositoryService jcrService, SessionProviderService sessionProviders, NodeHierarchyCreator hierarchyCreator, OrganizationService organization, IdentityManager socialIdentityManager, ManageDriveService driveService, ListenerService listenerService, SettingService settingService) {
        this.jcrService = jcrService;
        this.sessionProviders = sessionProviders;
        this.hierarchyCreator = hierarchyCreator;
        this.organization = organization;
        this.socialIdentityManager = socialIdentityManager;
        this.driveService = driveService;
        this.listenerService = listenerService;
        this.settingService = settingService;
    }

    public UserInfo getUserInfo(String id) throws Exception {
        User user = this.organization.getUserHandler().findUserByName(id);
        Identity userIdentity = this.socialIdentityManager.getOrCreateIdentity("organization", id, true);
        if (user != null) {
            if (userIdentity != null) {
                Profile socialProfile = this.socialIdentityManager.getProfile(userIdentity);
                List ims = (List)socialProfile.getProperty("ims");
                UserInfo info = new UserInfo(user.getUserName(), user.getFirstName(), user.getLastName());
                if (ims != null) {
                    for (Map m : ims) {
                        VideoCallsProvider provider;
                        String imType = (String)m.get("key");
                        String imId = (String)m.get("value");
                        if (imId == null || imId.length() <= 0 || (provider = this.getProvider(imType)) == null || !provider.isSupportedType(imType)) continue;
                        try {
                            info.addImAccount(provider.getIMInfo(imId));
                        }
                        catch (VideoCallsProviderException e) {
                            LOG.warn((Object)e.getMessage());
                        }
                    }
                }
                info.setAvatarUri(socialProfile.getAvatarUrl());
                info.setProfileUri(LinkProvider.getUserProfileUri((String)id));
                return info;
            }
            LOG.warn((Object)("Social identity not found for " + user.getUserName() + " (" + user.getFirstName() + " " + user.getLastName() + ")"));
        } else {
            LOG.warn((Object)("User not found: " + id));
        }
        return null;
    }

    public SpaceInfo getSpaceInfo(String spacePrettyName) throws Exception {
        Space socialSpace = this.spaceService.getSpaceByPrettyName(spacePrettyName);
        SpaceInfo space = new SpaceInfo(socialSpace);
        for (String sm : socialSpace.getMembers()) {
            UserInfo user = this.getUserInfo(sm);
            if (user == null) continue;
            space.addMember(user);
        }
        space.setCallId(this.readOwnerCallId(spacePrettyName));
        return space;
    }

    public RoomInfo getRoomInfo(String id, String name, String title, String[] members) throws Exception {
        RoomInfo room = this.roomInfo(id, name, title, members, this.readOwnerCallId(id));
        return room;
    }

    public CallInfo addCall(String id, String ownerId, String ownerType, String title, String providerType, Collection<String> parts) throws Exception {
        Object avatar;
        String ownerAvatar;
        String ownerUri;
        IdentityInfo owner;
        boolean isUser = UserInfo.TYPE_NAME.equals(ownerType);
        boolean isSpace = OWNER_TYPE_SPACE.equals(ownerType);
        boolean isRoom = OWNER_TYPE_CHATROOM.equals(ownerType);
        if (isUser) {
            UserInfo userInfo = this.getUserInfo(ownerId);
            if (userInfo == null) {
                owner = new RoomInfo(ownerId, ownerId, title);
                ownerUri = IdentityInfo.EMPTY;
                ownerAvatar = "/eXoSkin/skin/images/system/UserAvtDefault.png";
            } else {
                owner = userInfo;
                ownerUri = userInfo.getProfileUri();
                avatar = userInfo.getAvatarUri();
                ownerAvatar = avatar != null ? avatar : "/eXoSkin/skin/images/system/UserAvtDefault.png";
            }
        } else if (isSpace) {
            Space space = this.spaceService.getSpaceByPrettyName(ownerId);
            if (space != null) {
                owner = new SpaceInfo(space);
                ownerUri = space.getUrl();
                avatar = space.getAvatarUrl();
                ownerAvatar = avatar != null ? avatar : "/eXoSkin/skin/images/system/SpaceAvtDefault.png";
            } else {
                LOG.warn((Object)("Cannot find call's owner space " + ownerId));
                owner = new RoomInfo(ownerId, ownerId, title);
                ownerUri = IdentityInfo.EMPTY;
                ownerAvatar = "/eXoSkin/skin/images/system/SpaceAvtDefault.png";
            }
        } else if (isRoom) {
            owner = new RoomInfo(ownerId, ownerId, title);
            ownerUri = IdentityInfo.EMPTY;
            ownerAvatar = "/eXoSkin/skin/images/system/SpaceAvtDefault.png";
        } else {
            throw new CallInfoException("Wrong call owner type: " + ownerType);
        }
        LinkedHashSet<UserInfo> participants = new LinkedHashSet<UserInfo>();
        for (String pid : parts) {
            UserInfo part = this.getUserInfo(pid);
            if (part != null) {
                participants.add(part);
                continue;
            }
            participants.add(new ParticipantInfo(providerType, pid));
        }
        CallInfo call = new CallInfo(id, title, owner, ownerType, ownerUri, ownerAvatar, providerType);
        call.addParticipants(participants);
        call.setState("started");
        String prevId = this.readOwnerCallId(ownerId);
        this.saveCall(call);
        String userId = this.currentUserId();
        if (isSpace || isRoom) {
            this.saveOwnerCallId(ownerId, id);
            for (UserInfo part : participants) {
                if (part.getType() != UserInfo.TYPE_NAME) continue;
                if (prevId != null) {
                    this.removeUserGroupCallId(part.getId(), prevId);
                }
                this.saveUserGroupCallId(part.getId(), id);
                if (userId.equals(part.getId())) continue;
                this.fireUserCallState(part.getId(), id, providerType, "started", ownerId, ownerType);
            }
        } else if (isUser) {
            this.notifyUserCallState(call, userId, "started");
        }
        return call;
    }

    public CallInfo getCall(String id) throws Exception {
        return this.readCallById(id);
    }

    public CallInfo stopCall(String id, boolean remove) throws Exception {
        String userId = this.currentUserId();
        CallInfo info = this.readCallById(id);
        if (info != null) {
            this.stopCall(info, userId, remove);
        } else if (remove && userId != null && id.startsWith("g/")) {
            this.removeUserGroupCallId(userId, id);
        }
        return info;
    }

    protected CallInfo stopCall(CallInfo call, String userId, boolean remove) throws Exception {
        if (remove) {
            this.deleteCall(call);
        } else {
            call.setState("stopped");
            this.saveCall(call);
        }
        if (call.getOwner().isGroup()) {
            String callId = call.getId();
            for (UserInfo part : call.getParticipants()) {
                if (part.getType() != UserInfo.TYPE_NAME) continue;
                if (userId == null || !remove || !userId.equals(part.getId())) {
                    this.fireUserCallState(part.getId(), call.getId(), call.getProviderType(), "stopped", call.getOwner().getId(), call.getOwner().getType());
                }
                if (!remove) continue;
                this.removeUserGroupCallId(part.getId(), callId);
            }
        } else {
            this.notifyUserCallState(call, userId, "stopped");
        }
        return call;
    }

    public CallInfo startCall(String id) throws Exception {
        CallInfo call = this.readCallById(id);
        if (call != null) {
            call.setState("started");
            if (call.getOwner().isGroup()) {
                String userId = this.currentUserId();
                for (UserInfo part : call.getParticipants()) {
                    if (part.getType() != UserInfo.TYPE_NAME) continue;
                    if (userId.equals(part.getId())) {
                        part.setState("joined");
                        continue;
                    }
                    this.fireUserCallState(part.getId(), id, call.getProviderType(), "started", call.getOwner().getId(), call.getOwner().getType());
                }
            }
            this.saveCall(call);
        }
        return call;
    }

    public CallInfo joinCall(String id, String userId) throws Exception {
        CallInfo call = this.readCallById(id);
        if (call != null) {
            if ("started".equals(call.getState())) {
                for (UserInfo part : call.getParticipants()) {
                    if (part.getType() != UserInfo.TYPE_NAME) continue;
                    if (userId.equals(part.getId())) {
                        part.setState("joined");
                        this.saveCall(call);
                    }
                    this.fireUserCallJoined(id, call.getProviderType(), userId, part.getId());
                }
            } else {
                this.startCall(id);
            }
        }
        return call;
    }

    public CallInfo leaveCall(String id, String userId) throws Exception {
        CallInfo call = this.readCallById(id);
        if (call != null && "started".equals(call.getState())) {
            int leaved = 0;
            boolean userLeaved = false;
            for (UserInfo part : call.getParticipants()) {
                if (part.getType() != UserInfo.TYPE_NAME) continue;
                if (userId.equals(part.getId())) {
                    part.setState("leaved");
                    userLeaved = true;
                    ++leaved;
                } else if (part.getState() == null || part.getState().equals("leaved")) {
                    ++leaved;
                }
                this.fireUserCallLeaved(id, call.getProviderType(), userId, part.getId());
            }
            if (leaved == call.getParticipants().size()) {
                this.stopCall(call, userId, false);
            } else if (userLeaved) {
                this.saveCall(call);
            }
        }
        return call;
    }

    public CallState[] getUserCalls(String userId) throws Exception {
        CallState[] states;
        String[] calls = this.readUserGroupCallIds(userId);
        if (calls == null) {
            states = new CallState[]{};
        } else {
            ArrayList<CallState> slist = new ArrayList<CallState>();
            for (String id : calls) {
                if (id.length() <= 0) continue;
                CallInfo call = this.readCallById(id);
                if (call != null) {
                    slist.add(new CallState(id, call.getState() != null ? call.getState() : "stopped"));
                    continue;
                }
                this.removeUserGroupCallId(userId, id);
                LOG.warn((Object)("User call not found: " + id + ". Cleaned user: " + userId));
            }
            states = slist.toArray(new CallState[slist.size()]);
        }
        return states;
    }

    public void addUserCallListener(UserCallListener listener) {
        String userId = listener.getUserId();
        this.userListeners.computeIfAbsent(userId, k -> new LinkedHashSet()).add(listener);
    }

    public void removeUserCallListener(UserCallListener listener) {
        String userId = listener.getUserId();
        Set<UserCallListener> listeners = this.userListeners.get(userId);
        if (listeners != null) {
            listeners.remove(listener);
        }
    }

    protected void fireUserCallState(String userId, String callId, String providerType, String callState, String callerId, String callerType) {
        Set<UserCallListener> listeners = this.userListeners.get(userId);
        if (listeners != null) {
            for (UserCallListener listener : listeners) {
                if (!listener.isListening()) continue;
                listener.onCallState(callId, providerType, callState, callerId, callerType);
            }
        }
    }

    protected void fireUserCallJoined(String callId, String providerType, String partId, String userId) {
        Set<UserCallListener> listeners = this.userListeners.get(userId);
        if (listeners != null) {
            for (UserCallListener listener : listeners) {
                if (!listener.isListening()) continue;
                listener.onPartJoined(callId, providerType, partId);
            }
        }
    }

    protected void fireUserCallLeaved(String callId, String providerType, String partId, String userId) {
        Set<UserCallListener> listeners = this.userListeners.get(userId);
        if (listeners != null) {
            for (UserCallListener listener : listeners) {
                if (!listener.isListening()) continue;
                listener.onPartLeaved(callId, providerType, partId);
            }
        }
    }

    public void addPlugin(ComponentPlugin plugin) {
        Class<VideoCallsProvider> pclass = VideoCallsProvider.class;
        if (pclass.isAssignableFrom(plugin.getClass())) {
            this.addProvider((VideoCallsProvider)((Object)pclass.cast(plugin)));
        } else {
            LOG.warn((Object)("Video Calls provider plugin is not an instance of " + pclass.getName() + ". Skipped plugin: " + plugin));
        }
    }

    public void addProvider(VideoCallsProvider provider) {
        for (String type : provider.getSupportedTypes()) {
            VideoCallsProvider existing = this.providers.putIfAbsent(type, provider);
            if (existing == null) continue;
            LOG.warn((Object)("Video Calls provider type '" + existing.getType() + "' already registered. Skipped plugin: " + (Object)((Object)provider)));
        }
    }

    public VideoCallsProvider getProvider(String type) {
        return this.providers.get(type);
    }

    public void start() {
        this.spaceService = (SpaceService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(SpaceService.class);
    }

    public void stop() {
    }

    protected boolean isSpaceMember(String userName, String spacePrettyName) {
        return this.getSpaceMembers(spacePrettyName).contains(userName);
    }

    protected Set<String> getSpaceMembers(String spacePrettyName) {
        Space space = this.spaceService.getSpaceByPrettyName(spacePrettyName);
        HashSet<String> spaceMembers = new HashSet<String>();
        for (String sm : space.getMembers()) {
            spaceMembers.add(sm);
        }
        return spaceMembers;
    }

    protected JSONObject callToJSON(CallInfo call) throws JSONException {
        JSONObject json = new JSONObject();
        json.put("id", (Object)call.getId());
        json.put("title", (Object)call.getTitle());
        json.put("avatarLink", (Object)call.getAvatarLink());
        json.put("ownerType", (Object)call.getOwnerType());
        json.put("ownerLink", (Object)call.getOwnerLink());
        json.put("providerType", (Object)call.getProviderType());
        if (call.getState() != null) {
            json.put("state", (Object)call.getState());
        }
        JSONObject jsonOwner = new JSONObject();
        jsonOwner.put("id", (Object)call.getOwner().getId());
        String ownerType = call.getOwner().getType();
        jsonOwner.put("type", (Object)ownerType);
        if (OWNER_TYPE_CHATROOM.equals(ownerType)) {
            RoomInfo room = (RoomInfo)call.getOwner();
            jsonOwner.put("name", (Object)room.getName());
            jsonOwner.put("title", (Object)room.getTitle());
        }
        json.put("owner", (Object)jsonOwner);
        JSONArray jsonParts = new JSONArray();
        for (UserInfo p : call.getParticipants()) {
            JSONObject jsonPart = new JSONObject();
            jsonPart.put("id", (Object)p.getId());
            jsonPart.put("type", (Object)p.getType());
            String state = p.getState();
            if (state != null) {
                jsonPart.put("state", (Object)state);
            }
            jsonParts.put((Object)jsonPart);
        }
        json.put("participants", (Object)jsonParts);
        return json;
    }

    protected CallInfo jsonToCall(JSONObject json) throws Exception {
        IdentityInfo owner;
        String id = json.getString("id");
        String title = json.getString("title");
        String avatarLink = json.getString("avatarLink");
        String ownerType = json.getString("ownerType");
        String ownerLink = json.getString("ownerLink");
        String providerType = json.getString("providerType");
        String state = json.optString("state", null);
        JSONObject jsonOwner = json.getJSONObject("owner");
        String ownerId = jsonOwner.getString("id");
        if (OWNER_TYPE_CHATROOM.equals(ownerType)) {
            owner = this.roomInfo(ownerId, jsonOwner.getString("name"), jsonOwner.getString("title"), new String[0], id);
        } else if (OWNER_TYPE_SPACE.equals(ownerType)) {
            owner = this.getSpaceInfo(ownerId);
        } else if (UserInfo.TYPE_NAME.equals(ownerType)) {
            owner = this.getUserInfo(ownerId);
        } else {
            LOG.error((Object)("Unexpected call owner, type: " + ownerType + ", id: " + ownerId));
            throw new CallInfoException("Unexpected call owner: " + ownerId);
        }
        CallInfo call = new CallInfo(id, title, owner, ownerType, ownerLink, avatarLink, providerType);
        if (state != null) {
            call.setState(state);
        }
        JSONArray jsonParts = json.getJSONArray("participants");
        for (int i = 0; i < jsonParts.length(); ++i) {
            JSONObject jsonPart = jsonParts.getJSONObject(i);
            String partId = jsonPart.getString("id");
            String partType = jsonPart.getString("type");
            if (UserInfo.TYPE_NAME.equals(partType)) {
                UserInfo user = this.getUserInfo(partId);
                if (user != null) {
                    String partState = jsonPart.optString("state", null);
                    if (partState != null) {
                        user.setState(partState);
                    }
                    call.addParticipant(user);
                    continue;
                }
                LOG.warn((Object)("Cannot add call participant as eXo user: " + partId));
                call.addParticipant(new ParticipantInfo(providerType, partId));
                continue;
            }
            call.addParticipant(new ParticipantInfo(providerType, partId));
        }
        return call;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveCall(CallInfo call) throws Exception {
        this.saveOwnerCallId(call.getOwner().getId(), call.getId());
        String initialGlobalId = Scope.GLOBAL.getId();
        try {
            JSONObject json = this.callToJSON(call);
            String safeCallId = URLEncoder.encode(call.getId(), "UTF-8");
            this.settingService.set(Context.GLOBAL, Scope.GLOBAL.id(CALL_ID_SCOPE_NAME), safeCallId, SettingValue.create((String)json.toString()));
        }
        finally {
            Scope.GLOBAL.id(initialGlobalId);
        }
    }

    protected CallInfo readCallByOwnerId(String ownerId) throws Exception {
        String callId = this.readOwnerCallId(ownerId);
        if (callId != null) {
            return this.readCallById(callId);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CallInfo readCallById(String id) throws Exception {
        String initialGlobalId = Scope.GLOBAL.getId();
        try {
            String safeCallId = URLEncoder.encode(id, "UTF-8");
            SettingValue val = this.settingService.get(Context.GLOBAL, Scope.GLOBAL.id(CALL_ID_SCOPE_NAME), safeCallId);
            if (val != null) {
                String str = String.valueOf(val.getValue());
                if (str.startsWith("{")) {
                    CallInfo call;
                    CallInfo callInfo = call = this.jsonToCall(new JSONObject(str));
                    return callInfo;
                }
                LOG.warn((Object)("Cannot parse saved CallInfo: " + str));
            }
            CallInfo callInfo = null;
            return callInfo;
        }
        finally {
            Scope.GLOBAL.id(initialGlobalId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteCall(CallInfo call) throws Exception {
        String initialGlobalId = Scope.GLOBAL.getId();
        try {
            String safeCallId = URLEncoder.encode(call.getId(), "UTF-8");
            this.settingService.remove(Context.GLOBAL, Scope.GLOBAL.id(CALL_ID_SCOPE_NAME), safeCallId);
            this.settingService.remove(Context.GLOBAL, Scope.GLOBAL.id(CALL_OWNER_SCOPE_NAME), call.getOwner().getId());
        }
        finally {
            Scope.GLOBAL.id(initialGlobalId);
        }
    }

    protected CallInfo deleteCallById(String id) throws Exception {
        CallInfo call = this.readCallById(id);
        if (call != null) {
            this.deleteCall(call);
        }
        return call;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveOwnerCallId(String ownerId, String callId) {
        String initialGlobalId = Scope.GLOBAL.getId();
        try {
            this.settingService.set(Context.GLOBAL, Scope.GLOBAL.id(CALL_OWNER_SCOPE_NAME), ownerId, SettingValue.create((String)callId));
        }
        finally {
            Scope.GLOBAL.id(initialGlobalId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String readOwnerCallId(String ownerId) {
        String initialGlobalId = Scope.GLOBAL.getId();
        try {
            SettingValue val = this.settingService.get(Context.GLOBAL, Scope.GLOBAL.id(CALL_OWNER_SCOPE_NAME), ownerId);
            if (val != null) {
                String string = String.valueOf(val.getValue());
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            Scope.GLOBAL.id(initialGlobalId);
        }
    }

    protected void deleteOwnerCallId(String ownerId) {
        String initialGlobalId = Scope.GLOBAL.getId();
        try {
            this.settingService.remove(Context.GLOBAL, Scope.GLOBAL.id(CALL_OWNER_SCOPE_NAME), ownerId);
        }
        finally {
            Scope.GLOBAL.id(initialGlobalId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String[] readUserGroupCallIds(String userId) {
        String initialScopeId = Scope.GLOBAL.getId();
        String initialContextId = Context.USER.getId();
        Context userContext = userId != null ? Context.USER.id(userId) : Context.USER;
        Scope userScope = Scope.GLOBAL.id(USER_CALLS_SCOPE_NAME);
        try {
            SettingValue val = this.settingService.get(userContext, userScope, GROUP_CALL_TYPE);
            if (val != null) {
                String[] stringArray = String.valueOf(val.getValue()).split("\n");
                return stringArray;
            }
            String[] stringArray = null;
            return stringArray;
        }
        finally {
            Scope.GLOBAL.id(initialScopeId);
            Context.USER.id(initialContextId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveUserGroupCallId(String userId, String callId) {
        String initialContextId = Context.USER.getId();
        String initialScopeId = Scope.GLOBAL.getId();
        Context userContext = userId != null ? Context.USER.id(userId) : Context.USER;
        Scope userScope = Scope.GLOBAL.id(USER_CALLS_SCOPE_NAME);
        try {
            StringBuilder newVal = new StringBuilder();
            SettingValue val = this.settingService.get(userContext, userScope, GROUP_CALL_TYPE);
            if (val != null) {
                String oldVal = String.valueOf(val.getValue());
                if (oldVal.indexOf(callId) >= 0) {
                    return;
                }
                newVal.append(oldVal);
                newVal.append('\n');
            }
            newVal.append(callId);
            this.settingService.set(userContext, userScope, GROUP_CALL_TYPE, SettingValue.create((String)newVal.toString()));
        }
        finally {
            Scope.GLOBAL.id(initialScopeId);
            Context.USER.id(initialContextId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeUserGroupCallId(String userId, String callId) {
        String initialContextId = Context.USER.getId();
        String initialScopeId = Scope.GLOBAL.getId();
        Context userContext = userId != null ? Context.USER.id(userId) : Context.USER;
        Scope userScope = Scope.GLOBAL.id(USER_CALLS_SCOPE_NAME);
        try {
            String oldVal;
            int start;
            SettingValue val = this.settingService.get(userContext, userScope, GROUP_CALL_TYPE);
            if (val != null && (start = (oldVal = String.valueOf(val.getValue())).indexOf(callId)) >= 0) {
                StringBuilder newVal = new StringBuilder(oldVal);
                newVal.delete(start, start + callId.length() + 1);
                this.settingService.set(userContext, userScope, GROUP_CALL_TYPE, SettingValue.create((String)newVal.toString()));
            }
        }
        finally {
            Scope.GLOBAL.id(initialScopeId);
            Context.USER.id(initialContextId);
        }
    }

    protected RoomInfo roomInfo(String id, String name, String title, String[] members, String callId) throws Exception {
        RoomInfo room = new RoomInfo(id, name, title);
        for (String userName : members) {
            UserInfo user = this.getUserInfo(userName);
            if (user == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Skipped not found user: " + userName));
                }
                throw new IdentityNotFound("User " + userName + " not found or not accessible");
            }
            room.addMember(user);
        }
        room.setCallId(callId);
        return room;
    }

    protected String currentUserId() {
        ConversationState contextState = ConversationState.getCurrent();
        if (contextState != null) {
            return contextState.getIdentity().getUserId();
        }
        return null;
    }

    protected void notifyUserCallState(CallInfo call, String initiatorId, String state) {
        for (UserInfo part : call.getParticipants()) {
            if (part.getType() != UserInfo.TYPE_NAME || initiatorId != null && initiatorId.equals(part.getId())) continue;
            this.fireUserCallState(part.getId(), call.getId(), call.getProviderType(), state, call.getOwner().getId(), call.getOwner().getType());
        }
    }

    public class RoomInfo
    extends GroupInfo {
        protected final String name;

        public RoomInfo(String id, String name, String title) {
            super(id, title);
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        @Override
        public String getType() {
            return CHAT_ROOM_TYPE_NAME;
        }
    }

    public class SpaceInfo
    extends GroupInfo {
        protected final String groupId;

        public SpaceInfo(Space socialSpace) {
            super(socialSpace.getPrettyName(), socialSpace.getDisplayName());
            this.groupId = socialSpace.getGroupId();
        }

        public String getGroupId() {
            return this.groupId;
        }

        @Override
        public String getType() {
            return SPACE_TYPE_NAME;
        }
    }
}

