/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.videocalls.server;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.exoplatform.container.web.AbstractHttpServlet;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.videocalls.UserCallListener;
import org.exoplatform.videocalls.VideoCallsService;

public class UpdatePollingServlet
extends AbstractHttpServlet {
    protected static final Log LOG = ExoLogger.getLogger(UpdatePollingServlet.class);
    public static final int DEFAULT_TIMEOUT = 180000;
    private static final long serialVersionUID = -44481362110127541L;

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String pathInfo = req.getPathInfo();
        String remoteUser = req.getRemoteUser();
        if (remoteUser != null) {
            if (pathInfo != null && pathInfo.length() > 1) {
                String userId;
                int userEndIndex = (pathInfo = pathInfo.substring(1)).indexOf(47);
                String string = userId = userEndIndex > 0 ? pathInfo.substring(0, userEndIndex) : pathInfo;
                if (userId.equals(remoteUser)) {
                    final AtomicBoolean polling = new AtomicBoolean(true);
                    final AsyncContext acontext = req.startAsync((ServletRequest)req, (ServletResponse)resp);
                    final VideoCallsService videoCalls = (VideoCallsService)this.getContainer().getComponentInstanceOfType(VideoCallsService.class);
                    final UserCallListener userListener = new UserCallListener(userId){

                        @Override
                        public boolean isListening() {
                            return polling.get();
                        }

                        @Override
                        public void onCallState(String callId, String providerType, String callState, String callerId, String callerType) {
                            if (polling.compareAndSet(true, false)) {
                                StringBuilder body = new StringBuilder();
                                body.append('{');
                                body.append("\"eventType\": \"call_state\",");
                                body.append("\"callId\": \"");
                                body.append(callId);
                                body.append("\",\"providerType\": \"");
                                body.append(providerType);
                                body.append("\",\"callState\": \"");
                                body.append(callState);
                                body.append("\",\"caller\": {");
                                body.append("\"id\": \"");
                                body.append(callerId);
                                body.append("\",\"type\": \"");
                                body.append(callerType);
                                body.append("\"}");
                                body.append('}');
                                UpdatePollingServlet.this.sendContent(acontext, body.toString());
                            } else {
                                LOG.warn((Object)(">>> Fired onCallState(" + callId + ", " + callState + ") for already completed UpdatePollingServlet"));
                            }
                        }

                        @Override
                        public void onPartJoined(String callId, String providerType, String partId) {
                            if (polling.compareAndSet(true, false)) {
                                StringBuilder body = new StringBuilder();
                                body.append('{');
                                body.append("\"eventType\": \"call_joined\",");
                                body.append("\"callId\": \"");
                                body.append(callId);
                                body.append("\",\"providerType\": \"");
                                body.append(providerType);
                                body.append("\",\"part\": {");
                                body.append("\"id\": \"");
                                body.append(partId);
                                body.append("\"}");
                                body.append('}');
                                UpdatePollingServlet.this.sendContent(acontext, body.toString());
                            } else {
                                LOG.warn((Object)(">>> Fired onPartJoined(" + callId + ", " + partId + ") for already completed UpdatePollingServlet"));
                            }
                        }

                        @Override
                        public void onPartLeaved(String callId, String providerType, String partId) {
                            if (polling.compareAndSet(true, false)) {
                                StringBuilder body = new StringBuilder();
                                body.append('{');
                                body.append("\"eventType\": \"call_leaved\",");
                                body.append("\"callId\": \"");
                                body.append(callId);
                                body.append("\",\"providerType\": \"");
                                body.append(providerType);
                                body.append("\",\"part\": {");
                                body.append("\"id\": \"");
                                body.append(partId);
                                body.append("\"}");
                                body.append('}');
                                UpdatePollingServlet.this.sendContent(acontext, body.toString());
                            } else {
                                LOG.warn((Object)(">>> Fired onPartLeaved(" + callId + ", " + partId + ") for already completed UpdatePollingServlet"));
                            }
                        }
                    };
                    acontext.setTimeout(180000L);
                    acontext.addListener(new AsyncListener(){

                        public void onComplete(AsyncEvent event) throws IOException {
                            polling.set(false);
                            videoCalls.removeUserCallListener(userListener);
                        }

                        public void onTimeout(AsyncEvent event) throws IOException {
                            if (polling.compareAndSet(true, false)) {
                                HttpServletResponse resp = (HttpServletResponse)event.getSuppliedResponse();
                                if (!resp.isCommitted()) {
                                    UpdatePollingServlet.this.sendRetry(resp);
                                    acontext.complete();
                                } else {
                                    LOG.warn((Object)("<<< UpdatePollingServlet already committed for " + userId));
                                }
                                videoCalls.removeUserCallListener(userListener);
                            }
                        }

                        public void onError(AsyncEvent event) throws IOException {
                            polling.set(false);
                            videoCalls.removeUserCallListener(userListener);
                            Throwable err = event.getThrowable();
                            if (err != null) {
                                LOG.error((Object)("Error in UpdatePollingServlet for " + userId), err);
                            } else {
                                LOG.error((Object)("Error in UpdatePollingServlet for " + userId));
                            }
                        }

                        public void onStartAsync(AsyncEvent event) throws IOException {
                        }
                    });
                    videoCalls.addUserCallListener(userListener);
                } else {
                    LOG.warn((Object)("Accessing other user updates forbidden for " + remoteUser + ", has requested updates of " + userId));
                    this.sendError(resp, "Access forbidden", 403);
                }
            } else {
                LOG.warn((Object)("Wrong call update request path: " + pathInfo));
                this.sendError(resp, "Wrong request path", 400);
            }
        } else {
            LOG.warn((Object)("Unauthorized request to call update: " + pathInfo));
            this.sendError(resp, "Unauthorized user", 401);
        }
    }

    private void sendRetry(HttpServletResponse resp) {
        resp.setContentType("text/json");
        resp.setCharacterEncoding("UTF-8");
        byte[] entity = "{\"eventType\": \"retry\"}".getBytes(Charset.forName("UTF-8"));
        resp.setContentLength(entity.length);
        resp.setStatus(200);
        resp.setHeader("Cache-Control", "no-cache");
        try {
            resp.getOutputStream().write(entity);
        }
        catch (IOException e) {
            LOG.error((Object)"Failed handling call update request retry", (Throwable)e);
            try {
                resp.sendError(500);
            }
            catch (IOException e1) {
                LOG.error((Object)"Error sending error for call update request retry", (Throwable)e1);
            }
        }
    }

    private void sendError(HttpServletResponse resp, String message, int status) {
        resp.setContentType("text/json");
        resp.setCharacterEncoding("UTF-8");
        byte[] entity = ("{\"error\": \"" + message + "\"}").getBytes(Charset.forName("UTF-8"));
        resp.setContentLength(entity.length);
        resp.setStatus(status);
        resp.setHeader("Cache-Control", "no-cache");
        try {
            resp.getOutputStream().write(entity);
        }
        catch (IOException e) {
            LOG.error((Object)"Failed handling call update request error", (Throwable)e);
            try {
                resp.sendError(500);
            }
            catch (IOException e1) {
                LOG.error((Object)"Error sending error for call update request failure", (Throwable)e1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendContent(AsyncContext acontext, String content) {
        HttpServletResponse response = (HttpServletResponse)acontext.getResponse();
        response.setContentType("text/json");
        response.setCharacterEncoding("UTF-8");
        byte[] entity = content.getBytes(Charset.forName("UTF-8"));
        response.setContentLength(entity.length);
        response.setStatus(200);
        response.setHeader("Cache-Control", "no-cache");
        try {
            response.getOutputStream().write(entity);
        }
        catch (IOException e) {
            LOG.error((Object)"Error completing call update request", (Throwable)e);
            try {
                response.sendError(500);
            }
            catch (IOException e1) {
                LOG.error((Object)"Error sending error to call update request", (Throwable)e1);
            }
        }
        finally {
            acontext.complete();
        }
    }
}

