/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.videocalls.rest;

import javax.annotation.security.RolesAllowed;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.videocalls.GroupInfo;
import org.exoplatform.videocalls.UserInfo;
import org.exoplatform.videocalls.VideoCallsService;
import org.exoplatform.videocalls.rest.ErrorInfo;

@Path(value="/videocalls")
@Produces(value={"application/json"})
public class RESTVideoCallsService
implements ResourceContainer {
    public static final String ME = "me";
    protected static final Log LOG = ExoLogger.getLogger(RESTVideoCallsService.class);
    protected final VideoCallsService videoCalls;

    public RESTVideoCallsService(VideoCallsService skype) {
        this.videoCalls = skype;
    }

    @GET
    @RolesAllowed(value={"users"})
    @Path(value="/user/{name}")
    public Response getUserInfo(@Context UriInfo uriInfo, @PathParam(value="name") String userName) {
        ConversationState convo = ConversationState.getCurrent();
        if (convo != null) {
            String currentUserName = convo.getIdentity().getUserId();
            if (userName != null) {
                if (ME.equals(userName)) {
                    userName = currentUserName;
                }
                try {
                    UserInfo user = this.videoCalls.getUserInfo(userName);
                    if (user != null) {
                        return Response.ok().entity((Object)user).build();
                    }
                    return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)ErrorInfo.notFoundError("User not found or not accessible")).build();
                }
                catch (Throwable e) {
                    LOG.error((Object)("Error reading user info of '" + userName + "' by '" + currentUserName + "'"), e);
                    return Response.serverError().entity((Object)ErrorInfo.serverError("Error reading user " + userName)).build();
                }
            }
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ErrorInfo.clientError("Wrong request parameters: name")).build();
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)ErrorInfo.accessError("Unauthorized user")).build();
    }

    @GET
    @RolesAllowed(value={"users"})
    @Path(value="/space/{spaceName}")
    public Response getSpaceInfo(@Context UriInfo uriInfo, @PathParam(value="spaceName") String spaceName) {
        ConversationState convo = ConversationState.getCurrent();
        if (convo != null) {
            String currentUserName = convo.getIdentity().getUserId();
            if (spaceName != null && spaceName.length() > 0) {
                try {
                    VideoCallsService.SpaceInfo space = this.videoCalls.getSpaceInfo(spaceName);
                    if (space != null) {
                        if (((GroupInfo)space).getMembers().containsKey(currentUserName)) {
                            return Response.ok().entity((Object)space).build();
                        }
                        return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)ErrorInfo.accessError("Not space member")).build();
                    }
                    return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)ErrorInfo.notFoundError("Space not found or not accessible")).build();
                }
                catch (Throwable e) {
                    LOG.error((Object)("Error reading space info of '" + spaceName + "' by '" + currentUserName + "'"), e);
                    return Response.serverError().entity((Object)ErrorInfo.serverError("Error reading space " + spaceName)).build();
                }
            }
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ErrorInfo.clientError("Wrong request parameters: name")).build();
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)ErrorInfo.accessError("Unauthorized user")).build();
    }
}

