/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.videocalls.webrtc.portlet;

import java.io.IOException;
import java.net.URI;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletException;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.videocalls.VideoCallsService;
import org.exoplatform.videocalls.VideoCallsUtils;
import org.exoplatform.videocalls.webrtc.WebrtcProvider;
import org.exoplatform.videocalls.webrtc.WebrtcSettings;
import org.exoplatform.web.application.JavascriptManager;
import org.exoplatform.webui.application.WebuiRequestContext;

public class WebrtcProviderPortlet
extends GenericPortlet {
    private static final Log LOG = ExoLogger.getLogger(WebrtcProviderPortlet.class);
    private VideoCallsService videoCalls;
    private WebrtcProvider provider;

    public void init() throws PortletException {
        super.init();
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        this.videoCalls = (VideoCallsService)container.getComponentInstanceOfType(VideoCallsService.class);
        try {
            this.provider = (WebrtcProvider)this.videoCalls.getProvider("webrtc");
        }
        catch (ClassCastException e) {
            LOG.error((Object)("Provider webrtc isn't an instance of " + WebrtcProvider.class.getName()), (Throwable)e);
        }
    }

    protected void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        if (this.provider != null) {
            try {
                URI callURI = new URI(request.getScheme(), null, request.getServerName(), request.getServerPort(), "/portal/webrtc/call", null, null);
                WebrtcSettings settings = this.provider.settings().callUri(callURI.toString()).build();
                String settingsJson = VideoCallsUtils.asJSON((Object)settings);
                JavascriptManager js = ((WebuiRequestContext)WebuiRequestContext.getCurrentInstance()).getJavascriptManager();
                js.require("SHARED/videoCalls", "videoCalls").require("SHARED/videoCalls_webrtc", "webrtcProvider").addScripts("if (webrtcProvider) { webrtcProvider.configure(" + settingsJson + "); videoCalls.addProvider(webrtcProvider); videoCalls.update(); }");
            }
            catch (Exception e) {
                LOG.error((Object)("Error processing WebRTC call portlet for user " + request.getRemoteUser()), (Throwable)e);
            }
        }
    }
}

