/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.videocalls.webrtc.server;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.web.AbstractHttpServlet;
import org.exoplatform.videocalls.ContextInfo;
import org.exoplatform.videocalls.UserInfo;
import org.exoplatform.videocalls.VideoCallsService;
import org.exoplatform.videocalls.VideoCallsUtils;
import org.exoplatform.videocalls.webrtc.WebrtcProvider;
import org.exoplatform.videocalls.webrtc.WebrtcSettings;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;

public class WebrtcCallServlet
extends AbstractHttpServlet {
    private static final long serialVersionUID = -6075521943684342591L;
    protected static final Logger LOG = LoggerFactory.getLogger(WebrtcCallServlet.class);
    private static final String CALL_PAGE = "/WEB-INF/pages/call.jsp";
    private static final String UNAUTHORIZED_PAGE = "/WEB-INF/pages/unauthorized.html";
    private static final String SERVER_ERROR_PAGE = "/WEB-INF/pages/servererror.html";
    private static final String EMPTY_STRING = "".intern();

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        block18: {
            HttpServletRequest httpReq = req;
            HttpServletResponse httpRes = resp;
            Object redirectUri = httpReq.getAttribute("webrtccall_redirect");
            if (redirectUri != null) {
                String ruri = (String)redirectUri;
                if (ruri.length() > 0) {
                    httpRes.sendRedirect(ruri);
                }
            } else {
                httpRes.setContentType("text/html; charset=UTF-8");
                String remoteUser = httpReq.getRemoteUser();
                ExoContainer container = this.getContainer();
                VideoCallsService videoCalls = (VideoCallsService)container.getComponentInstanceOfType(VideoCallsService.class);
                if (videoCalls != null) {
                    WebrtcProvider provider;
                    try {
                        provider = (WebrtcProvider)videoCalls.getProvider("webrtc");
                    }
                    catch (ClassCastException e) {
                        LOG.error((Object)("Provider webrtc isn't an instance of " + WebrtcProvider.class.getName()), (Throwable)e);
                        provider = null;
                    }
                    if (provider != null) {
                        try {
                            req.setCharacterEncoding("UTF-8");
                        }
                        catch (UnsupportedEncodingException e) {
                            LOG.error((Object)"Encoding not supported", (Throwable)e);
                        }
                        if (remoteUser != null) {
                            try {
                                String roomTitle;
                                String spaceId = httpReq.getParameter("space");
                                if (spaceId == null) {
                                    spaceId = EMPTY_STRING;
                                }
                                if ((roomTitle = httpReq.getParameter("room")) == null) {
                                    roomTitle = EMPTY_STRING;
                                }
                                ContextInfo context = VideoCallsUtils.getCurrentContext((String)remoteUser);
                                httpReq.setAttribute("contextInfo", (Object)VideoCallsUtils.asJSON((Object)context));
                                UserInfo exoUser = videoCalls.getUserInfo(remoteUser);
                                if (exoUser != null) {
                                    httpReq.setAttribute("userInfo", (Object)VideoCallsUtils.asJSON((Object)exoUser));
                                    URI callURI = new URI(httpReq.getScheme(), null, httpReq.getServerName(), httpReq.getServerPort(), "/portal/webrtc/call", null, null);
                                    WebrtcSettings settings = provider.settings().callUri(callURI.toString()).build();
                                    httpReq.setAttribute("settings", (Object)VideoCallsUtils.asJSON((Object)settings));
                                    httpReq.getRequestDispatcher("/WEB-INF/pages/call_part1.jsp").include((ServletRequest)httpReq, (ServletResponse)httpRes);
                                    ServletContext cometdContext = httpReq.getSession().getServletContext().getContext("/cometd");
                                    cometdContext.getRequestDispatcher("/javascript/eXo/commons/commons-cometd3.js").include((ServletRequest)httpReq, (ServletResponse)httpRes);
                                    httpReq.getRequestDispatcher("/WEB-INF/pages/call_part2.jsp").include((ServletRequest)httpReq, (ServletResponse)httpRes);
                                    break block18;
                                }
                                LOG.warn((Object)("WebRTC servlet cannot be initialized: user info cannot be obtained for " + remoteUser));
                            }
                            catch (Exception e) {
                                LOG.error((Object)"Error processing WebRTC call page", (Throwable)e);
                                httpRes.setStatus(500);
                                httpReq.getRequestDispatcher(SERVER_ERROR_PAGE).include((ServletRequest)httpReq, (ServletResponse)httpRes);
                            }
                        } else {
                            httpRes.setStatus(401);
                            httpReq.getRequestDispatcher(UNAUTHORIZED_PAGE).include((ServletRequest)httpReq, (ServletResponse)httpRes);
                        }
                    } else {
                        LOG.error((Object)("Skype provider not found for call page and user " + remoteUser));
                        httpRes.setStatus(500);
                        httpReq.getRequestDispatcher(SERVER_ERROR_PAGE).include((ServletRequest)httpReq, (ServletResponse)httpRes);
                    }
                } else {
                    LOG.error((Object)("Video Calls service not found for call page and user " + remoteUser));
                    httpRes.setStatus(500);
                    httpReq.getRequestDispatcher(SERVER_ERROR_PAGE).include((ServletRequest)httpReq, (ServletResponse)httpRes);
                }
            }
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }
}

