/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.externaluser;

import com.ibm.icu.text.Transliterator;
import java.security.SecureRandom;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Base64;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Random;
import java.util.ResourceBundle;
import javax.annotation.security.RolesAllowed;
import javax.jcr.Node;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.api.notification.plugin.NotificationPluginUtils;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.mail.MailService;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.MembershipType;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.Query;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserStatus;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.MembershipEntry;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.json.JSONObject;
import org.picocontainer.Startable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="externalUser")
public class ExternalUserService
implements ResourceContainer,
Startable {
    private static final Logger LOG = LoggerFactory.getLogger(ExternalUserService.class);
    public static final String EXO_SHOULD_CHANGE_PASS = "exo:shouldChangePassword";
    public static final String EXO_EXPIRATION_DATE = "exo:passwordExpirationDate";
    private static final Random RANDOM = new SecureRandom();
    public static final int PASSWORD_LENGTH = 8;
    public static final String NEW_USER_INVITED_EVENT = "ExternalUser.event.userInvited";
    private static final String USER_INVITATION_FAIL_EVENT = "ExternalUser.event.userInvitationMailFail";
    public static final String EXTERNAL_USER_CREATED_EVENT = "ExternalUser.event.userCreated";
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    private PortalContainer container;
    private OrganizationService organizationService;
    private SpaceService spaceService;
    private ListenerService listenerService;
    private IdentityManager identityManager;
    private MailService mailService;
    private SettingService settingService;
    private static Map<String, ResourceBundle> BUNDLE = new HashMap<String, ResourceBundle>();
    private boolean assignUserToSpecificGroup = false;
    private boolean userSenderMail = false;
    private boolean enableSpaceInvitation = false;
    private String generatedUsernamePatttern;
    private String spaceAllowedRole;
    private String adminAllowedPermission;
    private String externalUsersGroupId;
    private String externalUsersMembershipTypeId;
    private Group externalUsersGroup;
    private MembershipType externalUsersMembershipType;
    private int disableUserPeriodInDays;
    String invitationTemplateLocation;
    String activationTemplateLocation;

    public ExternalUserService(InitParams initParams) {
        String disableUserPeriodString;
        String assignUserToSpecificGroupString;
        if (initParams.containsKey((Object)"invite.externaluser.activationTemplate")) {
            this.activationTemplateLocation = initParams.getValueParam("invite.externaluser.activationTemplate").getValue();
        }
        if (initParams.containsKey((Object)"invite.externaluser.invitationTemplate")) {
            this.invitationTemplateLocation = initParams.getValueParam("invite.externaluser.invitationTemplate").getValue();
        }
        if (StringUtils.isBlank((CharSequence)this.invitationTemplateLocation)) {
            LOG.error("Mandatory parameter 'invite.externaluser.invitationTemplate' is missing. Invitation template JCR path is required");
        }
        if (initParams.containsKey((Object)"invite.externaluser.useInvitationSenderMail")) {
            this.userSenderMail = initParams.getValueParam("invite.externaluser.useInvitationSenderMail").getValue().equals("true");
        }
        if (initParams.containsKey((Object)"invite.externaluser.usernamePattern")) {
            this.generatedUsernamePatttern = initParams.getValueParam("invite.externaluser.usernamePattern").getValue();
        }
        if (StringUtils.isBlank((CharSequence)this.generatedUsernamePatttern)) {
            LOG.error("Mandatory parameter 'invite.externaluser.usernamePattern' is undefined");
        }
        if (initParams.containsKey((Object)"invite.externaluser.space.enableInvitation")) {
            String enableSpaceInvitationString = initParams.getValueParam("invite.externaluser.space.enableInvitation").getValue();
            boolean bl = this.enableSpaceInvitation = !StringUtils.isEmpty((CharSequence)enableSpaceInvitationString) && enableSpaceInvitationString.equals("true");
        }
        if (initParams.containsKey((Object)"invite.externaluser.space.role")) {
            this.spaceAllowedRole = initParams.getValueParam("invite.externaluser.space.role").getValue();
        }
        if (StringUtils.isBlank((CharSequence)this.spaceAllowedRole)) {
            LOG.error("Mandatory parameter 'invite.externaluser.space.role' is undefined");
        }
        if (initParams.containsKey((Object)"invite.externaluser.permission")) {
            this.adminAllowedPermission = initParams.getValueParam("invite.externaluser.permission").getValue();
        }
        if (StringUtils.isBlank((CharSequence)this.adminAllowedPermission)) {
            LOG.error("Mandatory parameter 'invite.externaluser.permission' is undefined");
        }
        if (initParams.containsKey((Object)"invite.externaluser.assignToSpecificGroup") && !StringUtils.isBlank((CharSequence)(assignUserToSpecificGroupString = initParams.getValueParam("invite.externaluser.assignToSpecificGroup").getValue()))) {
            this.assignUserToSpecificGroup = Boolean.parseBoolean(assignUserToSpecificGroupString);
        }
        if (this.assignUserToSpecificGroup) {
            if (initParams.containsKey((Object)"invite.externaluser.groupname")) {
                this.externalUsersGroupId = initParams.getValueParam("invite.externaluser.groupname").getValue();
            }
            if (StringUtils.isBlank((CharSequence)this.externalUsersGroupId)) {
                LOG.error("Mandatory parameter 'invite.externaluser.groupname' is undefined");
            }
            if (initParams.containsKey((Object)"invite.externaluser.membershipType")) {
                this.externalUsersMembershipTypeId = initParams.getValueParam("invite.externaluser.membershipType").getValue();
            }
            if (StringUtils.isBlank((CharSequence)this.externalUsersMembershipTypeId)) {
                LOG.error("Mandatory parameter 'invite.externaluser.membershipType' is undefined");
            }
        }
        if (initParams.containsKey((Object)"invite.externaluser.disableUserPeriod") && !StringUtils.isBlank((CharSequence)(disableUserPeriodString = initParams.getValueParam("invite.externaluser.disableUserPeriod").getValue()))) {
            this.disableUserPeriodInDays = Integer.parseInt(disableUserPeriodString);
        }
    }

    public void start() {
        if (this.container == null) {
            this.container = PortalContainer.getInstance();
            this.organizationService = (OrganizationService)this.container.getComponentInstanceOfType(OrganizationService.class);
            this.spaceService = (SpaceService)this.container.getComponentInstanceOfType(SpaceService.class);
            this.listenerService = (ListenerService)this.container.getComponentInstanceOfType(ListenerService.class);
            this.identityManager = (IdentityManager)this.container.getComponentInstanceOfType(IdentityManager.class);
            this.mailService = (MailService)this.container.getComponentInstanceOfType(MailService.class);
            this.settingService = (SettingService)this.container.getComponentInstanceOfType(SettingService.class);
        }
        if (!StringUtils.isBlank((CharSequence)this.externalUsersMembershipTypeId)) {
            try {
                this.externalUsersMembershipType = this.organizationService.getMembershipTypeHandler().findMembershipType(this.externalUsersMembershipTypeId);
            }
            catch (Exception e) {
                LOG.error("Error while getting membership type with id " + this.externalUsersMembershipTypeId, (Throwable)e);
            }
        }
        if (this.externalUsersMembershipType == null) {
            LOG.error("MembershipType '{}' is not found, cannot add users to group with MembershipType", (Object)this.externalUsersMembershipTypeId);
        }
        if (!StringUtils.isBlank((CharSequence)this.externalUsersGroupId)) {
            try {
                this.externalUsersGroup = this.organizationService.getGroupHandler().findGroupById(this.externalUsersGroupId);
            }
            catch (Exception e) {
                LOG.error("Error while getting group with id " + this.externalUsersGroupId, (Throwable)e);
            }
        }
        if (this.externalUsersGroup == null) {
            LOG.error("External users group '{}' is not found, cannot add users to group", (Object)this.externalUsersGroupId);
        }
    }

    public void stop() {
    }

    @GET
    @Path(value="bundle")
    @RolesAllowed(value={"users"})
    @Produces(value={"application/json"})
    public String getBundle(@QueryParam(value="locale") String locale) {
        try {
            if (BUNDLE.get(locale) == null) {
                BUNDLE.put(locale, this.getResourceBundle(new Locale(locale)));
            }
            JSONObject data = new JSONObject();
            Enumeration<String> enumeration = BUNDLE.get(locale).getKeys();
            while (enumeration.hasMoreElements()) {
                String key = enumeration.nextElement();
                try {
                    data.put(key.replaceAll("(.*)\\.", ""), BUNDLE.get(locale).getObject(key));
                }
                catch (MissingResourceException missingResourceException) {}
            }
            return data.toString();
        }
        catch (Throwable e) {
            LOG.error("error while getting resource bundle", e);
            return null;
        }
    }

    @GET
    @Path(value="enableSpaceInvitation")
    @RolesAllowed(value={"users"})
    public Response enableSpaceInvitation() {
        return Response.ok((Object)("" + this.enableSpaceInvitation)).build();
    }

    @POST
    @Path(value="invite")
    @RolesAllowed(value={"users"})
    public Response invite(@FormParam(value="pathname") String pathname, @FormParam(value="firstName") String firstName, @FormParam(value="lastName") String lastName, @FormParam(value="email") String email) {
        Identity currentIdentity = ConversationState.getCurrent().getIdentity();
        String spaceGroupId = null;
        if (pathname.contains(":spaces:") ? !currentIdentity.isMemberOf(spaceGroupId = this.getSpaceGroupId(pathname), this.spaceAllowedRole) : !currentIdentity.isMemberOf(MembershipEntry.parse((String)this.adminAllowedPermission))) {
            return Response.status((int)403).build();
        }
        try {
            Query query = new Query();
            query.setEmail(email);
            ListAccess findUsersByMailResult = this.organizationService.getUserHandler().findUsersByQuery(query, UserStatus.ANY);
            String username = null;
            User invitedUser = null;
            boolean newUser = false;
            if (findUsersByMailResult.getSize() == 0) {
                newUser = true;
                invitedUser = this.createNewUser(firstName, lastName, email);
                this.listenerService.broadcast(EXTERNAL_USER_CREATED_EVENT, (Object)invitedUser, (Object)invitedUser);
                username = invitedUser.getUserName();
                RequestLifeCycle.end();
                LOG.info("User '{}' created", (Object)email);
                RequestLifeCycle.begin((ExoContainer)this.container);
            } else if (findUsersByMailResult.getSize() == 1) {
                if (spaceGroupId == null) {
                    LOG.error("User '{}' already exists", (Object)email);
                    return Response.status((int)500).build();
                }
                invitedUser = ((User[])findUsersByMailResult.load(0, 1))[0];
                username = invitedUser.getUserName();
            } else {
                LOG.error("Can't invite user '{}' because the email was found more than once in DB", (Object)email);
                return Response.status((int)500).build();
            }
            Space space = null;
            if (spaceGroupId != null) {
                space = this.spaceService.getSpaceByGroupId(spaceGroupId);
                if (space == null) {
                    LOG.error("Can't invite user '{}' because the space was not found", (Object)email);
                    return Response.status((int)500).build();
                }
                if (this.spaceService.isMember(space, username) || this.spaceService.isInvitedUser(space, username)) {
                    LOG.warn("User {} is already invited or member of the space {}", (Object)username, (Object)space.getDisplayName());
                } else if (newUser) {
                    this.spaceService.addMember(space, username);
                } else {
                    this.spaceService.addInvitedUser(space, username);
                }
            }
            if (newUser) {
                this.sendInvitationMail(invitedUser, space, this.invitationTemplateLocation, null);
                this.listenerService.broadcast(NEW_USER_INVITED_EVENT, (Object)invitedUser, (Object)space);
            }
            return Response.ok().build();
        }
        catch (Exception e) {
            LOG.error("An error occurred when saving external user", (Throwable)e);
            return Response.status((int)500).build();
        }
    }

    public void sendInvitationMail(User invitedUser, Space space, String mailTemplatePath, String link) throws Exception {
        Profile managerProfile;
        String managerPosition;
        Node node = (Node)WCMCoreUtils.getRepository().getSystemSession("collaboration").getItem(mailTemplatePath);
        User managerUser = (User)ConversationState.getCurrent().getAttribute("UserProfile");
        if (managerUser == null && (managerUser = this.organizationService.getUserHandler().findUserByName(ConversationState.getCurrent().getIdentity().getUserId(), UserStatus.ANY)).getUserName().equals(invitedUser.getUserName())) {
            managerUser = null;
        }
        String to = invitedUser.getEmail();
        String from = NotificationPluginUtils.getEmailFrom();
        if (this.userSenderMail && managerUser != null) {
            from = managerUser.getEmail();
        }
        String subject = node.getProperty("jcr:content/dc:title").getValues()[0].getString();
        String body = node.getProperty("jcr:content/jcr:data").getString();
        if (managerUser != null) {
            body = body.replace("[SENDER]", managerUser.getDisplayName());
        }
        body = body.replace("[USERNAME]", invitedUser.getUserName());
        if ((body = body.replace("[USER_FULLNAME]", invitedUser.getDisplayName())).contains("[SENDER_TITLE]") && !StringUtils.isBlank((CharSequence)(managerPosition = (managerProfile = this.identityManager.getOrCreateIdentity("organization", managerUser.getUserName(), true).getProfile()).getPosition()))) {
            body = body.replace("[SENDER_TITLE]", managerPosition);
        }
        if (space != null) {
            body = body.replace("[SPACE_NAME]", space.getDisplayName());
        }
        if (link != null) {
            body = body.replace("[LINK]", link);
        }
        if (invitedUser.getPassword() != null) {
            body = body.replace("[PASSWORD]", invitedUser.getPassword());
        }
        try {
            this.mailService.sendMessage(from, to, subject, body);
        }
        catch (Exception e) {
            LOG.error("Error while sending mail to '" + invitedUser.getEmail() + "'", (Throwable)e);
            try {
                this.listenerService.broadcast(USER_INVITATION_FAIL_EVENT, (Object)invitedUser, (Object)e);
            }
            catch (Exception e1) {
                LOG.error("ERROR when broadcasting Mail Send Operation Error, cause: ", (Throwable)e1);
            }
            throw e;
        }
    }

    public Object getSetting(String userId, String key) {
        SettingValue value = this.settingService.get(Context.USER.id(userId), Scope.GLOBAL, key);
        return value == null ? null : value.getValue();
    }

    public Group getExternalUsersGroup() {
        return this.externalUsersGroup;
    }

    public long getDisableUserPeriodInDays() {
        return this.disableUserPeriodInDays;
    }

    public boolean isAssignUserToSpecificGroup() {
        return this.assignUserToSpecificGroup;
    }

    public String getActivationTemplateLocation() {
        return this.activationTemplateLocation;
    }

    protected String generateUsername(String firstName, String lastName, String email) {
        String lastNameSimplified = this.deleteSpecialCharacters(lastName);
        String firstNameSimplified = this.deleteSpecialCharacters(firstName);
        String emailSimplified = this.deleteSpecialCharacters(email);
        String usernameBase = this.generatedUsernamePatttern.replace("firstName", firstNameSimplified);
        usernameBase = usernameBase.replace("lastName", lastNameSimplified);
        usernameBase = usernameBase.replace("email", emailSimplified);
        return usernameBase;
    }

    protected ResourceBundle getResourceBundle(Locale locale) {
        return ResourceBundle.getBundle("locale.addon.externaluser", locale, this.getClass().getClassLoader());
    }

    private String getSpaceGroupId(String pathname) {
        int indexOfSpacesParent = pathname.indexOf(":spaces:");
        int indexOfEndOfSpaceName = pathname.indexOf(47, indexOfSpacesParent);
        String spaceGroupId = pathname.substring(indexOfSpacesParent, indexOfEndOfSpaceName);
        spaceGroupId = spaceGroupId.replaceAll(":", "/");
        return spaceGroupId;
    }

    private User createNewUser(String firstName, String lastName, String email) throws Exception {
        String usernameBase = this.generateUsername(firstName, lastName, email);
        int index = 1;
        String username = this.getUsername(usernameBase, usernameBase, index);
        User invitedUser = this.organizationService.getUserHandler().createUserInstance(username);
        invitedUser.setFirstName(firstName);
        invitedUser.setLastName(lastName);
        invitedUser.setEmail(email);
        String password = ExternalUserService.generateRandomPassword();
        invitedUser.setPassword(password);
        invitedUser.setDisplayName(firstName + " " + lastName);
        this.organizationService.getUserHandler().createUser(invitedUser, true);
        if (this.assignUserToSpecificGroup && this.externalUsersMembershipType != null && this.externalUsersGroup != null) {
            this.organizationService.getMembershipHandler().linkMembership(invitedUser, this.externalUsersGroup, this.externalUsersMembershipType, true);
        }
        return invitedUser;
    }

    private String deleteSpecialCharacters(String usernameBase) {
        Transliterator accentsconverter = Transliterator.getInstance((String)"NFD; [:Nonspacing Mark:] Remove; NFC");
        usernameBase = accentsconverter.transliterate(usernameBase.toLowerCase());
        return usernameBase.replaceAll("[^a-zA-Z0-9]", "");
    }

    private String getUsername(String username, String usernameBase, int index) throws Exception {
        User user = this.organizationService.getUserHandler().findUserByName(username, UserStatus.ANY);
        if (user != null) {
            username = usernameBase + "." + ++index;
            username = this.getUsername(username, usernameBase, index);
        }
        return username;
    }

    private static String generateRandomPassword() {
        String letters = "abcdefghjkmnpqrstuvwxyzABCDEFGHJKMNPQRSTUVWXYZ23456789+@";
        String pw = "";
        for (int i = 0; i < 8; ++i) {
            int index = (int)(RANDOM.nextDouble() * (double)letters.length());
            pw = pw + letters.substring(index, index + 1);
        }
        return pw;
    }

    public Calendar addPasswordExpiration(String userId, Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(10, 24 * this.disableUserPeriodInDays);
        date = calendar.getTime();
        this.settingService.set(Context.USER.id(userId), Scope.GLOBAL, EXO_EXPIRATION_DATE, new SettingValue((Object)DATE_FORMAT.format(date)));
        this.settingService.set(Context.USER.id(userId), Scope.GLOBAL, EXO_SHOULD_CHANGE_PASS, new SettingValue((Object)false));
        return calendar;
    }

    public void addPasswordExpiration(ConversationState state, Date date) {
        String userId = state.getIdentity().getUserId();
        Calendar calendar = this.addPasswordExpiration(userId, date);
        state.setAttribute(EXO_EXPIRATION_DATE, (Object)calendar);
        state.setAttribute(EXO_SHOULD_CHANGE_PASS, (Object)false);
    }

    public boolean hasPasswordExpired(String userId) {
        Date passwordExpirationDate = this.getPasswordExpirationDate(userId);
        if (passwordExpirationDate == null) {
            throw new IllegalStateException("User password expiration date is not valid, null");
        }
        Calendar passwordExpirationCalendar = Calendar.getInstance();
        passwordExpirationCalendar.setTime(passwordExpirationDate);
        return Calendar.getInstance().after(passwordExpirationCalendar);
    }

    public boolean hasPasswordExpired(ConversationState state) {
        Calendar passwordExpirationCalendar = (Calendar)state.getAttribute(EXO_EXPIRATION_DATE);
        if (passwordExpirationCalendar == null) {
            Date passwordExpirationDate = this.getPasswordExpirationDate(state.getIdentity().getUserId());
            if (passwordExpirationDate == null) {
                throw new IllegalStateException("User password expiration date is not valid, null");
            }
            passwordExpirationCalendar = Calendar.getInstance();
            passwordExpirationCalendar.setTime(passwordExpirationDate);
            state.setAttribute(EXO_EXPIRATION_DATE, (Object)passwordExpirationCalendar);
        }
        return Calendar.getInstance().after(passwordExpirationCalendar);
    }

    public boolean isUserExternal(ConversationState state, String userId) {
        boolean isExternal = false;
        if (!this.isAssignUserToSpecificGroup()) {
            LOG.warn("'Auto disable' External User Feature cannot be enabled. Please enable the 'assignment of external users to a group' feature.");
        }
        if (this.getExternalUsersGroup() == null) {
            LOG.warn("'Auto disable' External User Feature cannot be enabled. Please specify a valid External Users Group.");
        }
        if (this.getExternalUsersGroup() != null && this.isAssignUserToSpecificGroup()) {
            Group externalUsersGroup = this.getExternalUsersGroup();
            String extGroupId = externalUsersGroup.getId();
            isExternal = state.getIdentity().isMemberOf(extGroupId);
        }
        return isExternal;
    }

    public boolean shouldChangePassword(ConversationState state) {
        Boolean shouldChangePass = (Boolean)state.getAttribute(EXO_SHOULD_CHANGE_PASS);
        if (shouldChangePass == null) {
            String userId = state.getIdentity().getUserId();
            shouldChangePass = this.shouldChangePassword(userId);
            if (shouldChangePass == null) {
                throw new IllegalStateException("User password state is null");
            }
            state.setAttribute(EXO_SHOULD_CHANGE_PASS, (Object)shouldChangePass);
        }
        return shouldChangePass;
    }

    public boolean shouldChangePassword(String userId) {
        Boolean setting = (Boolean)this.getSetting(userId, EXO_SHOULD_CHANGE_PASS);
        return setting == null || setting != false;
    }

    public Date getPasswordExpirationDate(String userId) {
        String passwordExpirationString = (String)this.getSetting(userId, EXO_EXPIRATION_DATE);
        if (passwordExpirationString == null) {
            throw new IllegalStateException("User password expiration date is not valid, null");
        }
        Date passwordExpirationDate = null;
        try {
            passwordExpirationDate = DATE_FORMAT.parse(passwordExpirationString);
        }
        catch (Exception e) {
            throw new IllegalStateException("User password expiration date is not valid, " + passwordExpirationString);
        }
        return passwordExpirationDate;
    }

    public static void main(String[] args) {
        System.out.println(Base64.getEncoder().encodeToString("passwordExpirationDate".getBytes()));
    }
}

