/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.externaluser;

import java.io.IOException;
import java.util.Calendar;
import javax.servlet.FilterChain;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.addon.externaluser.ExternalUserService;
import org.exoplatform.addon.externaluser.ExternalUserTokenService;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserStatus;
import org.exoplatform.services.security.Authenticator;
import org.exoplatform.services.security.ConversationRegistry;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityRegistry;
import org.exoplatform.services.security.StateKey;
import org.exoplatform.services.security.web.HttpSessionStateKey;
import org.exoplatform.web.filter.Filter;
import org.exoplatform.web.security.security.RemindPasswordTokenService;
import org.gatein.wci.security.Credentials;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalUserDisableFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(ExternalUserDisableFilter.class);
    private ExternalUserService externalUserService;
    private OrganizationService organizationService;
    private ConversationRegistry conversationRegistry;
    private IdentityRegistry identityRegistry;
    private ExternalUserTokenService tokenService;
    private Authenticator authenticator;
    private RemindPasswordTokenService remindPasswordTokenService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        block15: {
            if (this.externalUserService == null) {
                this.externalUserService = (ExternalUserService)PortalContainer.getInstance().getComponentInstanceOfType(ExternalUserService.class);
                this.tokenService = (ExternalUserTokenService)((Object)PortalContainer.getInstance().getComponentInstanceOfType(ExternalUserTokenService.class));
                this.organizationService = (OrganizationService)PortalContainer.getInstance().getComponentInstanceOfType(OrganizationService.class);
                this.conversationRegistry = (ConversationRegistry)PortalContainer.getInstance().getComponentInstanceOfType(ConversationRegistry.class);
                this.identityRegistry = (IdentityRegistry)PortalContainer.getInstance().getComponentInstanceOfType(IdentityRegistry.class);
                this.authenticator = (Authenticator)PortalContainer.getInstance().getComponentInstanceOfType(Authenticator.class);
                this.remindPasswordTokenService = (RemindPasswordTokenService)PortalContainer.getInstance().getComponentInstanceOfType(RemindPasswordTokenService.class);
            }
            if (this.externalUserService.getDisableUserPeriodInDays() <= 0L) {
                chain.doFilter(request, response);
                return;
            }
            if (!(request instanceof HttpServletRequest)) {
                chain.doFilter(request, response);
                return;
            }
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            ConversationState state = this.getCurrentState(httpRequest);
            if (httpRequest.getRequestURI().contains("/changePass") && httpRequest.getParameter("tokenId") != null && httpRequest.getParameter("password") != null) {
                this.changePassword(httpRequest, httpResponse, state);
                httpResponse.sendRedirect("/");
                return;
            }
            if (httpRequest.getRequestURI().contains("/activateUser") && httpRequest.getParameter("tokenId") != null) {
                boolean userActivated = this.activateUser(httpRequest, httpResponse);
                if (userActivated) {
                    PortalContainer pContainer = PortalContainer.getInstance();
                    ServletContext context = pContainer.getPortalContext();
                    context.getRequestDispatcher("/jsp/userActivatedAgain.jsp").forward((ServletRequest)httpRequest, (ServletResponse)httpResponse);
                } else {
                    httpResponse.sendRedirect("/");
                }
                return;
            }
            String userId = httpRequest.getRemoteUser();
            if (!StringUtils.isBlank((String)userId)) {
                RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
                try {
                    boolean isExternal = this.externalUserService.isUserExternal(state, userId);
                    if (!isExternal) break block15;
                    boolean changePassword = this.externalUserService.shouldChangePassword(state);
                    if (changePassword) {
                        Credentials credentials = new Credentials(userId, "");
                        String tokenId = this.remindPasswordTokenService.createToken(credentials);
                        httpRequest.setAttribute("tokenId", (Object)tokenId);
                        PortalContainer pContainer = PortalContainer.getInstance();
                        ServletContext context = pContainer.getPortalContext();
                        context.getRequestDispatcher("/jsp/reset_password.jsp").forward((ServletRequest)httpRequest, (ServletResponse)httpResponse);
                        return;
                    }
                    boolean passwordExpired = this.externalUserService.hasPasswordExpired(userId);
                    if (!passwordExpired) break block15;
                    try {
                        this.organizationService.getUserHandler().setEnabled(userId, false, true);
                        this.sendActivationMail(httpRequest, userId);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Can't disable user '" + userId + "' that has an expired password", e);
                    }
                    PortalContainer pContainer = PortalContainer.getInstance();
                    ServletContext context = pContainer.getPortalContext();
                    context.getRequestDispatcher("/jsp/userPasswordExpired.jsp").forward((ServletRequest)httpRequest, (ServletResponse)httpResponse);
                    httpRequest.getSession(true).invalidate();
                    return;
                }
                finally {
                    RequestLifeCycle.end();
                }
            }
        }
        chain.doFilter(request, response);
    }

    private void sendActivationMail(HttpServletRequest httpRequest, String userId) throws Exception {
        Credentials credentials = new Credentials(userId, "");
        String tokenId = this.tokenService.createToken(credentials);
        String host = httpRequest.getScheme() + "://" + httpRequest.getServerName() + ":" + httpRequest.getServerPort();
        String activeLink = host + httpRequest.getServletContext().getContextPath() + "/activateUser?tokenId=" + tokenId;
        User invitedUser = this.organizationService.getUserHandler().findUserByName(userId, UserStatus.ANY);
        this.externalUserService.sendInvitationMail(invitedUser, null, this.externalUserService.getActivationTemplateLocation(), activeLink);
    }

    private boolean activateUser(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException {
        String tokenId = httpRequest.getParameter("tokenId");
        Credentials credentials = this.tokenService.validateToken(tokenId, true);
        if (credentials == null) {
            return false;
        }
        String userId = credentials.getUsername();
        try {
            this.organizationService.getUserHandler().setEnabled(userId, true, true);
        }
        catch (Exception e) {
            LOG.error("Error when enabling user '" + userId + "'", (Throwable)e);
        }
        this.externalUserService.addPasswordExpiration(userId, Calendar.getInstance().getTime());
        return true;
    }

    private void changePassword(HttpServletRequest httpRequest, HttpServletResponse httpResponse, ConversationState state) {
        String tokenId = httpRequest.getParameter("tokenId");
        String extUserId = state.getIdentity().getUserId();
        Credentials credentials = this.remindPasswordTokenService.validateToken(tokenId, true);
        if (credentials != null && credentials.getUsername().equals(extUserId)) {
            String password = httpRequest.getParameter("password");
            try {
                User user = this.organizationService.getUserHandler().findUserByName(extUserId, UserStatus.ANY);
                user.setPassword(password);
                this.organizationService.getUserHandler().saveUser(user, false);
                this.externalUserService.addPasswordExpiration(state, Calendar.getInstance().getTime());
            }
            catch (Exception e) {
                LOG.error("Error while changing user '" + extUserId + "' password.", (Throwable)e);
            }
        }
    }

    private ConversationState getCurrentState(HttpServletRequest httpRequest) {
        Identity identity;
        HttpSession httpSession;
        HttpSessionStateKey stateKey;
        ConversationState state = null;
        String userId = httpRequest.getRemoteUser();
        if (userId != null && (state = this.conversationRegistry.getState((StateKey)(stateKey = new HttpSessionStateKey(httpSession = httpRequest.getSession())))) == null && (identity = this.identityRegistry.getIdentity(userId)) != null) {
            state = new ConversationState(identity);
            try {
                identity = this.authenticator.createIdentity(userId);
                state = new ConversationState(identity);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable restore identity of user '" + userId + "'", e);
            }
        }
        return state;
    }
}

