/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.override;

import org.exoplatform.commons.file.services.FileService;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.service.FunctionalConfigurationService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManagerImpl;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.storage.api.ActivityStorage;
import org.exoplatform.upload.UploadService;

public class FunctionalConfigurationActivityManagerImpl
extends ActivityManagerImpl {
    private static final Log LOG = ExoLogger.getLogger(ActivityManagerImpl.class);
    private FunctionalConfigurationService functionalConfigurationService;
    public static final String DOCLINK = "DOCLINK";

    public FunctionalConfigurationActivityManagerImpl(FunctionalConfigurationService functionalConfigurationService, ActivityStorage activityStorage, IdentityManager identityManager, UserACL userACL, FileService fileService, UploadService uploadService, RepositoryService repositoryService, NodeHierarchyCreator nodeHierarchyCreator, InitParams params) {
        super(activityStorage, identityManager, userACL, fileService, uploadService, repositoryService, nodeHierarchyCreator, params);
        this.functionalConfigurationService = functionalConfigurationService;
    }

    public void saveActivityNoReturn(Identity streamOwner, ExoSocialActivity newActivity) {
        boolean hideActivity = this.documentActivityHidden(newActivity);
        LOG.debug((Object)("Functional Configuration ActivityManagerOverride, check if we want activity for documents : documentActivityHidden=" + hideActivity));
        if (!hideActivity) {
            super.saveActivityNoReturn(streamOwner, newActivity);
        }
    }

    public void updateActivity(ExoSocialActivity existingActivity) {
        if (existingActivity.getId() != null) {
            super.updateActivity(existingActivity);
        }
    }

    private boolean documentActivityHidden(ExoSocialActivity newActivity) {
        return this.functionalConfigurationService.isDocumentActionActivityHidden() && (newActivity.getType().equals("files:spaces") && !newActivity.getTemplateParams().containsKey(DOCLINK) || newActivity.getType().equals("contents:spaces"));
    }
}

