/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.termsconditions;

import java.util.Objects;
import javax.jcr.Node;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.rest.response.TermsAndConditions;
import org.exoplatform.service.FunctionalConfigurationService;
import org.exoplatform.service.exception.FunctionalConfigurationRuntimeException;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserProfile;
import org.exoplatform.utils.NodeUtils;

public class TermsAndConditionsService {
    private static final Log LOGGER = ExoLogger.getLogger(TermsAndConditionsService.class);
    private static final String TERMS_AND_CONDITONS_PROPERTY = "acceptedTermsAndConditions";
    private FunctionalConfigurationService functionalConfigurationService;
    private OrganizationService organizationService;
    private UserACL userACL;

    public TermsAndConditionsService(FunctionalConfigurationService functionalConfigurationService, OrganizationService organizationService, UserACL userACL) {
        this.functionalConfigurationService = functionalConfigurationService;
        this.organizationService = organizationService;
        this.userACL = userACL;
    }

    boolean isTermsAndConditionsAcceptedBy(String userName) {
        if (this.userACL.isSuperUser()) {
            return true;
        }
        try {
            UserProfile userProfile = this.findUserProfileByUserName(userName);
            String acceptedTermsVersion = userProfile.getAttribute(TERMS_AND_CONDITONS_PROPERTY);
            String currentVersion = this.getCurrentTermsAndConditionsVersion();
            return currentVersion.equals(acceptedTermsVersion);
        }
        catch (Exception e) {
            LOGGER.warn((Object)("Error while checking Terms and conditions accepted for user: " + userName + " - considered as not accepted"), (Throwable)e);
            return false;
        }
    }

    private String getCurrentTermsAndConditionsVersion() {
        String DEFAULT_DRAFT_VERSION_NAME = "jcr:rootVersion";
        TermsAndConditions termsAndConditions = this.functionalConfigurationService.getTermsAndConditions();
        Node termsAndConditionsNode = NodeUtils.findCollaborationFile(termsAndConditions.getWebContentUrl());
        try {
            String name = termsAndConditionsNode.getBaseVersion().getName();
            if ("jcr:rootVersion".equals(name)) {
                throw new FunctionalConfigurationRuntimeException("invalid.termsAndConditions");
            }
            return name;
        }
        catch (Exception e) {
            throw new FunctionalConfigurationRuntimeException("invalid.termsAndConditions");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void accept(String userName) {
        RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
        try {
            UserProfile userProfile = this.findUserProfileByUserName(userName);
            String currentVersionName = this.getCurrentTermsAndConditionsVersion();
            userProfile.setAttribute(TERMS_AND_CONDITONS_PROPERTY, currentVersionName);
            this.organizationService.getUserProfileHandler().saveUserProfile(userProfile, false);
        }
        catch (Exception e) {
            LOGGER.error((Object)"Cannot update user profile to store terms and conditions acceptation", (Throwable)e);
        }
        finally {
            RequestLifeCycle.end();
        }
    }

    public boolean isTermsAndConditionsActive() {
        boolean isValidFile;
        TermsAndConditions termsAndConditions = this.functionalConfigurationService.getTermsAndConditions();
        try {
            String currentVersion = this.getCurrentTermsAndConditionsVersion();
            isValidFile = Objects.nonNull(NodeUtils.findCollaborationFile(termsAndConditions.getWebContentUrl())) && StringUtils.isNotEmpty((String)currentVersion);
        }
        catch (Exception e) {
            return false;
        }
        return termsAndConditions.isActive() && isValidFile;
    }

    private UserProfile findUserProfileByUserName(String userName) throws Exception {
        User user = this.organizationService.getUserHandler().findUserByName(userName);
        if (Objects.isNull(user)) {
            throw new FunctionalConfigurationRuntimeException("User not found");
        }
        UserProfile userProfile = this.organizationService.getUserProfileHandler().findUserProfileByName(userName);
        if (userProfile == null) {
            userProfile = this.organizationService.getUserProfileHandler().createUserProfileInstance(userName);
        }
        return userProfile;
    }
}

