/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.highlight.spaces;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.highlight.spaces.HighlightSpace;
import org.exoplatform.highlight.spaces.HighlightSpacesComparator;
import org.exoplatform.rest.response.SpaceConfiguration;
import org.exoplatform.service.FunctionalConfigurationService;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;

public class HighlightSpacesService {
    public static final String SPACES_GROUP_LEGACY_ID = "0";
    private SpaceService spaceService;
    private FunctionalConfigurationService functionalConfigurationService;

    public HighlightSpacesService(SpaceService spaceService, FunctionalConfigurationService functionalConfigurationService) {
        this.functionalConfigurationService = functionalConfigurationService;
        this.spaceService = spaceService;
    }

    public List<HighlightSpace> getHighlightedSpacesForUser(String userId) {
        return this.getHighlightedSpacesForUser(SPACES_GROUP_LEGACY_ID, userId);
    }

    public List<HighlightSpace> getHighlightedSpacesForUser(String spacesGroupId, String userId) {
        List<SpaceConfiguration> spaceConfigurationsForGroup = this.functionalConfigurationService.getSpacesForGroup(spacesGroupId);
        ArrayList<HighlightSpace> highlightSpaces = new ArrayList<HighlightSpace>();
        for (SpaceConfiguration spaceConfiguration : spaceConfigurationsForGroup) {
            Space space = this.spaceService.getSpaceById(spaceConfiguration.getId());
            if (space == null || !this.spaceService.isMember(space, userId)) continue;
            HighlightSpace highlightSpace = new HighlightSpace();
            highlightSpace.setOrder(spaceConfiguration.getHighlightConfiguration().getOrder());
            highlightSpace.setId(space.getId());
            highlightSpace.setDisplayName(space.getDisplayName());
            highlightSpace.setAvatarUri(space.getAvatarUrl());
            highlightSpace.setUri(spaceConfiguration.getSpaceUri());
            highlightSpace.setGroupIdentifier(spaceConfiguration.getHighlightConfiguration().getGroupIdentifier());
            highlightSpaces.add(highlightSpace);
        }
        highlightSpaces.sort(new HighlightSpacesComparator());
        return highlightSpaces;
    }
}

