/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.termsconditions;

import java.util.Objects;
import javax.jcr.Node;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.rest.response.TermsAndConditions;
import org.exoplatform.service.FunctionalConfigurationService;
import org.exoplatform.service.exception.FunctionalConfigurationRuntimeException;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.utils.IdentityUtils;
import org.exoplatform.utils.NodeUtils;

public class TermsAndConditionsService {
    private static final String TERMS_AND_CONDITONS_PROPERTY = "acceptedTermsAndConditions";
    private static final Log LOGGER = ExoLogger.getLogger(TermsAndConditionsService.class);
    private final FunctionalConfigurationService functionalConfigurationService;
    private IdentityManager identityManager;
    private UserACL userACL;

    public TermsAndConditionsService(FunctionalConfigurationService functionalConfigurationService, IdentityManager identityManager, UserACL userACL) {
        this.functionalConfigurationService = functionalConfigurationService;
        this.identityManager = identityManager;
        this.userACL = userACL;
    }

    boolean isTermsAndConditionsAcceptedBy(String userName) {
        if (this.userACL.isSuperUser()) {
            return true;
        }
        Profile socialProfile = IdentityUtils.findUserProfileByUserName(userName);
        try {
            String acceptedTermsVersion = socialProfile.getProperty(TERMS_AND_CONDITONS_PROPERTY) + "";
            String currentVersion = this.getCurrentTermsAndConditionsVersion();
            return currentVersion.equals(acceptedTermsVersion);
        }
        catch (Exception e) {
            LOGGER.warn((Object)("Terms and conditions still not accepted by user: " + userName), (Throwable)e);
            return false;
        }
    }

    private String getCurrentTermsAndConditionsVersion() {
        String DEFAULT_DRAFT_VERSION_NAME = "jcr:rootVersion";
        TermsAndConditions termsAndConditions = this.functionalConfigurationService.getTermsAndConditions();
        Node termsAndConditionsNode = NodeUtils.findCollaborationFile(termsAndConditions.getWebContentUrl());
        try {
            String name = termsAndConditionsNode.getBaseVersion().getName();
            if ("jcr:rootVersion".equals(name)) {
                throw new FunctionalConfigurationRuntimeException("invalid.termsAndConditions");
            }
            return name;
        }
        catch (Exception e) {
            throw new FunctionalConfigurationRuntimeException("invalid.termsAndConditions");
        }
    }

    public void accept(String userName) {
        Profile userProfile = IdentityUtils.findUserProfileByUserName(userName);
        String currentVersionName = this.getCurrentTermsAndConditionsVersion();
        userProfile.setProperty(TERMS_AND_CONDITONS_PROPERTY, (Object)currentVersionName);
        try {
            this.identityManager.updateProfile(userProfile);
        }
        catch (Exception e) {
            LOGGER.error((Object)"Cannot update user profile to store terms and conditions acceptation", (Throwable)e);
        }
    }

    boolean isTermsAndConditionsActive() {
        boolean isValidFile;
        TermsAndConditions termsAndConditions = this.functionalConfigurationService.getTermsAndConditions();
        try {
            String currentVersion = this.getCurrentTermsAndConditionsVersion();
            isValidFile = Objects.nonNull(NodeUtils.findCollaborationFile(termsAndConditions.getWebContentUrl())) && StringUtils.isNotEmpty((String)currentVersion);
        }
        catch (Exception e) {
            return false;
        }
        return termsAndConditions.isActive() && isValidFile;
    }
}

