/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.gamification.github.listener;

import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.gamification.github.dao.GitHubAccountDAO;
import org.exoplatform.gamification.github.entity.GitHubAccountEntity;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.profile.ProfileLifeCycleEvent;
import org.exoplatform.social.core.profile.ProfileListenerPlugin;

public class GithubProfileListener
extends ProfileListenerPlugin {
    public static final String GITHUB_TYPE = "github";
    private static final Log LOG = ExoLogger.getLogger(GithubProfileListener.class);
    protected GitHubAccountDAO gitHubAccountDAO;

    public GithubProfileListener(GitHubAccountDAO gitHubAccountDAO) {
        this.gitHubAccountDAO = gitHubAccountDAO;
    }

    public void avatarUpdated(ProfileLifeCycleEvent event) {
    }

    public void bannerUpdated(ProfileLifeCycleEvent event) {
    }

    public void basicInfoUpdated(ProfileLifeCycleEvent event) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contactSectionUpdated(ProfileLifeCycleEvent event) {
        String gitHubId = this.getGithubUserId(event.getProfile());
        if (StringUtils.isNotBlank((CharSequence)gitHubId)) {
            RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
            try {
                GitHubAccountEntity entity = this.gitHubAccountDAO.getAccountByUserName(event.getUsername());
                if (entity == null || !entity.getGitHubId().equals(gitHubId)) {
                    GitHubAccountEntity existingEntity = this.gitHubAccountDAO.getAccountByGithubId(gitHubId);
                    if (existingEntity == null) {
                        if (entity == null) {
                            entity = new GitHubAccountEntity();
                            entity.setUserName(event.getUsername());
                            entity.setGitHubId(gitHubId);
                            this.gitHubAccountDAO.create(entity);
                        } else {
                            entity.setGitHubId(gitHubId);
                            this.gitHubAccountDAO.update(entity);
                        }
                    } else {
                        LOG.warn("The provided Github ID {} is already used by {}", new Object[]{gitHubId, existingEntity.getUserName()});
                    }
                }
            }
            catch (Exception e) {
                LOG.error((Object)"Could not retrieve and save Github account in user profile", (Throwable)e);
            }
            finally {
                RequestLifeCycle.end();
            }
        }
    }

    public void experienceSectionUpdated(ProfileLifeCycleEvent event) {
    }

    public void headerSectionUpdated(ProfileLifeCycleEvent event) {
    }

    public void createProfile(ProfileLifeCycleEvent event) {
    }

    public void aboutMeUpdated(ProfileLifeCycleEvent event) {
    }

    private String getGithubUserId(Profile profile) {
        List ims = (List)profile.getProperty("ims");
        for (HashMap map : ims) {
            if (!((String)map.get("key")).equals(GITHUB_TYPE)) continue;
            return (String)map.get("value");
        }
        return null;
    }
}

