/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.gamification.github.dao;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.NoResultException;
import javax.persistence.NonUniqueResultException;
import javax.persistence.TypedQuery;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.persistence.impl.GenericDAOJPAImpl;
import org.exoplatform.gamification.github.entity.GitHubAccountEntity;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class GitHubAccountDAO
extends GenericDAOJPAImpl<GitHubAccountEntity, Long> {
    private static final Log LOG = ExoLogger.getLogger(GitHubAccountDAO.class);

    public GitHubAccountEntity getAccountByGithubId(String gitHubId) {
        TypedQuery query = this.getEntityManager().createNamedQuery("GitHubAccountEntity.getAccountByGithubId", GitHubAccountEntity.class).setParameter("gitHubId", (Object)gitHubId);
        try {
            return (GitHubAccountEntity)query.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
        catch (NonUniqueResultException e) {
            Set usernames;
            List list = query.getResultList();
            GitHubAccountEntity gitHubAccountEntity = list.stream().filter(Objects::nonNull).findFirst().orElse(null);
            if (gitHubAccountEntity != null && (usernames = list.stream().map(GitHubAccountEntity::getUserName).collect(Collectors.toSet())).size() > 1) {
                LOG.warn("Not only one single user found for github account {}. Associated usernames: {}. Try to retrieve only first one for user {}", new Object[]{gitHubId, StringUtils.join(usernames, (String)","), gitHubAccountEntity.getUserName(), e});
            }
            return gitHubAccountEntity;
        }
    }

    public GitHubAccountEntity getAccountByUserName(String userName) {
        TypedQuery query = this.getEntityManager().createNamedQuery("GitHubAccountEntity.getAccountByUserName", GitHubAccountEntity.class).setParameter("userName", (Object)userName);
        try {
            return (GitHubAccountEntity)query.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
        catch (NonUniqueResultException e) {
            Set githubIds;
            List list = query.getResultList();
            GitHubAccountEntity gitHubAccountEntity = list.stream().filter(Objects::nonNull).findFirst().orElse(null);
            if (gitHubAccountEntity != null && (githubIds = list.stream().map(GitHubAccountEntity::getGitHubId).collect(Collectors.toSet())).size() > 1) {
                LOG.warn("Not only one single github account found for user {}. Associated accounts: {}. Try to retrieve only first one for githubId {}", new Object[]{userName, StringUtils.join(githubIds, (String)","), gitHubAccountEntity.getGitHubId(), e});
            }
            return gitHubAccountEntity;
        }
    }
}

