/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.gamification.github.plugin;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.gamification.github.model.Event;
import org.exoplatform.gamification.github.plugin.GithubTriggerPlugin;
import org.exoplatform.gamification.github.utils.Utils;

public class CommentTriggerPlugin
extends GithubTriggerPlugin {
    @Override
    public List<Event> getEvents(Map<String, Object> payload) {
        String eventType;
        String pullRequest = Utils.extractSubItem(payload, "issue", "pull_request");
        String action = Utils.extractSubItem(payload, "action");
        String comment = Utils.extractSubItem(payload, "comment", "html_url");
        String userId = Utils.extractSubItem(payload, "sender", "login");
        String string = eventType = StringUtils.isBlank((CharSequence)pullRequest) ? "githubCommentIssue" : "githubCommentPR";
        if (action != null) {
            String eventName;
            switch (action) {
                case "created": {
                    eventName = StringUtils.isBlank((CharSequence)pullRequest) ? "commentIssue" : "commentPullRequest";
                    break;
                }
                case "deleted": {
                    eventName = StringUtils.isBlank((CharSequence)pullRequest) ? "deleteIssueComment" : "deletePullRequestComment";
                    break;
                }
                default: {
                    return Collections.emptyList();
                }
            }
            return Collections.singletonList(new Event(eventName, null, userId, comment, eventType));
        }
        return Collections.emptyList();
    }
}

