/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.gamification.github.rest;

import javax.ws.rs.Consumes;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import org.exoplatform.gamification.github.services.GithubTriggerService;
import org.exoplatform.services.rest.resource.ResourceContainer;

@Path(value="/gamification/connectors/github/")
public class GithubWebHookRest
implements ResourceContainer {
    private final GithubTriggerService githubTriggerService;

    public GithubWebHookRest(GithubTriggerService githubTriggerService) {
        this.githubTriggerService = githubTriggerService;
    }

    @POST
    @Consumes(value={"application/json"})
    @Path(value="webhooks")
    public Response githubEvent(@HeaderParam(value="x-github-event") String event, @HeaderParam(value="x-hub-signature") String signature, String payload) {
        try {
            this.githubTriggerService.handleTriggerAsync(event, signature, payload);
            return Response.ok().build();
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage()).build();
        }
    }
}

