/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.gamification.listener.social.activity;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.exoplatform.addons.gamification.entities.domain.effective.GamificationContextEntity;
import org.exoplatform.addons.gamification.entities.domain.effective.GamificationContextItemEntity;
import org.exoplatform.addons.gamification.listener.GamificationListener;
import org.exoplatform.addons.gamification.service.configuration.RuleService;
import org.exoplatform.addons.gamification.service.dto.configuration.RuleDTO;
import org.exoplatform.addons.gamification.service.dto.effective.GamificationContextHolder;
import org.exoplatform.addons.gamification.service.effective.GamificationProcessor;
import org.exoplatform.addons.gamification.service.effective.GamificationService;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.activity.ActivityLifeCycleEvent;
import org.exoplatform.social.core.activity.ActivityListenerPlugin;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.spi.SpaceService;

public class GamificationActivityListener
extends ActivityListenerPlugin
implements GamificationListener {
    private static final Log LOG = ExoLogger.getLogger(GamificationActivityListener.class);
    protected RuleService ruleService = (RuleService)CommonsUtils.getService(RuleService.class);
    protected GamificationProcessor gamificationProcessor = (GamificationProcessor)CommonsUtils.getService(GamificationProcessor.class);
    protected IdentityManager identityManager = (IdentityManager)CommonsUtils.getService(IdentityManager.class);
    protected SpaceService spaceService = (SpaceService)CommonsUtils.getService(SpaceService.class);
    protected GamificationService gamificationService = (GamificationService)CommonsUtils.getService(GamificationService.class);
    protected ActivityManager activityManager = (ActivityManager)CommonsUtils.getService(ActivityManager.class);

    public void saveActivity(ActivityLifeCycleEvent event) {
        ExoSocialActivity activity = (ExoSocialActivity)event.getSource();
        if (!activity.getType().equalsIgnoreCase("DEFAULT_ACTIVITY")) {
            return;
        }
        List<GamificationContextHolder> gamificationContextEntityList = null;
        RuleDTO ruleDto = null;
        if (this.isSpaceActivity(activity)) {
            ruleDto = this.ruleService.findEnableRuleByTitle("addActivityOnSpaceStream");
            if (ruleDto != null) {
                try {
                    gamificationContextEntityList = this.gamify(ruleDto, activity.getPosterId());
                }
                catch (Exception e) {
                    LOG.error("Error to process gamification for Rule {}", new Object[]{ruleDto.getTitle(), e});
                }
            }
            if ((ruleDto = this.ruleService.findEnableRuleByTitle("addActivityOnSpaceStreamTarget")) != null) {
                try {
                    gamificationContextEntityList.addAll(this.gamify(ruleDto, activity.getPosterId()));
                }
                catch (Exception e) {
                    LOG.error("Error to process gamification for Rule {}", new Object[]{ruleDto.getTitle(), e});
                }
            }
        } else if (activity.getPosterId().equalsIgnoreCase(activity.getStreamId())) {
            ruleDto = this.ruleService.findEnableRuleByTitle("addActivityOnMyStream");
            if (ruleDto != null) {
                try {
                    gamificationContextEntityList = this.gamify(ruleDto, activity.getStreamId());
                }
                catch (Exception e) {
                    LOG.error("Error to process gamification for Rule {}", new Object[]{ruleDto.getTitle(), e});
                }
            }
        } else {
            ruleDto = this.ruleService.findEnableRuleByTitle("addActivityOnNetworkStream");
            if (ruleDto != null) {
                try {
                    gamificationContextEntityList = this.gamify(ruleDto, activity.getPosterId());
                }
                catch (Exception e) {
                    LOG.error("Error to process gamification for Rule {}", new Object[]{ruleDto.getTitle(), e});
                }
            }
            if ((ruleDto = this.ruleService.findEnableRuleByTitle("addActivityTargetUserStream")) != null) {
                try {
                    gamificationContextEntityList.addAll(this.gamify(ruleDto, activity.getStreamId()));
                }
                catch (Exception e) {
                    LOG.error("Error to process gamification for Rule {}", new Object[]{ruleDto.getTitle(), e});
                }
            }
        }
        this.gamificationProcessor.process(gamificationContextEntityList);
    }

    public void updateActivity(ActivityLifeCycleEvent event) {
    }

    public void saveComment(ActivityLifeCycleEvent event) {
        ExoSocialActivity activity = (ExoSocialActivity)event.getSource();
        List<GamificationContextHolder> gamificationContextEntityList = null;
        RuleDTO ruleDto = null;
        ExoSocialActivity parent = this.activityManager.getParentActivity(activity);
        if (!parent.getType().equalsIgnoreCase("DEFAULT_ACTIVITY")) {
            return;
        }
        if (parent != null && this.isSpaceActivity(parent)) {
            ruleDto = this.ruleService.findEnableRuleByTitle("commentOnSpaceStream");
            if (ruleDto != null) {
                try {
                    gamificationContextEntityList = this.gamify(ruleDto, activity.getPosterId());
                }
                catch (Exception e) {
                    LOG.error("Error to process gamification for Rule {}", new Object[]{ruleDto.getTitle(), e});
                }
            }
        } else if (!activity.getPosterId().equalsIgnoreCase(activity.getStreamId()) && (ruleDto = this.ruleService.findEnableRuleByTitle("commentOnNetworkStream")) != null) {
            try {
                gamificationContextEntityList = this.gamify(ruleDto, activity.getPosterId());
            }
            catch (Exception e) {
                LOG.error("Error to process gamification for Rule {}", new Object[]{ruleDto.getTitle(), e});
            }
        }
        this.gamificationProcessor.process(gamificationContextEntityList);
    }

    public void likeActivity(ActivityLifeCycleEvent event) {
        ExoSocialActivity activity = (ExoSocialActivity)event.getSource();
        if (!activity.getType().equalsIgnoreCase("DEFAULT_ACTIVITY")) {
            return;
        }
        List<GamificationContextHolder> gamificationContextEntityList = null;
        RuleDTO ruleDto = null;
        if (this.isSpaceActivity(activity)) {
            ruleDto = this.ruleService.findEnableRuleByTitle("likeActivityOnSpaceStream");
            if (ruleDto != null) {
                try {
                    String[] likersId = activity.getLikeIdentityIds();
                    String liker = this.identityManager.getIdentity(likersId[likersId.length - 1], false).getId();
                    gamificationContextEntityList = this.gamify(ruleDto, liker);
                }
                catch (Exception e) {
                    LOG.error("Error to process gamification for Rule {}", new Object[]{ruleDto.getTitle(), e});
                }
            }
            if ((ruleDto = this.ruleService.findEnableRuleByTitle("likeActivityOnSpaceStreamTarget")) != null) {
                try {
                    gamificationContextEntityList.addAll(this.gamify(ruleDto, activity.getPosterId()));
                }
                catch (Exception e) {
                    LOG.error("Error to process gamification for Rule {}", new Object[]{ruleDto.getTitle(), e});
                }
            }
        } else {
            String[] likersId = activity.getLikeIdentityIds();
            String liker = this.identityManager.getIdentity(likersId[likersId.length - 1], false).getId();
            if (!activity.getPosterId().equalsIgnoreCase(liker)) {
                ruleDto = this.ruleService.findEnableRuleByTitle("likeActivityOnNetworkStream");
                if (ruleDto != null) {
                    try {
                        gamificationContextEntityList = this.gamify(ruleDto, liker);
                    }
                    catch (Exception e) {
                        LOG.error("Error to process gamification for Rule {}", new Object[]{ruleDto.getTitle(), e});
                    }
                }
                if ((ruleDto = this.ruleService.findEnableRuleByTitle("likeActivityTargetUserStream")) != null) {
                    try {
                        gamificationContextEntityList.addAll(this.gamify(ruleDto, activity.getPosterId()));
                    }
                    catch (Exception e) {
                        LOG.error("Error to process gamification for Rule {}", new Object[]{ruleDto.getTitle(), e});
                    }
                }
            }
        }
        this.gamificationProcessor.process(gamificationContextEntityList);
    }

    public void likeComment(ActivityLifeCycleEvent event) {
        ExoSocialActivity activity = (ExoSocialActivity)event.getSource();
        List<GamificationContextHolder> gamificationContextEntityList = null;
        RuleDTO ruleDto = null;
        if (this.isSpaceActivity(activity)) {
            ruleDto = this.ruleService.findEnableRuleByTitle("likeCommentOnspaceStream");
            if (ruleDto != null) {
                try {
                    gamificationContextEntityList = this.gamify(ruleDto, activity.getPosterId());
                }
                catch (Exception e) {
                    LOG.error("Error to process gamification for Rule {}", new Object[]{ruleDto.getTitle(), e});
                }
            }
        } else if (!activity.getPosterId().equalsIgnoreCase(activity.getStreamId()) && (ruleDto = this.ruleService.findEnableRuleByTitle("likeCommentOnNetworkStream")) != null) {
            try {
                gamificationContextEntityList = this.gamify(ruleDto, activity.getPosterId());
            }
            catch (Exception e) {
                LOG.error("Error to process gamification for Rule {}", new Object[]{ruleDto.getTitle(), e});
            }
        }
        if ((ruleDto = this.ruleService.findEnableRuleByTitle("likeComment")) != null) {
            String[] likersId = activity.getLikeIdentityIds();
            String liker = this.identityManager.getIdentity(likersId[likersId.length - 1], false).getId();
            try {
                gamificationContextEntityList.addAll(this.gamify(ruleDto, activity.getPosterId()));
            }
            catch (Exception e) {
                LOG.error("Error to process gamification for Rule {}", new Object[]{ruleDto.getTitle(), e});
            }
        }
        this.gamificationProcessor.process(gamificationContextEntityList);
    }

    @Override
    public List<GamificationContextHolder> gamify(RuleDTO ruleDto, String actor) throws Exception {
        ArrayList<GamificationContextHolder> gamificationContextEntityList = new ArrayList<GamificationContextHolder>();
        GamificationContextHolder contextHolder = null;
        GamificationContextEntity gamificationContextEntity = null;
        if (ruleDto != null) {
            gamificationContextEntity = this.gamificationService.findGamificationContextByUsername(actor);
            contextHolder = new GamificationContextHolder();
            if (gamificationContextEntity != null) {
                String title = ruleDto.getTitle();
                Set<GamificationContextItemEntity> gamificationContextItemEntitySet = gamificationContextEntity.getGamificationItems().stream().filter(item -> item.getOpType().equalsIgnoreCase(title)).collect(Collectors.toSet());
                if (gamificationContextItemEntitySet != null && !gamificationContextItemEntitySet.isEmpty()) {
                    gamificationContextItemEntitySet.forEach(item -> {
                        item.setOccurrence(item.getOccurrence() + 1);
                        item.setScore(item.getScore() + ruleDto.getScore());
                    });
                    gamificationContextEntity.setScore(gamificationContextEntity.getScore() + (long)ruleDto.getScore());
                } else {
                    GamificationContextItemEntity gamificationContextItemEntity = new GamificationContextItemEntity();
                    gamificationContextItemEntity.setOpType(title);
                    gamificationContextItemEntity.setZone(ruleDto.getArea());
                    gamificationContextItemEntity.setOccurrence(1);
                    gamificationContextItemEntity.setScore(ruleDto.getScore());
                    gamificationContextEntity.setScore(gamificationContextEntity.getScore() + (long)ruleDto.getScore());
                    gamificationContextEntity.addGamificationItem(gamificationContextItemEntity);
                }
            } else {
                gamificationContextEntity = new GamificationContextEntity();
                gamificationContextEntity.setUsername(actor);
                gamificationContextEntity.setScore(ruleDto.getScore());
                GamificationContextItemEntity gamificationContextItemEntity = new GamificationContextItemEntity();
                gamificationContextItemEntity.setOccurrence(1);
                gamificationContextItemEntity.setScore(gamificationContextItemEntity.getScore() + ruleDto.getScore());
                gamificationContextItemEntity.setOpType(ruleDto.getTitle());
                gamificationContextItemEntity.setZone(ruleDto.getArea());
                gamificationContextItemEntity.setScore(ruleDto.getScore());
                gamificationContextItemEntity.setGamificationUserEntity(gamificationContextEntity);
                gamificationContextEntity.getGamificationItems().add(gamificationContextItemEntity);
                contextHolder.setNew(true);
            }
            contextHolder.setGamificationContextEntity(gamificationContextEntity);
            gamificationContextEntityList.add(contextHolder);
        }
        return gamificationContextEntityList;
    }

    public boolean isSpaceActivity(ExoSocialActivity activity) {
        Identity id = this.identityManager.getOrCreateIdentity("space", activity.getStreamOwner(), false);
        return id != null;
    }
}

