/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.gamification.listener.social.profile;

import java.time.LocalDate;
import org.exoplatform.addons.gamification.entities.domain.effective.GamificationActionsHistory;
import org.exoplatform.addons.gamification.listener.GamificationListener;
import org.exoplatform.addons.gamification.service.configuration.RuleService;
import org.exoplatform.addons.gamification.service.dto.configuration.RuleDTO;
import org.exoplatform.addons.gamification.service.effective.GamificationProcessor;
import org.exoplatform.addons.gamification.service.effective.GamificationService;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.listener.Asynchronous;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.profile.ProfileLifeCycleEvent;
import org.exoplatform.social.core.profile.ProfileListenerPlugin;
import org.exoplatform.social.core.space.spi.SpaceService;

@Asynchronous
public class GamificationProfileListener
extends ProfileListenerPlugin
implements GamificationListener {
    private static final Log LOG = ExoLogger.getLogger(GamificationProfileListener.class);
    protected RuleService ruleService = (RuleService)CommonsUtils.getService(RuleService.class);
    protected GamificationProcessor gamificationProcessor = (GamificationProcessor)CommonsUtils.getService(GamificationProcessor.class);
    protected IdentityManager identityManager = (IdentityManager)CommonsUtils.getService(IdentityManager.class);
    protected SpaceService spaceService = (SpaceService)CommonsUtils.getService(SpaceService.class);
    protected GamificationService gamificationService = (GamificationService)CommonsUtils.getService(GamificationService.class);

    public void avatarUpdated(ProfileLifeCycleEvent event) {
        GamificationActionsHistory aHisoty = null;
        Long lastUpdate = event.getProfile().getAvatarLastUpdated();
        if (lastUpdate != null) {
            return;
        }
        RuleDTO ruleDto = null;
        ruleDto = this.ruleService.findEnableRuleByTitle("addUserProfileAvatar");
        if (ruleDto != null) {
            try {
                aHisoty = this.build(ruleDto, event.getProfile().getId());
                this.gamificationProcessor.execute(aHisoty);
            }
            catch (Exception e) {
                LOG.error("Error to process gamification for Rule {}", new Object[]{ruleDto.getTitle(), e});
            }
        }
    }

    public void bannerUpdated(ProfileLifeCycleEvent event) {
        GamificationActionsHistory aHistory = null;
        Long lastUpdate = event.getProfile().getBannerLastUpdated();
        if (lastUpdate != null) {
            return;
        }
        RuleDTO ruleDto = null;
        ruleDto = this.ruleService.findEnableRuleByTitle("addUserProfileBanner");
        if (ruleDto != null) {
            try {
                aHistory = this.build(ruleDto, event.getProfile().getId());
                this.gamificationProcessor.execute(aHistory);
                LOG.info("service=gamification operation=add-new-entry parameters=\"date:{},user_social_id:{},global_score:{},domain:{},action_title:{},action_score:{}\"", new Object[]{LocalDate.now(), aHistory.getUserSocialId(), aHistory.getGlobalScore(), ruleDto.getArea(), ruleDto.getTitle(), ruleDto.getScore()});
            }
            catch (Exception e) {
                LOG.error("Error to process gamification for Rule {}", new Object[]{ruleDto.getTitle(), e});
            }
        }
    }

    public void basicInfoUpdated(ProfileLifeCycleEvent event) {
    }

    public void contactSectionUpdated(ProfileLifeCycleEvent event) {
    }

    public void experienceSectionUpdated(ProfileLifeCycleEvent event) {
    }

    public void headerSectionUpdated(ProfileLifeCycleEvent event) {
    }

    public void createProfile(ProfileLifeCycleEvent event) {
    }

    public void aboutMeUpdated(ProfileLifeCycleEvent event) {
        GamificationActionsHistory aHistory = null;
        RuleDTO ruleDto = null;
        ruleDto = this.ruleService.findEnableRuleByTitle("addUserProfileAboutMe");
        if (ruleDto != null) {
            try {
                aHistory = this.build(ruleDto, event.getProfile().getId());
                this.gamificationProcessor.execute(aHistory);
                LOG.info("service=gamification operation=add-new-entry parameters=\"date:{},user_social_id:{},global_score:{},domain:{},action_title:{},action_score:{}\"", new Object[]{LocalDate.now(), aHistory.getUserSocialId(), aHistory.getGlobalScore(), ruleDto.getArea(), ruleDto.getTitle(), ruleDto.getScore()});
            }
            catch (Exception e) {
                LOG.error("Error to process gamification for Rule {}", new Object[]{ruleDto.getTitle(), e});
            }
        }
    }
}

