/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.gamification.rest;

import java.text.ParseException;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.TemporalAdjusters;
import java.util.Date;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.exoplatform.addons.gamification.service.effective.GamificationService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;

@Path(value="/gamification/api/v1")
@RolesAllowed(value={"users"})
public class GamificationRestEndpoint
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(GamificationRestEndpoint.class);
    private final CacheControl cacheControl = new CacheControl();
    private GamificationService gamificationService;
    private IdentityManager identityManager;

    public GamificationRestEndpoint(GamificationService gamificationService, IdentityManager identityManager) {
        this.cacheControl.setNoCache(true);
        this.cacheControl.setNoStore(true);
        this.gamificationService = gamificationService;
        this.identityManager = identityManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Path(value="points")
    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    public Response getAllPointsByUserId(@QueryParam(value="userId") String userId) {
        if (StringUtils.isBlank((String)userId)) {
            LOG.warn((Object)"Enable to serve request due to bad request parameter \u00abuserId\u00bb");
            return Response.ok((Object)new GamificationPoints().build(userId, 0L, "2", "userId parameter must be specified")).build();
        }
        try {
            Identity identity = this.identityManager.getOrCreateIdentity("organization", userId, false);
            Long earnedXP = this.gamificationService.findUserReputationBySocialId(identity.getId());
            Response response = Response.ok((Object)new GamificationPoints().build(userId, earnedXP, "0", "Gamification API is called successfully")).build();
            return response;
        }
        catch (Exception e) {
            LOG.error("Error while fetching earned points for user {} - Gamification public API", new Object[]{userId, e});
            Response response = Response.ok((Object)new GamificationPoints().build(userId, 0L, "2", "Error while fetching all earned points")).build();
            return response;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Path(value="points/date")
    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    public Response getAllPointsByUserIdByDate(@QueryParam(value="userId") String userId, @QueryParam(value="startDate") String startDateEntry, @QueryParam(value="endDate") String endDateEntry) {
        if (StringUtils.isBlank((String)userId)) {
            LOG.warn((Object)"Enable to serve request due to bad request parameter \u00abuserId\u00bb");
            return Response.ok((Object)new GamificationPoints().build(userId, 0L, "2", "userId parameter must be specified")).build();
        }
        try {
            Date startDate = DateUtils.parseDate((String)startDateEntry, (String[])new String[]{"yyyy-MM-dd HH:mm:ss", "dd-MM-yyyy"});
            Date endDate = DateUtils.parseDate((String)endDateEntry, (String[])new String[]{"yyyy-MM-dd HH:mm:ss", "dd-MM-yyyy"});
            if (startDate.after(endDate)) {
                return Response.ok((Object)new GamificationPoints().build(userId, 0L, "1", "date parameters are not correctly set")).build();
            }
            Identity identity = this.identityManager.getOrCreateIdentity("organization", userId, false);
            Long earnedXP = this.gamificationService.findUserReputationScoreBetweenDate(identity.getId(), startDate, endDate);
            return Response.ok((Object)new GamificationPoints().build(userId, earnedXP, "0", "Gamification API is called successfully")).build();
        }
        catch (ParseException pe) {
            LOG.error("Error to parse parameters {} or {} ", new Object[]{startDateEntry, endDateEntry});
            return Response.serverError().cacheControl(this.cacheControl).entity((Object)"Error to parse startDate or endDate to Date object please use the following pattern : dd-MM-yyyy").build();
        }
        catch (Exception e) {
            LOG.error("Error while fetching earned points for user {} in the specified period - Gamification public API", new Object[]{userId, e});
            return Response.ok((Object)new GamificationPoints().build(userId, 0L, "2", "Error while fetching earned points by period")).build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Path(value="points/month")
    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    public Response getAllPointsByUserIdAndCurrentMonth(@QueryParam(value="userId") String userId) {
        if (StringUtils.isBlank((String)userId)) {
            LOG.warn((Object)"Enable to serve request due to bad request parameter \u00abuserId\u00bb");
            return Response.ok((Object)new GamificationPoints().build(userId, 0L, "2", "userId parameter must be specified")).build();
        }
        try {
            Identity identity = this.identityManager.getOrCreateIdentity("organization", userId, false);
            Long earnedXP = this.gamificationService.findUserReputationScoreByMonth(identity.getId(), Date.from(LocalDate.now().with(TemporalAdjusters.firstDayOfMonth()).atStartOfDay(ZoneId.systemDefault()).toInstant()));
            Response response = Response.ok((Object)new GamificationPoints().build(userId, earnedXP, "0", "Gamification API is called successfully")).build();
            return response;
        }
        catch (Exception e) {
            LOG.error("Error while fetching earned points for user {} in current month- Gamification public API", new Object[]{userId, e});
            Response response = Response.ok((Object)new GamificationPoints().build(userId, 0L, "2", "Error while fetching earned points during the current month")).build();
            return response;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Path(value="points/week")
    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    public Response getAllPointsByUserIdAndCurrentWeek(@QueryParam(value="userId") String userId) {
        if (StringUtils.isBlank((String)userId)) {
            LOG.warn((Object)"Enable to serve request due to bad request parameter \u00abuserId\u00bb");
            return Response.ok((Object)new GamificationPoints().build(userId, 0L, "2", "userId parameter must be specified")).build();
        }
        try {
            Identity identity = this.identityManager.getOrCreateIdentity("organization", userId, false);
            Long earnedXP = this.gamificationService.findUserReputationScoreByMonth(identity.getId(), Date.from(LocalDate.now().with(DayOfWeek.MONDAY).atStartOfDay(ZoneId.systemDefault()).toInstant()));
            Response response = Response.ok((Object)new GamificationPoints().build(userId, earnedXP, "0", "Gamification API is called successfully")).build();
            return response;
        }
        catch (Exception e) {
            LOG.error("Error while fetching earned points for user {} in current week- Gamification public API", new Object[]{userId, e});
            Response response = Response.ok((Object)new GamificationPoints().build(userId, 0L, "2", "Error while fetching earned points during the current week")).build();
            return response;
        }
    }

    public static class GamificationPoints {
        private String userId;
        private Long points;
        private String code;
        private String message;

        public GamificationPoints() {
        }

        public GamificationPoints(String userId, Long points, String code, String message) {
            this.userId = userId;
            this.points = points;
            this.code = code;
            this.message = message;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getUserId() {
            return this.userId;
        }

        public GamificationPoints build(String userId, Long points, String code, String message) {
            return new GamificationPoints(userId, points, code, message);
        }

        public void setUserId(String userId) {
            this.userId = userId;
        }

        public Long getPoints() {
            return this.points;
        }

        public void setPoints(Long points) {
            this.points = points;
        }
    }
}

