/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.gamification.service.effective;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.TemporalAdjusters;
import java.util.Date;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.addons.gamification.entities.domain.effective.GamificationActionsHistory;
import org.exoplatform.addons.gamification.service.effective.GamificationService$AjcClosure1;
import org.exoplatform.addons.gamification.service.effective.GamificationService$AjcClosure11;
import org.exoplatform.addons.gamification.service.effective.GamificationService$AjcClosure13;
import org.exoplatform.addons.gamification.service.effective.GamificationService$AjcClosure15;
import org.exoplatform.addons.gamification.service.effective.GamificationService$AjcClosure17;
import org.exoplatform.addons.gamification.service.effective.GamificationService$AjcClosure19;
import org.exoplatform.addons.gamification.service.effective.GamificationService$AjcClosure21;
import org.exoplatform.addons.gamification.service.effective.GamificationService$AjcClosure3;
import org.exoplatform.addons.gamification.service.effective.GamificationService$AjcClosure5;
import org.exoplatform.addons.gamification.service.effective.GamificationService$AjcClosure7;
import org.exoplatform.addons.gamification.service.effective.GamificationService$AjcClosure9;
import org.exoplatform.addons.gamification.service.effective.LeaderboardFilter;
import org.exoplatform.addons.gamification.service.effective.PiechartLeaderboard;
import org.exoplatform.addons.gamification.service.effective.ProfileReputation;
import org.exoplatform.addons.gamification.service.effective.StandardLeaderboard;
import org.exoplatform.addons.gamification.storage.dao.GamificationDAO;
import org.exoplatform.addons.gamification.storage.dao.GamificationHistoryDAO;
import org.exoplatform.addons.gamification.storage.dao.GamificationItemDAO;
import org.exoplatform.commons.api.persistence.ExoTransactional;
import org.exoplatform.commons.persistence.impl.ExoTransactionalAspect;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class GamificationService {
    private static final Log LOG;
    protected final GamificationDAO gamificationDAO;
    protected final GamificationItemDAO gamificationItemDAO;
    protected final GamificationHistoryDAO gamificationHistoryDAO;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;

    public GamificationService(GamificationDAO gamificationDAO, GamificationItemDAO gamificationItemDAO, GamificationHistoryDAO gamificationHistoryDAO) {
        this.gamificationDAO = gamificationDAO;
        this.gamificationItemDAO = gamificationItemDAO;
        this.gamificationHistoryDAO = gamificationHistoryDAO;
    }

    @ExoTransactional
    public GamificationActionsHistory findLatestActionHistoryBySocialId(String userSocialId) {
        String string = userSocialId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        return (GamificationActionsHistory)ExoTransactionalAspect.aspectOf().around(new GamificationService$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
    }

    @ExoTransactional
    public List<GamificationActionsHistory> findActionHistoryByDateBySocialId(Date date, String socialId) {
        Date date2 = date;
        String string = socialId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)date2, (Object)string);
        Object[] objectArray = new Object[]{this, date2, string, joinPoint};
        return (List)ExoTransactionalAspect.aspectOf().around(new GamificationService$AjcClosure3(objectArray).linkClosureAndJoinPoint(69648));
    }

    public int bluidCurrentUserRank(String socialId, Date date, String domain) {
        List<StandardLeaderboard> leaderboard = null;
        int rank = 0;
        try {
            leaderboard = date != null ? (domain.equalsIgnoreCase("all") ? this.gamificationHistoryDAO.findAllActionsHistoryByDate(date) : this.gamificationHistoryDAO.findAllActionsHistoryByDateByDomain(date, domain)) : (domain.equalsIgnoreCase("all") ? this.gamificationHistoryDAO.findAllActionsHistoryAgnostic() : this.gamificationHistoryDAO.findAllActionsHistoryByDomain(domain));
            StandardLeaderboard item = leaderboard.stream().filter(g -> socialId.equals(g.getUserSocialId())).findAny().orElse(null);
            return leaderboard.indexOf(item) + 1;
        }
        catch (Exception exception) {
            return rank;
        }
    }

    @ExoTransactional
    public long findUserReputationBySocialId(String socialId) {
        String string = socialId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        return Conversions.longValue((Object)ExoTransactionalAspect.aspectOf().around(new GamificationService$AjcClosure5(objectArray).linkClosureAndJoinPoint(69648)));
    }

    @ExoTransactional
    public List<ProfileReputation> buildDomainScoreByUserId(String socialId) {
        String string = socialId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        return (List)ExoTransactionalAspect.aspectOf().around(new GamificationService$AjcClosure7(objectArray).linkClosureAndJoinPoint(69648));
    }

    @ExoTransactional
    public void saveActionHistory(GamificationActionsHistory aHistory) {
        GamificationActionsHistory gamificationActionsHistory = aHistory;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)gamificationActionsHistory);
        Object[] objectArray = new Object[]{this, gamificationActionsHistory, joinPoint};
        ExoTransactionalAspect.aspectOf().around(new GamificationService$AjcClosure9(objectArray).linkClosureAndJoinPoint(69648));
    }

    @ExoTransactional
    public List<StandardLeaderboard> filter(LeaderboardFilter filter, boolean isGlobalContext) {
        LeaderboardFilter leaderboardFilter = filter;
        boolean bl = isGlobalContext;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)leaderboardFilter, (Object)Conversions.booleanObject((boolean)bl));
        Object[] objectArray = new Object[]{this, leaderboardFilter, Conversions.booleanObject((boolean)bl), joinPoint};
        return (List)ExoTransactionalAspect.aspectOf().around(new GamificationService$AjcClosure11(objectArray).linkClosureAndJoinPoint(69648));
    }

    @ExoTransactional
    public List<PiechartLeaderboard> buildStatsByUser(String userSocialId) {
        String string = userSocialId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        return (List)ExoTransactionalAspect.aspectOf().around(new GamificationService$AjcClosure13(objectArray).linkClosureAndJoinPoint(69648));
    }

    @ExoTransactional
    public long findUserReputationScoreBetweenDate(String userSocialId, Date fromDate, Date toDate) {
        String string = userSocialId;
        Date date = fromDate;
        Date date2 = toDate;
        Object[] objectArray = new Object[]{string, date, date2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, string, date, date2, joinPoint};
        return Conversions.longValue((Object)ExoTransactionalAspect.aspectOf().around(new GamificationService$AjcClosure15(objectArray2).linkClosureAndJoinPoint(69648)));
    }

    @ExoTransactional
    public long findUserReputationScoreByMonth(String userSocialId, Date currentMonth) {
        String string = userSocialId;
        Date date = currentMonth;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object)string, (Object)date);
        Object[] objectArray = new Object[]{this, string, date, joinPoint};
        return Conversions.longValue((Object)ExoTransactionalAspect.aspectOf().around(new GamificationService$AjcClosure17(objectArray).linkClosureAndJoinPoint(69648)));
    }

    @ExoTransactional
    public long findUserReputationScoreByDomainBetweenDate(String userSocialId, String domain, Date fromDate, Date toDate) {
        String string = userSocialId;
        String string2 = domain;
        Date date = fromDate;
        Date date2 = toDate;
        Object[] objectArray = new Object[]{string, string2, date, date2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, string, string2, date, date2, joinPoint};
        return Conversions.longValue((Object)ExoTransactionalAspect.aspectOf().around(new GamificationService$AjcClosure19(objectArray2).linkClosureAndJoinPoint(69648)));
    }

    @ExoTransactional
    public List<StandardLeaderboard> findAllLeaderboardBetweenDate(Date fromDate, Date toDate) {
        Date date = fromDate;
        Date date2 = toDate;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this, (Object)date, (Object)date2);
        Object[] objectArray = new Object[]{this, date, date2, joinPoint};
        return (List)ExoTransactionalAspect.aspectOf().around(new GamificationService$AjcClosure21(objectArray).linkClosureAndJoinPoint(69648));
    }

    static {
        GamificationService.ajc$preClinit();
        LOG = ExoLogger.getLogger(GamificationService.class);
    }

    static /* synthetic */ GamificationActionsHistory findLatestActionHistoryBySocialId_aroundBody0(GamificationService ajc$this, String userSocialId, JoinPoint joinPoint) {
        List<GamificationActionsHistory> entities = null;
        try {
            entities = ajc$this.gamificationHistoryDAO.findActionsHistoryByUserId(userSocialId);
            return entities != null && !entities.isEmpty() ? entities.get(0) : null;
        }
        catch (Exception e) {
            LOG.error("Error to find ActionsHistory entity with the following cretiria [userSocialId:{}]", new Object[]{userSocialId, e});
            return null;
        }
    }

    static /* synthetic */ List findActionHistoryByDateBySocialId_aroundBody2(GamificationService ajc$this, Date date, String socialId, JoinPoint joinPoint) {
        List<GamificationActionsHistory> entities = null;
        try {
            entities = ajc$this.gamificationHistoryDAO.findActionHistoryByDateBySocialId(date, socialId);
        }
        catch (Exception e) {
            LOG.error("Error to find ActionsHistory entities with the following cretiria [socialId:{} / date:{}", new Object[]{socialId, date, e});
        }
        return entities;
    }

    static /* synthetic */ long findUserReputationBySocialId_aroundBody4(GamificationService ajc$this, String socialId, JoinPoint joinPoint) {
        GamificationActionsHistory aHistory = null;
        try {
            aHistory = ajc$this.findLatestActionHistoryBySocialId(socialId);
            return aHistory != null ? aHistory.getGlobalScore() : 0L;
        }
        catch (Exception e) {
            LOG.error("Error to find ActionsHistory entity with the following cretiria [socialId:{} / date:{}", new Object[]{socialId, LocalDate.now(), e});
            return 0L;
        }
    }

    static /* synthetic */ List buildDomainScoreByUserId_aroundBody6(GamificationService ajc$this, String socialId, JoinPoint joinPoint) {
        List<ProfileReputation> domainsScore = null;
        try {
            domainsScore = ajc$this.gamificationHistoryDAO.findDomainScoreByUserId(socialId);
        }
        catch (Exception e) {
            LOG.error("Error to find ActionsHistory entity with the following cretiria [socialId:{} / date:{}", new Object[]{socialId, LocalDate.now(), e});
        }
        return domainsScore;
    }

    static /* synthetic */ void saveActionHistory_aroundBody8(GamificationService ajc$this, GamificationActionsHistory aHistory, JoinPoint joinPoint) {
        try {
            ajc$this.gamificationHistoryDAO.create(aHistory);
        }
        catch (Exception e) {
            LOG.error("Error to save the following GamificationActionsHistory entry {}", new Object[]{aHistory, e});
        }
    }

    static /* synthetic */ List filter_aroundBody10(GamificationService ajc$this, LeaderboardFilter filter, boolean isGlobalContext, JoinPoint joinPoint) {
        List<StandardLeaderboard> leaderboard = null;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Filtering leaderboard based on Period/Somain name : [{}/{}]", new Object[]{filter.getPeriod(), filter.getDomain()});
        }
        try {
            if (filter.getDomain().equalsIgnoreCase("all")) {
                LocalDate now = LocalDate.now();
                leaderboard = filter.getPeriod().equals(LeaderboardFilter.Period.WEEK.name()) ? ajc$this.gamificationHistoryDAO.findActionsHistoryByDate(Date.from(now.with(DayOfWeek.MONDAY).atStartOfDay(ZoneId.systemDefault()).toInstant()), isGlobalContext, filter.getLoadCapacity()) : (filter.getPeriod().equals(LeaderboardFilter.Period.MONTH.name()) ? ajc$this.gamificationHistoryDAO.findActionsHistoryByDate(Date.from(now.with(TemporalAdjusters.firstDayOfMonth()).atStartOfDay(ZoneId.systemDefault()).toInstant()), isGlobalContext, filter.getLoadCapacity()) : ajc$this.gamificationHistoryDAO.findAllActionsHistory(isGlobalContext, filter.getLoadCapacity()));
            } else {
                LocalDate now = LocalDate.now();
                leaderboard = filter.getPeriod().equals(LeaderboardFilter.Period.WEEK.name()) ? ajc$this.gamificationHistoryDAO.findActionsHistoryByDateByDomain(Date.from(now.with(DayOfWeek.MONDAY).atStartOfDay(ZoneId.systemDefault()).toInstant()), filter.getDomain(), isGlobalContext, filter.getLoadCapacity()) : (filter.getPeriod().equals(LeaderboardFilter.Period.MONTH.name()) ? ajc$this.gamificationHistoryDAO.findActionsHistoryByDateByDomain(Date.from(now.with(TemporalAdjusters.firstDayOfMonth()).atStartOfDay(ZoneId.systemDefault()).toInstant()), filter.getDomain(), isGlobalContext, filter.getLoadCapacity()) : ajc$this.gamificationHistoryDAO.findAllActionsHistoryByDomain(filter.getDomain(), isGlobalContext, filter.getLoadCapacity()));
            }
        }
        catch (Exception e) {
            LOG.error("Error to filter leaderboard using the following filter [Period:{}-domain:{}-period:{}]", new Object[]{filter.getPeriod(), filter.getDomain(), filter.getPeriod(), e});
        }
        return leaderboard;
    }

    static /* synthetic */ List buildStatsByUser_aroundBody12(GamificationService ajc$this, String userSocialId, JoinPoint joinPoint) {
        List<PiechartLeaderboard> userStats = null;
        try {
            userStats = ajc$this.gamificationHistoryDAO.findStatsByUserId(userSocialId);
        }
        catch (Exception e) {
            LOG.error("Error to load gamification stats for user {} ", new Object[]{userSocialId, e});
        }
        return userStats;
    }

    static /* synthetic */ long findUserReputationScoreBetweenDate_aroundBody14(GamificationService ajc$this, String userSocialId, Date fromDate, Date toDate, JoinPoint joinPoint) {
        long reputationScore = 0L;
        try {
            reputationScore = ajc$this.gamificationHistoryDAO.findUserReputationScoreBetweenDate(userSocialId, fromDate, toDate);
        }
        catch (Exception e) {
            LOG.error("Error to find gamification history for user {} from date:{} to dat:{}", new Object[]{userSocialId, fromDate, toDate, e});
        }
        return reputationScore;
    }

    static /* synthetic */ long findUserReputationScoreByMonth_aroundBody16(GamificationService ajc$this, String userSocialId, Date currentMonth, JoinPoint joinPoint) {
        long reputationScore = 0L;
        try {
            reputationScore = ajc$this.gamificationHistoryDAO.findUserReputationScoreByMonth(userSocialId, currentMonth);
        }
        catch (Exception e) {
            LOG.error("Error to find gamification history for user {} for current month {} ", new Object[]{userSocialId, currentMonth, e});
        }
        return reputationScore;
    }

    static /* synthetic */ long findUserReputationScoreByDomainBetweenDate_aroundBody18(GamificationService ajc$this, String userSocialId, String domain, Date fromDate, Date toDate, JoinPoint joinPoint) {
        long reputationScore = 0L;
        try {
            reputationScore = ajc$this.gamificationHistoryDAO.findUserReputationScoreByDomainBetweenDate(userSocialId, domain, fromDate, toDate);
        }
        catch (Exception e) {
            LOG.error("Error to find gamification history from user {} from date:{} to dat:{}", new Object[]{userSocialId, fromDate, toDate, e});
        }
        return reputationScore;
    }

    static /* synthetic */ List findAllLeaderboardBetweenDate_aroundBody20(GamificationService ajc$this, Date fromDate, Date toDate, JoinPoint joinPoint) {
        List<StandardLeaderboard> list = null;
        try {
            list = ajc$this.gamificationHistoryDAO.findAllLeaderboardBetweenDate(fromDate, toDate);
        }
        catch (Exception e) {
            LOG.error("Error to find gamification history from user {} from date:{} to dat:{}", new Object[]{fromDate, toDate, e});
        }
        return list;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("GamificationService.java", GamificationService.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "findLatestActionHistoryBySocialId", "org.exoplatform.addons.gamification.service.effective.GamificationService", "java.lang.String", "userSocialId", "", "org.exoplatform.addons.gamification.entities.domain.effective.GamificationActionsHistory"), 42);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "findActionHistoryByDateBySocialId", "org.exoplatform.addons.gamification.service.effective.GamificationService", "java.util.Date:java.lang.String", "date:socialId", "", "java.util.List"), 68);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "findAllLeaderboardBetweenDate", "org.exoplatform.addons.gamification.service.effective.GamificationService", "java.util.Date:java.util.Date", "fromDate:toDate", "", "java.util.List"), 314);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "findUserReputationBySocialId", "org.exoplatform.addons.gamification.service.effective.GamificationService", "java.lang.String", "socialId", "", "long"), 121);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "buildDomainScoreByUserId", "org.exoplatform.addons.gamification.service.effective.GamificationService", "java.lang.String", "socialId", "", "java.util.List"), 146);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "saveActionHistory", "org.exoplatform.addons.gamification.service.effective.GamificationService", "org.exoplatform.addons.gamification.entities.domain.effective.GamificationActionsHistory", "aHistory", "", "void"), 170);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "filter", "org.exoplatform.addons.gamification.service.effective.GamificationService", "org.exoplatform.addons.gamification.service.effective.LeaderboardFilter:boolean", "filter:isGlobalContext", "", "java.util.List"), 184);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "buildStatsByUser", "org.exoplatform.addons.gamification.service.effective.GamificationService", "java.lang.String", "userSocialId", "", "java.util.List"), 249);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "findUserReputationScoreBetweenDate", "org.exoplatform.addons.gamification.service.effective.GamificationService", "java.lang.String:java.util.Date:java.util.Date", "userSocialId:fromDate:toDate", "", "long"), 265);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "findUserReputationScoreByMonth", "org.exoplatform.addons.gamification.service.effective.GamificationService", "java.lang.String:java.util.Date", "userSocialId:currentMonth", "", "long"), 281);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "findUserReputationScoreByDomainBetweenDate", "org.exoplatform.addons.gamification.service.effective.GamificationService", "java.lang.String:java.lang.String:java.util.Date:java.util.Date", "userSocialId:domain:fromDate:toDate", "", "long"), 297);
    }
}

