/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.gamification.rest;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.addons.gamification.rest.ManageBadgesEndpoint;
import org.exoplatform.addons.gamification.service.effective.GamificationService;
import org.exoplatform.addons.gamification.service.effective.LeaderboardFilter;
import org.exoplatform.addons.gamification.service.effective.PiechartLeaderboard;
import org.exoplatform.addons.gamification.service.effective.StandardLeaderboard;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.manager.RelationshipManager;

@Path(value="/gamification/leaderboard")
@Produces(value={"application/json"})
@RolesAllowed(value={"users"})
public class LeaderboardEndpoint
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(ManageBadgesEndpoint.class);
    private static final String YOUR_CURRENT_RANK_MSG = "Your current rank";
    private final CacheControl cacheControl = new CacheControl();
    protected IdentityManager identityManager = null;
    protected GamificationService gamificationService = null;
    protected RelationshipManager relationshipManager;

    public LeaderboardEndpoint() {
        this.cacheControl.setNoCache(true);
        this.cacheControl.setNoStore(true);
        this.identityManager = (IdentityManager)CommonsUtils.getService(IdentityManager.class);
        this.gamificationService = (GamificationService)CommonsUtils.getService(GamificationService.class);
        this.relationshipManager = (RelationshipManager)CommonsUtils.getService(RelationshipManager.class);
    }

    @GET
    @Path(value="rank/all")
    public Response getAllLeadersByRank(@Context UriInfo uriInfo) {
        ConversationState conversationState = ConversationState.getCurrent();
        if (conversationState != null) {
            LeaderboardFilter leaderboardFilter = new LeaderboardFilter();
            ArrayList<LeaderboardInfo> leaderboardList = new ArrayList<LeaderboardInfo>();
            LeaderboardInfo leaderboardInfo = null;
            Identity identity = null;
            try {
                List<StandardLeaderboard> standardLeaderboards = this.gamificationService.filter(leaderboardFilter, true);
                if (standardLeaderboards == null) {
                    return Response.ok(leaderboardList, (String)"application/json").cacheControl(this.cacheControl).build();
                }
                for (StandardLeaderboard element : standardLeaderboards) {
                    identity = this.identityManager.getIdentity(element.getUserSocialId(), true);
                    leaderboardInfo = new LeaderboardInfo();
                    leaderboardInfo.setSocialId(identity.getId());
                    leaderboardInfo.setScore(element.getReputationScore());
                    leaderboardInfo.setRemoteId(identity.getRemoteId());
                    leaderboardInfo.setFullname(identity.getProfile().getFullName());
                    leaderboardInfo.setAvatarUrl(identity.getProfile().getAvatarUrl());
                    leaderboardInfo.setProfileUrl(identity.getProfile().getUrl());
                    leaderboardList.add(leaderboardInfo);
                }
                LeaderboardInfo leader = this.buildCurrentUserRank(conversationState.getIdentity().getUserId(), Date.from(LocalDate.now().with(DayOfWeek.MONDAY).atStartOfDay(ZoneId.systemDefault()).toInstant()), leaderboardFilter.getDomain(), leaderboardList);
                if (leader != null) {
                    leaderboardList.add(leader);
                }
                return Response.ok(leaderboardList, (String)"application/json").cacheControl(this.cacheControl).build();
            }
            catch (Exception e) {
                LOG.error((Object)"Error building leaderboard ", (Throwable)e);
                return Response.serverError().cacheControl(this.cacheControl).entity((Object)"Error building leaderboard").build();
            }
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).cacheControl(this.cacheControl).entity((Object)"Unauthorized user").build();
    }

    @GET
    @Path(value="filter")
    public Response filter(@Context UriInfo uriInfo, @QueryParam(value="domain") String domain, @QueryParam(value="period") String period, @QueryParam(value="capacity") String capacity) {
        ConversationState conversationState = ConversationState.getCurrent();
        if (conversationState != null) {
            LeaderboardFilter leaderboardFilter = new LeaderboardFilter();
            if (StringUtils.isNotBlank((CharSequence)domain) && !domain.equalsIgnoreCase("null")) {
                leaderboardFilter.setDomain(domain);
            }
            if (StringUtils.isNotBlank((CharSequence)period)) {
                leaderboardFilter.setPeriod(period);
            }
            if (StringUtils.isNotBlank((CharSequence)capacity)) {
                leaderboardFilter.setLoadCapacity(capacity);
            }
            LeaderboardInfo leaderboardInfo = null;
            ArrayList<LeaderboardInfo> leaderboardInfoList = null;
            try {
                List<StandardLeaderboard> standardLeaderboards = this.gamificationService.filter(leaderboardFilter, true);
                if (standardLeaderboards == null) {
                    return Response.ok(leaderboardInfoList, (String)"application/json").cacheControl(this.cacheControl).build();
                }
                leaderboardInfoList = new ArrayList<LeaderboardInfo>();
                Identity identity = null;
                Identity currentIdentity = this.identityManager.getOrCreateIdentity("organization", conversationState.getIdentity().getUserId(), false);
                for (StandardLeaderboard standardLeaderboard : standardLeaderboards) {
                    identity = this.identityManager.getIdentity(standardLeaderboard.getUserSocialId(), true);
                    leaderboardInfo = new LeaderboardInfo();
                    leaderboardInfo.setSocialId(identity.getId());
                    leaderboardInfo.setScore(standardLeaderboard.getReputationScore());
                    leaderboardInfo.setRemoteId(identity.getRemoteId());
                    leaderboardInfo.setFullname(identity.getProfile().getFullName());
                    leaderboardInfo.setAvatarUrl(identity.getProfile().getAvatarUrl());
                    leaderboardInfo.setProfileUrl(identity.getProfile().getUrl());
                    leaderboardInfoList.add(leaderboardInfo);
                }
                Date date = null;
                switch (leaderboardFilter.getPeriod()) {
                    case "WEEK": {
                        date = Date.from(LocalDate.now().with(DayOfWeek.MONDAY).atStartOfDay(ZoneId.systemDefault()).toInstant());
                        break;
                    }
                    case "MONTH": {
                        date = Date.from(LocalDate.now().with(TemporalAdjusters.firstDayOfMonth()).atStartOfDay(ZoneId.systemDefault()).toInstant());
                    }
                }
                LeaderboardInfo leaderboardInfo2 = this.buildCurrentUserRank(conversationState.getIdentity().getUserId(), date, leaderboardFilter.getDomain(), leaderboardInfoList);
                if (leaderboardInfo2 != null) {
                    leaderboardInfoList.add(leaderboardInfo2);
                }
                return Response.ok(leaderboardInfoList, (String)"application/json").cacheControl(this.cacheControl).build();
            }
            catch (Exception e) {
                LOG.error("Error filtering leaderbaord by Doamin : {} and by Period {} ", new Object[]{leaderboardFilter.getDomain(), leaderboardFilter.getPeriod(), e});
                return Response.serverError().cacheControl(this.cacheControl).entity((Object)"Error filtering leaderboard").build();
            }
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).cacheControl(this.cacheControl).entity((Object)"Unauthorized user").build();
    }

    @GET
    @Path(value="stats")
    public Response stats(@Context UriInfo uriInfo, @QueryParam(value="username") String userSocialId) {
        ConversationState conversationState = ConversationState.getCurrent();
        if (conversationState != null) {
            try {
                if (userSocialId != null) {
                    userSocialId = this.identityManager.getOrCreateIdentity("organization", userSocialId, false).getId();
                }
                List<PiechartLeaderboard> userStats = this.gamificationService.buildStatsByUser(userSocialId);
                return Response.ok(userStats, (String)"application/json").cacheControl(this.cacheControl).build();
            }
            catch (Exception e) {
                LOG.error("Error building statistics for user {} ", new Object[]{userSocialId, e});
                return Response.serverError().cacheControl(this.cacheControl).entity((Object)"Error building statistics").build();
            }
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).cacheControl(this.cacheControl).entity((Object)"Unauthorized user").build();
    }

    private boolean isCurrentUserInTopTen(String username, List<LeaderboardInfo> leaderboard) {
        if (leaderboard.isEmpty()) {
            return false;
        }
        return leaderboard.stream().map(LeaderboardInfo::getSocialId).anyMatch(username::equals);
    }

    private LeaderboardInfo buildCurrentUserRank(String identityId, Date date, String domain, List<LeaderboardInfo> leaderboardList) {
        int rank;
        if (leaderboardList.size() == 0) {
            return null;
        }
        LeaderboardInfo leaderboardInfo = null;
        String currentUser = this.identityManager.getOrCreateIdentity("organization", identityId, false).getId();
        if (!this.isCurrentUserInTopTen(currentUser, leaderboardList) && (rank = this.gamificationService.bluidCurrentUserRank(currentUser, date, domain)) > 0) {
            leaderboardInfo = new LeaderboardInfo();
            leaderboardInfo.setScore(rank);
            leaderboardInfo.setRemoteId(YOUR_CURRENT_RANK_MSG);
            leaderboardInfo.setFullname(YOUR_CURRENT_RANK_MSG);
            leaderboardInfo.setAvatarUrl(YOUR_CURRENT_RANK_MSG);
            leaderboardInfo.setProfileUrl(YOUR_CURRENT_RANK_MSG);
        }
        return leaderboardInfo;
    }

    public static class LeaderboardInfo {
        String socialId;
        String avatarUrl;
        String remoteId;
        String fullname;
        long score;
        String profileUrl;

        public String getAvatarUrl() {
            return this.avatarUrl;
        }

        public void setAvatarUrl(String avatarUrl) {
            this.avatarUrl = avatarUrl;
        }

        public String getRemoteId() {
            return this.remoteId;
        }

        public void setRemoteId(String remoteId) {
            this.remoteId = remoteId;
        }

        public String getFullname() {
            return this.fullname;
        }

        public void setFullname(String fullname) {
            this.fullname = fullname;
        }

        public long getScore() {
            return this.score;
        }

        public void setScore(long score) {
            this.score = score;
        }

        public String getProfileUrl() {
            return this.profileUrl;
        }

        public void setProfileUrl(String profileUrl) {
            this.profileUrl = profileUrl;
        }

        public String getSocialId() {
            return this.socialId;
        }

        public void setSocialId(String socialId) {
            this.socialId = socialId;
        }
    }
}

