/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.gamification.rest;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.addons.gamification.rest.EntityBuilder;
import org.exoplatform.addons.gamification.rest.model.RuleList;
import org.exoplatform.addons.gamification.rest.model.RuleRestEntity;
import org.exoplatform.addons.gamification.service.configuration.RuleService;
import org.exoplatform.addons.gamification.service.dto.configuration.RuleDTO;
import org.exoplatform.addons.gamification.service.dto.configuration.RuleFilter;
import org.exoplatform.addons.gamification.service.dto.configuration.constant.EntityFilterType;
import org.exoplatform.addons.gamification.service.dto.configuration.constant.EntityStatusType;
import org.exoplatform.addons.gamification.utils.Utils;
import org.exoplatform.commons.ObjectAlreadyExistsException;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.manager.IdentityManager;

@Path(value="/gamification/rules")
@Tag(name="/gamification/rules", description="Manages rules")
@Produces(value={"application/json"})
public class ManageRulesEndpoint
implements ResourceContainer {
    private final CacheControl cacheControl = new CacheControl();
    protected RuleService ruleService;
    protected IdentityManager identityManager;

    public ManageRulesEndpoint(RuleService ruleService, IdentityManager identityManager) {
        this.cacheControl.setNoCache(true);
        this.cacheControl.setNoStore(true);
        this.ruleService = ruleService;
        this.identityManager = identityManager;
    }

    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Retrieves the list of available rules", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getRules(@Parameter(description="Offset of results to retrieve", required=false) @QueryParam(value="offset") @DefaultValue(value="0") int offset, @Parameter(description="Limit of results to retrieve", required=false) @QueryParam(value="limit") @DefaultValue(value="20") int limit, @Parameter(description="Used to filter rules by domain", required=false) @QueryParam(value="domainId") long domainId, @Parameter(description="Rules type filtering, possible values: AUTOMATIC, MANUAL and ALL. Default value = ALL.", required=false) @QueryParam(value="type") @DefaultValue(value="ALL") String type, @Parameter(description="Rules status filtering, possible values: ENABLED, DISABLED and ALL. Default value = ENABLED.", required=false) @QueryParam(value="status") @DefaultValue(value="ENABLED") String status, @Parameter(description="If true, this will return the filtered rules including deleted rules. Possible values = true or false. Default value = false.", required=false) @QueryParam(value="includeDeleted") @DefaultValue(value="false") boolean includeDeleted, @Parameter(description="term to search rules with") @QueryParam(value="term") String term, @Parameter(description="If true, this will return the total count of filtered domains. Possible values = true or false. Default value = false.", required=false) @QueryParam(value="returnSize") @DefaultValue(value="false") boolean returnSize, @Parameter(description="Asking for a full representation of a specific subresource, ex: userAnnouncements") @QueryParam(value="expand") String expand) {
        if (offset < 0) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Offset must be 0 or positive").build();
        }
        if (limit < 0) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Limit must be positive").build();
        }
        String currentUser = Utils.getCurrentUser();
        RuleFilter ruleFilter = new RuleFilter();
        ruleFilter.setIncludeDeleted(includeDeleted);
        EntityFilterType filterType = StringUtils.isBlank((CharSequence)type) ? EntityFilterType.ALL : EntityFilterType.valueOf(type);
        ruleFilter.setEntityFilterType(filterType);
        EntityStatusType statusType = StringUtils.isBlank((CharSequence)status) ? EntityStatusType.ENABLED : EntityStatusType.valueOf(status);
        ruleFilter.setEntityStatusType(statusType);
        ruleFilter.setTerm(term);
        if (domainId > 0L) {
            ruleFilter.setDomainId(domainId);
        }
        List<Object> expandFields = null;
        expandFields = StringUtils.isBlank((CharSequence)expand) ? Collections.emptyList() : Arrays.asList(expand.split(","));
        RuleList ruleList = new RuleList();
        List<RuleRestEntity> ruleRestEntities = null;
        List<RuleDTO> rules = null;
        rules = this.ruleService.getRulesByFilter(ruleFilter, offset, limit);
        if (returnSize) {
            int rulesSize = this.ruleService.countAllRules(ruleFilter);
            ruleList.setSize(rulesSize);
        }
        ruleRestEntities = EntityBuilder.ruleListToRestEntities(rules, currentUser, expandFields);
        ruleList.setRules(ruleRestEntities);
        ruleList.setOffset(offset);
        ruleList.setLimit(limit);
        return Response.ok((Object)ruleList).build();
    }

    @GET
    @Path(value="/active")
    @RolesAllowed(value={"users"})
    public Response getActiveRules() {
        ConversationState conversationState = ConversationState.getCurrent();
        if (conversationState != null) {
            List<RuleDTO> activesRules = this.ruleService.getActiveRules();
            return Response.ok().cacheControl(this.cacheControl).entity(activesRules).build();
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).cacheControl(this.cacheControl).entity((Object)"Unauthorized user").build();
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Creates a rule", method="POST")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response createRule(@RequestBody(description="rule object to save", required=true) RuleDTO ruleDTO) {
        if (ruleDTO == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Rule object is mandatory").build();
        }
        String username = Utils.getCurrentUser();
        try {
            ruleDTO = this.ruleService.createRule(ruleDTO, username);
            return Response.ok().cacheControl(this.cacheControl).entity((Object)ruleDTO).build();
        }
        catch (IllegalAccessException e) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)"Your are not authorized to create rule").build();
        }
        catch (ObjectAlreadyExistsException e) {
            return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)"Rule already exists").build();
        }
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Updates a rule", method="PUT")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Request fulfilled"), @ApiResponse(responseCode="404", description="Object not found"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response updateRule(@Context HttpServletRequest request, @RequestBody(description="rule object to update", required=true) RuleDTO ruleDTO) {
        String username = Utils.getCurrentUser();
        if (ruleDTO == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Rule object is mandatory").build();
        }
        try {
            ruleDTO = this.ruleService.updateRule(ruleDTO, username);
            return Response.ok().cacheControl(this.cacheControl).entity((Object)ruleDTO).build();
        }
        catch (IllegalAccessException e) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)"Your are not authorized to update rule").build();
        }
        catch (ObjectNotFoundException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"The rule doesn't exit").build();
        }
    }

    @DELETE
    @Path(value="{ruleId}")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Deletes a rule", method="DELETE")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="404", description="Object not found"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response deleteRule(@Parameter(description="Rule technical identifier", required=true) @PathParam(value="ruleId") long ruleId) {
        if (ruleId <= 0L) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Rule technical identifier must be positive").build();
        }
        String username = Utils.getCurrentUser();
        try {
            RuleDTO ruleDTO = this.ruleService.deleteRuleById(ruleId, username);
            return Response.ok().cacheControl(this.cacheControl).entity((Object)ruleDTO).build();
        }
        catch (ObjectNotFoundException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"The rule doesn't exit").build();
        }
        catch (IllegalAccessException e) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)"Your are not authorized to delete rule").build();
        }
    }
}

