/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.model.filter;

import io.meeds.gamification.constant.IdentityType;
import io.meeds.gamification.constant.RealizationStatus;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class RealizationFilter
implements Serializable {
    private static final long serialVersionUID = 7863115218512008696L;
    private List<String> earnerIds;
    private String sortField;
    private boolean sortDescending;
    private boolean owned;
    private Date fromDate;
    private Date toDate;
    private RealizationStatus status;
    private IdentityType earnerType;
    private List<Long> programIds;
    private List<Long> ruleIds;
    private boolean allPrograms;

    public RealizationFilter(List<String> earnerIds, String sortField, boolean sortDescending, Date fromDate, Date toDate, IdentityType identityType, RealizationStatus status, List<Long> ruleIds) {
        this.earnerIds = earnerIds;
        this.sortField = sortField;
        this.sortDescending = sortDescending;
        this.fromDate = fromDate;
        this.toDate = toDate;
        this.earnerType = identityType;
        this.status = status;
        this.ruleIds = ruleIds;
    }

    public RealizationFilter clone() {
        return new RealizationFilter(this.earnerIds == null ? null : new ArrayList<String>(this.earnerIds), this.sortField, this.sortDescending, this.owned, this.fromDate, this.toDate, this.status, this.earnerType, this.programIds == null ? null : new ArrayList<Long>(this.programIds), (List<Long>)(this.ruleIds == null ? null : new ArrayList<Long>(this.ruleIds)), this.allPrograms);
    }

    public List<String> getEarnerIds() {
        return this.earnerIds;
    }

    public String getSortField() {
        return this.sortField;
    }

    public boolean isSortDescending() {
        return this.sortDescending;
    }

    public boolean isOwned() {
        return this.owned;
    }

    public Date getFromDate() {
        return this.fromDate;
    }

    public Date getToDate() {
        return this.toDate;
    }

    public RealizationStatus getStatus() {
        return this.status;
    }

    public IdentityType getEarnerType() {
        return this.earnerType;
    }

    public List<Long> getProgramIds() {
        return this.programIds;
    }

    public List<Long> getRuleIds() {
        return this.ruleIds;
    }

    public boolean isAllPrograms() {
        return this.allPrograms;
    }

    public void setEarnerIds(List<String> earnerIds) {
        this.earnerIds = earnerIds;
    }

    public void setSortField(String sortField) {
        this.sortField = sortField;
    }

    public void setSortDescending(boolean sortDescending) {
        this.sortDescending = sortDescending;
    }

    public void setOwned(boolean owned) {
        this.owned = owned;
    }

    public void setFromDate(Date fromDate) {
        this.fromDate = fromDate;
    }

    public void setToDate(Date toDate) {
        this.toDate = toDate;
    }

    public void setStatus(RealizationStatus status) {
        this.status = status;
    }

    public void setEarnerType(IdentityType earnerType) {
        this.earnerType = earnerType;
    }

    public void setProgramIds(List<Long> programIds) {
        this.programIds = programIds;
    }

    public void setRuleIds(List<Long> ruleIds) {
        this.ruleIds = ruleIds;
    }

    public void setAllPrograms(boolean allPrograms) {
        this.allPrograms = allPrograms;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RealizationFilter)) {
            return false;
        }
        RealizationFilter other = (RealizationFilter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isSortDescending() != other.isSortDescending()) {
            return false;
        }
        if (this.isOwned() != other.isOwned()) {
            return false;
        }
        if (this.isAllPrograms() != other.isAllPrograms()) {
            return false;
        }
        List<String> this$earnerIds = this.getEarnerIds();
        List<String> other$earnerIds = other.getEarnerIds();
        if (this$earnerIds == null ? other$earnerIds != null : !((Object)this$earnerIds).equals(other$earnerIds)) {
            return false;
        }
        String this$sortField = this.getSortField();
        String other$sortField = other.getSortField();
        if (this$sortField == null ? other$sortField != null : !this$sortField.equals(other$sortField)) {
            return false;
        }
        Date this$fromDate = this.getFromDate();
        Date other$fromDate = other.getFromDate();
        if (this$fromDate == null ? other$fromDate != null : !((Object)this$fromDate).equals(other$fromDate)) {
            return false;
        }
        Date this$toDate = this.getToDate();
        Date other$toDate = other.getToDate();
        if (this$toDate == null ? other$toDate != null : !((Object)this$toDate).equals(other$toDate)) {
            return false;
        }
        RealizationStatus this$status = this.getStatus();
        RealizationStatus other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status)) {
            return false;
        }
        IdentityType this$earnerType = this.getEarnerType();
        IdentityType other$earnerType = other.getEarnerType();
        if (this$earnerType == null ? other$earnerType != null : !((Object)((Object)this$earnerType)).equals((Object)other$earnerType)) {
            return false;
        }
        List<Long> this$programIds = this.getProgramIds();
        List<Long> other$programIds = other.getProgramIds();
        if (this$programIds == null ? other$programIds != null : !((Object)this$programIds).equals(other$programIds)) {
            return false;
        }
        List<Long> this$ruleIds = this.getRuleIds();
        List<Long> other$ruleIds = other.getRuleIds();
        return !(this$ruleIds == null ? other$ruleIds != null : !((Object)this$ruleIds).equals(other$ruleIds));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RealizationFilter;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSortDescending() ? 79 : 97);
        result = result * 59 + (this.isOwned() ? 79 : 97);
        result = result * 59 + (this.isAllPrograms() ? 79 : 97);
        List<String> $earnerIds = this.getEarnerIds();
        result = result * 59 + ($earnerIds == null ? 43 : ((Object)$earnerIds).hashCode());
        String $sortField = this.getSortField();
        result = result * 59 + ($sortField == null ? 43 : $sortField.hashCode());
        Date $fromDate = this.getFromDate();
        result = result * 59 + ($fromDate == null ? 43 : ((Object)$fromDate).hashCode());
        Date $toDate = this.getToDate();
        result = result * 59 + ($toDate == null ? 43 : ((Object)$toDate).hashCode());
        RealizationStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
        IdentityType $earnerType = this.getEarnerType();
        result = result * 59 + ($earnerType == null ? 43 : ((Object)((Object)$earnerType)).hashCode());
        List<Long> $programIds = this.getProgramIds();
        result = result * 59 + ($programIds == null ? 43 : ((Object)$programIds).hashCode());
        List<Long> $ruleIds = this.getRuleIds();
        result = result * 59 + ($ruleIds == null ? 43 : ((Object)$ruleIds).hashCode());
        return result;
    }

    public String toString() {
        return "RealizationFilter(earnerIds=" + this.getEarnerIds() + ", sortField=" + this.getSortField() + ", sortDescending=" + this.isSortDescending() + ", owned=" + this.isOwned() + ", fromDate=" + this.getFromDate() + ", toDate=" + this.getToDate() + ", status=" + this.getStatus() + ", earnerType=" + this.getEarnerType() + ", programIds=" + this.getProgramIds() + ", ruleIds=" + this.getRuleIds() + ", allPrograms=" + this.isAllPrograms() + ")";
    }

    public RealizationFilter() {
    }

    public RealizationFilter(List<String> earnerIds, String sortField, boolean sortDescending, boolean owned, Date fromDate, Date toDate, RealizationStatus status, IdentityType earnerType, List<Long> programIds, List<Long> ruleIds, boolean allPrograms) {
        this.earnerIds = earnerIds;
        this.sortField = sortField;
        this.sortDescending = sortDescending;
        this.owned = owned;
        this.fromDate = fromDate;
        this.toDate = toDate;
        this.status = status;
        this.earnerType = earnerType;
        this.programIds = programIds;
        this.ruleIds = ruleIds;
        this.allPrograms = allPrograms;
    }
}

