/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.model.filter;

import io.meeds.gamification.constant.DateFilterType;
import io.meeds.gamification.constant.EntityFilterType;
import io.meeds.gamification.constant.EntityStatusType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class RuleFilter
implements Serializable {
    private static final long serialVersionUID = 7863115218512008695L;
    private String term;
    private boolean favorites;
    private Locale locale;
    private String eventName;
    private long programId;
    private List<Long> spaceIds;
    private boolean excludeNoSpace;
    private boolean includeDeleted;
    private List<Long> ruleIds;
    private DateFilterType dateFilterType;
    private EntityFilterType type = EntityFilterType.ALL;
    private EntityStatusType status = EntityStatusType.ALL;
    private EntityStatusType programStatus = EntityStatusType.ALL;
    private boolean orderByRealizations;
    private List<Long> excludedRuleIds;
    private String sortBy;
    private boolean sortDescending = true;
    private boolean allSpaces;
    private List<String> tagNames;
    private long identityId;

    public RuleFilter(boolean allSpaces) {
        this.allSpaces = allSpaces;
    }

    public RuleFilter clone() {
        return new RuleFilter(this.term, this.favorites, this.locale, this.eventName, this.programId, this.spaceIds == null ? null : new ArrayList<Long>(this.spaceIds), this.excludeNoSpace, this.includeDeleted, this.ruleIds == null ? null : new ArrayList<Long>(this.ruleIds), this.dateFilterType, this.type, this.status, this.programStatus, this.orderByRealizations, this.excludedRuleIds == null ? null : new ArrayList<Long>(this.excludedRuleIds), this.sortBy, this.sortDescending, this.allSpaces, this.tagNames, this.identityId);
    }

    public String getTerm() {
        return this.term;
    }

    public boolean isFavorites() {
        return this.favorites;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String getEventName() {
        return this.eventName;
    }

    public long getProgramId() {
        return this.programId;
    }

    public List<Long> getSpaceIds() {
        return this.spaceIds;
    }

    public boolean isExcludeNoSpace() {
        return this.excludeNoSpace;
    }

    public boolean isIncludeDeleted() {
        return this.includeDeleted;
    }

    public List<Long> getRuleIds() {
        return this.ruleIds;
    }

    public DateFilterType getDateFilterType() {
        return this.dateFilterType;
    }

    public EntityFilterType getType() {
        return this.type;
    }

    public EntityStatusType getStatus() {
        return this.status;
    }

    public EntityStatusType getProgramStatus() {
        return this.programStatus;
    }

    public boolean isOrderByRealizations() {
        return this.orderByRealizations;
    }

    public List<Long> getExcludedRuleIds() {
        return this.excludedRuleIds;
    }

    public String getSortBy() {
        return this.sortBy;
    }

    public boolean isSortDescending() {
        return this.sortDescending;
    }

    public boolean isAllSpaces() {
        return this.allSpaces;
    }

    public List<String> getTagNames() {
        return this.tagNames;
    }

    public long getIdentityId() {
        return this.identityId;
    }

    public void setTerm(String term) {
        this.term = term;
    }

    public void setFavorites(boolean favorites) {
        this.favorites = favorites;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public void setEventName(String eventName) {
        this.eventName = eventName;
    }

    public void setProgramId(long programId) {
        this.programId = programId;
    }

    public void setSpaceIds(List<Long> spaceIds) {
        this.spaceIds = spaceIds;
    }

    public void setExcludeNoSpace(boolean excludeNoSpace) {
        this.excludeNoSpace = excludeNoSpace;
    }

    public void setIncludeDeleted(boolean includeDeleted) {
        this.includeDeleted = includeDeleted;
    }

    public void setRuleIds(List<Long> ruleIds) {
        this.ruleIds = ruleIds;
    }

    public void setDateFilterType(DateFilterType dateFilterType) {
        this.dateFilterType = dateFilterType;
    }

    public void setType(EntityFilterType type) {
        this.type = type;
    }

    public void setStatus(EntityStatusType status) {
        this.status = status;
    }

    public void setProgramStatus(EntityStatusType programStatus) {
        this.programStatus = programStatus;
    }

    public void setOrderByRealizations(boolean orderByRealizations) {
        this.orderByRealizations = orderByRealizations;
    }

    public void setExcludedRuleIds(List<Long> excludedRuleIds) {
        this.excludedRuleIds = excludedRuleIds;
    }

    public void setSortBy(String sortBy) {
        this.sortBy = sortBy;
    }

    public void setSortDescending(boolean sortDescending) {
        this.sortDescending = sortDescending;
    }

    public void setAllSpaces(boolean allSpaces) {
        this.allSpaces = allSpaces;
    }

    public void setTagNames(List<String> tagNames) {
        this.tagNames = tagNames;
    }

    public void setIdentityId(long identityId) {
        this.identityId = identityId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RuleFilter)) {
            return false;
        }
        RuleFilter other = (RuleFilter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isFavorites() != other.isFavorites()) {
            return false;
        }
        if (this.getProgramId() != other.getProgramId()) {
            return false;
        }
        if (this.isExcludeNoSpace() != other.isExcludeNoSpace()) {
            return false;
        }
        if (this.isIncludeDeleted() != other.isIncludeDeleted()) {
            return false;
        }
        if (this.isOrderByRealizations() != other.isOrderByRealizations()) {
            return false;
        }
        if (this.isSortDescending() != other.isSortDescending()) {
            return false;
        }
        if (this.isAllSpaces() != other.isAllSpaces()) {
            return false;
        }
        if (this.getIdentityId() != other.getIdentityId()) {
            return false;
        }
        String this$term = this.getTerm();
        String other$term = other.getTerm();
        if (this$term == null ? other$term != null : !this$term.equals(other$term)) {
            return false;
        }
        Locale this$locale = this.getLocale();
        Locale other$locale = other.getLocale();
        if (this$locale == null ? other$locale != null : !((Object)this$locale).equals(other$locale)) {
            return false;
        }
        String this$eventName = this.getEventName();
        String other$eventName = other.getEventName();
        if (this$eventName == null ? other$eventName != null : !this$eventName.equals(other$eventName)) {
            return false;
        }
        List<Long> this$spaceIds = this.getSpaceIds();
        List<Long> other$spaceIds = other.getSpaceIds();
        if (this$spaceIds == null ? other$spaceIds != null : !((Object)this$spaceIds).equals(other$spaceIds)) {
            return false;
        }
        List<Long> this$ruleIds = this.getRuleIds();
        List<Long> other$ruleIds = other.getRuleIds();
        if (this$ruleIds == null ? other$ruleIds != null : !((Object)this$ruleIds).equals(other$ruleIds)) {
            return false;
        }
        DateFilterType this$dateFilterType = this.getDateFilterType();
        DateFilterType other$dateFilterType = other.getDateFilterType();
        if (this$dateFilterType == null ? other$dateFilterType != null : !((Object)((Object)this$dateFilterType)).equals((Object)other$dateFilterType)) {
            return false;
        }
        EntityFilterType this$type = this.getType();
        EntityFilterType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        EntityStatusType this$status = this.getStatus();
        EntityStatusType other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status)) {
            return false;
        }
        EntityStatusType this$programStatus = this.getProgramStatus();
        EntityStatusType other$programStatus = other.getProgramStatus();
        if (this$programStatus == null ? other$programStatus != null : !((Object)((Object)this$programStatus)).equals((Object)other$programStatus)) {
            return false;
        }
        List<Long> this$excludedRuleIds = this.getExcludedRuleIds();
        List<Long> other$excludedRuleIds = other.getExcludedRuleIds();
        if (this$excludedRuleIds == null ? other$excludedRuleIds != null : !((Object)this$excludedRuleIds).equals(other$excludedRuleIds)) {
            return false;
        }
        String this$sortBy = this.getSortBy();
        String other$sortBy = other.getSortBy();
        if (this$sortBy == null ? other$sortBy != null : !this$sortBy.equals(other$sortBy)) {
            return false;
        }
        List<String> this$tagNames = this.getTagNames();
        List<String> other$tagNames = other.getTagNames();
        return !(this$tagNames == null ? other$tagNames != null : !((Object)this$tagNames).equals(other$tagNames));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RuleFilter;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isFavorites() ? 79 : 97);
        long $programId = this.getProgramId();
        result = result * 59 + (int)($programId >>> 32 ^ $programId);
        result = result * 59 + (this.isExcludeNoSpace() ? 79 : 97);
        result = result * 59 + (this.isIncludeDeleted() ? 79 : 97);
        result = result * 59 + (this.isOrderByRealizations() ? 79 : 97);
        result = result * 59 + (this.isSortDescending() ? 79 : 97);
        result = result * 59 + (this.isAllSpaces() ? 79 : 97);
        long $identityId = this.getIdentityId();
        result = result * 59 + (int)($identityId >>> 32 ^ $identityId);
        String $term = this.getTerm();
        result = result * 59 + ($term == null ? 43 : $term.hashCode());
        Locale $locale = this.getLocale();
        result = result * 59 + ($locale == null ? 43 : ((Object)$locale).hashCode());
        String $eventName = this.getEventName();
        result = result * 59 + ($eventName == null ? 43 : $eventName.hashCode());
        List<Long> $spaceIds = this.getSpaceIds();
        result = result * 59 + ($spaceIds == null ? 43 : ((Object)$spaceIds).hashCode());
        List<Long> $ruleIds = this.getRuleIds();
        result = result * 59 + ($ruleIds == null ? 43 : ((Object)$ruleIds).hashCode());
        DateFilterType $dateFilterType = this.getDateFilterType();
        result = result * 59 + ($dateFilterType == null ? 43 : ((Object)((Object)$dateFilterType)).hashCode());
        EntityFilterType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        EntityStatusType $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
        EntityStatusType $programStatus = this.getProgramStatus();
        result = result * 59 + ($programStatus == null ? 43 : ((Object)((Object)$programStatus)).hashCode());
        List<Long> $excludedRuleIds = this.getExcludedRuleIds();
        result = result * 59 + ($excludedRuleIds == null ? 43 : ((Object)$excludedRuleIds).hashCode());
        String $sortBy = this.getSortBy();
        result = result * 59 + ($sortBy == null ? 43 : $sortBy.hashCode());
        List<String> $tagNames = this.getTagNames();
        result = result * 59 + ($tagNames == null ? 43 : ((Object)$tagNames).hashCode());
        return result;
    }

    public String toString() {
        return "RuleFilter(term=" + this.getTerm() + ", favorites=" + this.isFavorites() + ", locale=" + String.valueOf(this.getLocale()) + ", eventName=" + this.getEventName() + ", programId=" + this.getProgramId() + ", spaceIds=" + String.valueOf(this.getSpaceIds()) + ", excludeNoSpace=" + this.isExcludeNoSpace() + ", includeDeleted=" + this.isIncludeDeleted() + ", ruleIds=" + String.valueOf(this.getRuleIds()) + ", dateFilterType=" + String.valueOf((Object)this.getDateFilterType()) + ", type=" + String.valueOf((Object)this.getType()) + ", status=" + String.valueOf((Object)this.getStatus()) + ", programStatus=" + String.valueOf((Object)this.getProgramStatus()) + ", orderByRealizations=" + this.isOrderByRealizations() + ", excludedRuleIds=" + String.valueOf(this.getExcludedRuleIds()) + ", sortBy=" + this.getSortBy() + ", sortDescending=" + this.isSortDescending() + ", allSpaces=" + this.isAllSpaces() + ", tagNames=" + String.valueOf(this.getTagNames()) + ", identityId=" + this.getIdentityId() + ")";
    }

    public RuleFilter() {
    }

    public RuleFilter(String term, boolean favorites, Locale locale, String eventName, long programId, List<Long> spaceIds, boolean excludeNoSpace, boolean includeDeleted, List<Long> ruleIds, DateFilterType dateFilterType, EntityFilterType type, EntityStatusType status, EntityStatusType programStatus, boolean orderByRealizations, List<Long> excludedRuleIds, String sortBy, boolean sortDescending, boolean allSpaces, List<String> tagNames, long identityId) {
        this.term = term;
        this.favorites = favorites;
        this.locale = locale;
        this.eventName = eventName;
        this.programId = programId;
        this.spaceIds = spaceIds;
        this.excludeNoSpace = excludeNoSpace;
        this.includeDeleted = includeDeleted;
        this.ruleIds = ruleIds;
        this.dateFilterType = dateFilterType;
        this.type = type;
        this.status = status;
        this.programStatus = programStatus;
        this.orderByRealizations = orderByRealizations;
        this.excludedRuleIds = excludedRuleIds;
        this.sortBy = sortBy;
        this.sortDescending = sortDescending;
        this.allSpaces = allSpaces;
        this.tagNames = tagNames;
        this.identityId = identityId;
    }
}

