/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.gamification.portlets.admin.rule;

import java.util.List;
import javax.inject.Inject;
import javax.portlet.PortletPreferences;
import juzu.HttpMethod;
import juzu.Path;
import juzu.Resource;
import juzu.Response;
import juzu.View;
import juzu.request.SecurityContext;
import juzu.template.Template;
import org.exoplatform.addons.gamification.portlets.common.BaseController;
import org.exoplatform.addons.gamification.service.configuration.RuleService;
import org.exoplatform.commons.juzu.ajax.Ajax;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ManageRuleController
extends BaseController {
    protected static Log log = ExoLogger.getLogger(ManageRuleController.class);
    @Inject
    @Path(value="index.gtmpl")
    Template indexTemplate;
    @Inject
    PortletPreferences portletPreferences;
    @Inject
    RuleService ruleService;

    @View
    public Response.Content index() {
        return this.indexTemplate.with().ok();
    }

    @Resource(method={HttpMethod.GET})
    @Ajax
    public Response init(SecurityContext securityContext) throws JSONException {
        String currentUser = securityContext.getRemoteUser();
        if (currentUser == null) {
            return Response.status((int)401).body((CharSequence)"You must login to create new category");
        }
        List rules = this.ruleService.getAllRules();
        JSONArray rulesJson = new JSONArray();
        rules.forEach(elt -> {
            JSONObject json = new JSONObject(elt);
            rulesJson.put((Object)json);
        });
        return Response.ok((CharSequence)rulesJson.toString()).withMimeType("application/json; charset=UTF-8").withHeader("Cache-Control", new String[]{"no-cache"});
    }
}

