/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.gamification.service.effective;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.addons.gamification.entities.domain.effective.GamificationContextEntity;
import org.exoplatform.addons.gamification.entities.domain.effective.GamificationContextItemEntity;
import org.exoplatform.addons.gamification.service.dto.effective.GamificationContextHolder;
import org.exoplatform.addons.gamification.service.effective.GamificationSearch;
import org.exoplatform.addons.gamification.service.effective.GamificationService$AjcClosure1;
import org.exoplatform.addons.gamification.service.effective.GamificationService$AjcClosure3;
import org.exoplatform.addons.gamification.service.effective.GamificationService$AjcClosure5;
import org.exoplatform.addons.gamification.service.effective.GamificationService$AjcClosure7;
import org.exoplatform.addons.gamification.service.effective.GamificationService$AjcClosure9;
import org.exoplatform.addons.gamification.service.effective.Leaderboard;
import org.exoplatform.addons.gamification.service.effective.Piechart;
import org.exoplatform.addons.gamification.storage.dao.GamificationDAO;
import org.exoplatform.commons.api.persistence.ExoTransactional;
import org.exoplatform.commons.persistence.impl.ExoTransactionalAspect;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class GamificationService {
    private static final Log LOG;
    protected final GamificationDAO gamificationDAO = (GamificationDAO)((Object)CommonsUtils.getService(GamificationDAO.class));
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;

    public GamificationContextEntity findGamificationContextByUsername(String username) {
        GamificationContextEntity entity = null;
        try {
            entity = this.gamificationDAO.findGamificationContextByUsername(username);
        }
        catch (Exception e) {
            LOG.error("Error to find Gamification entity with username : {}", new Object[]{username, e});
        }
        return entity;
    }

    @ExoTransactional
    public void saveGamificationContext(GamificationContextHolder gamificationContextHolder) {
        GamificationContextHolder gamificationContextHolder2 = gamificationContextHolder;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)gamificationContextHolder2);
        Object[] objectArray = new Object[]{this, gamificationContextHolder2, joinPoint};
        ExoTransactionalAspect.aspectOf().around(new GamificationService$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
    }

    @ExoTransactional
    public long getUserGlobalScore(String username) {
        String string = username;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        return Conversions.longValue((Object)ExoTransactionalAspect.aspectOf().around(new GamificationService$AjcClosure3(objectArray).linkClosureAndJoinPoint(69648)));
    }

    @ExoTransactional
    public List<GamificationContextEntity> filter(GamificationSearch gamificationSearch) {
        GamificationSearch gamificationSearch2 = gamificationSearch;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)gamificationSearch2);
        Object[] objectArray = new Object[]{this, gamificationSearch2, joinPoint};
        return (List)ExoTransactionalAspect.aspectOf().around(new GamificationService$AjcClosure5(objectArray).linkClosureAndJoinPoint(69648));
    }

    @ExoTransactional
    public Set<GamificationContextItemEntity> getUserGamification(String userId) {
        String string = userId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        return (Set)ExoTransactionalAspect.aspectOf().around(new GamificationService$AjcClosure7(objectArray).linkClosureAndJoinPoint(69648));
    }

    private boolean checkElementExist(Set<GamificationContextItemEntity> gamificationContextItemEntities, String opType) {
        for (GamificationContextItemEntity item : gamificationContextItemEntities) {
            if (!item.getOpType().equalsIgnoreCase(opType)) continue;
            return false;
        }
        return true;
    }

    @ExoTransactional
    public List<Piechart> findStatsByUserId(String userId) {
        String string = userId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        return (List)ExoTransactionalAspect.aspectOf().around(new GamificationService$AjcClosure9(objectArray).linkClosureAndJoinPoint(69648));
    }

    static {
        GamificationService.ajc$preClinit();
        LOG = ExoLogger.getLogger(GamificationService.class);
    }

    static /* synthetic */ void saveGamificationContext_aroundBody0(GamificationService ajc$this, GamificationContextHolder gamificationContextHolder, JoinPoint joinPoint) {
        try {
            if (gamificationContextHolder.isNew()) {
                ajc$this.gamificationDAO.create(gamificationContextHolder.getGamificationContextEntity());
            } else {
                ajc$this.gamificationDAO.update(gamificationContextHolder.getGamificationContextEntity());
            }
        }
        catch (Exception e) {
            LOG.error("Error to save GamificationUserReputation for user {}", new Object[]{gamificationContextHolder.getGamificationContextEntity().getUsername(), e});
        }
    }

    static /* synthetic */ long getUserGlobalScore_aroundBody2(GamificationService ajc$this, String username, JoinPoint joinPoint) {
        long userScore = 0L;
        GamificationContextEntity entity = null;
        try {
            entity = ajc$this.gamificationDAO.getUserGlobalScore(username);
        }
        catch (Exception e) {
            LOG.error("Error to find Gamification entity with username : {}", new Object[]{username, e.getMessage()});
        }
        if (entity != null) {
            userScore = entity.getScore();
        }
        return userScore;
    }

    static /* synthetic */ List filter_aroundBody4(GamificationService ajc$this, GamificationSearch gamificationSearch, JoinPoint joinPoint) {
        List<GamificationContextEntity> gamificationContextEntities = null;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Filtering leaderboard based on domain name : {}", new Object[]{gamificationSearch.getDomain()});
        }
        try {
            if (gamificationSearch.getDomain().equalsIgnoreCase("all")) {
                gamificationContextEntities = ajc$this.gamificationDAO.findOverallLeaderboard();
            } else {
                List<Leaderboard> leaderboardList = ajc$this.gamificationDAO.findLeaderboardByDomain(gamificationSearch.getDomain());
                if (leaderboardList != null && !leaderboardList.isEmpty()) {
                    GamificationContextEntity gamificationContextEntity = null;
                    gamificationContextEntities = new ArrayList<GamificationContextEntity>();
                    for (Leaderboard leaderBoard : leaderboardList) {
                        gamificationContextEntity = new GamificationContextEntity();
                        gamificationContextEntity.setUsername(leaderBoard.getUserId());
                        gamificationContextEntity.setScore(leaderBoard.getScore());
                        gamificationContextEntities.add(gamificationContextEntity);
                    }
                    gamificationContextEntities.sort((g1, g2) -> (int)g2.getScore() - (int)g1.getScore());
                }
            }
        }
        catch (Exception e) {
            LOG.error("Error to filter leaderboard by domain : {} and by netowrk : {}", new Object[]{gamificationSearch.getDomain(), gamificationSearch.getNetwork(), e});
        }
        return gamificationContextEntities;
    }

    static /* synthetic */ Set getUserGamification_aroundBody6(GamificationService ajc$this, String userId, JoinPoint joinPoint) {
        HashSet<GamificationContextItemEntity> gamificationContextItemEntitySet = null;
        try {
            GamificationContextEntity gamificationContextEntity = ajc$this.gamificationDAO.getUserGamification(userId);
            if (gamificationContextEntity != null) {
                gamificationContextItemEntitySet = new HashSet<GamificationContextItemEntity>();
                for (GamificationContextItemEntity item : gamificationContextEntity.getGamificationItems()) {
                    if (!ajc$this.checkElementExist(gamificationContextItemEntitySet, item.getOpType())) continue;
                    gamificationContextItemEntitySet.add(item);
                }
            }
        }
        catch (Exception e) {
            LOG.error("Error to load effective gamification for user {} ", new Object[]{userId, e});
        }
        return gamificationContextItemEntitySet;
    }

    static /* synthetic */ List findStatsByUserId_aroundBody8(GamificationService ajc$this, String userId, JoinPoint joinPoint) {
        List<Piechart> leaderboardList = null;
        try {
            leaderboardList = ajc$this.gamificationDAO.findStatsByUserId(userId);
        }
        catch (Exception e) {
            LOG.error("Error to load gamification stats for user {} ", new Object[]{userId, e});
        }
        return leaderboardList;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("GamificationService.java", GamificationService.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "saveGamificationContext", "org.exoplatform.addons.gamification.service.effective.GamificationService", "org.exoplatform.addons.gamification.service.dto.effective.GamificationContextHolder", "gamificationContextHolder", "", "void"), 56);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getUserGlobalScore", "org.exoplatform.addons.gamification.service.effective.GamificationService", "java.lang.String", "username", "", "long"), 78);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "filter", "org.exoplatform.addons.gamification.service.effective.GamificationService", "org.exoplatform.addons.gamification.service.effective.GamificationSearch", "gamificationSearch", "", "java.util.List"), 105);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getUserGamification", "org.exoplatform.addons.gamification.service.effective.GamificationService", "java.lang.String", "userId", "", "java.util.Set"), 163);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "findStatsByUserId", "org.exoplatform.addons.gamification.service.effective.GamificationService", "java.lang.String", "userId", "", "java.util.List"), 210);
    }
}

