/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.gamification.service.effective;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.addons.gamification.entities.domain.effective.GamificationContextEntity;
import org.exoplatform.addons.gamification.entities.domain.effective.GamificationContextItemEntity;
import org.exoplatform.addons.gamification.service.dto.effective.GamificationContextHolder;
import org.exoplatform.addons.gamification.service.effective.GamificationSearch;
import org.exoplatform.addons.gamification.service.effective.GamificationService$AjcClosure1;
import org.exoplatform.addons.gamification.service.effective.GamificationService$AjcClosure11;
import org.exoplatform.addons.gamification.service.effective.GamificationService$AjcClosure13;
import org.exoplatform.addons.gamification.service.effective.GamificationService$AjcClosure15;
import org.exoplatform.addons.gamification.service.effective.GamificationService$AjcClosure17;
import org.exoplatform.addons.gamification.service.effective.GamificationService$AjcClosure19;
import org.exoplatform.addons.gamification.service.effective.GamificationService$AjcClosure3;
import org.exoplatform.addons.gamification.service.effective.GamificationService$AjcClosure5;
import org.exoplatform.addons.gamification.service.effective.GamificationService$AjcClosure7;
import org.exoplatform.addons.gamification.service.effective.GamificationService$AjcClosure9;
import org.exoplatform.addons.gamification.service.effective.Piechart;
import org.exoplatform.addons.gamification.storage.dao.GamificationDAO;
import org.exoplatform.addons.gamification.storage.dao.GamificationItemDAO;
import org.exoplatform.commons.api.persistence.ExoTransactional;
import org.exoplatform.commons.persistence.impl.ExoTransactionalAspect;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class GamificationService {
    private static final Log LOG;
    protected final GamificationDAO gamificationDAO;
    protected final GamificationItemDAO gamificationItemDAO;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;

    public GamificationService(GamificationDAO gamificationDAO, GamificationItemDAO gamificationItemDAO) {
        this.gamificationDAO = gamificationDAO;
        this.gamificationItemDAO = gamificationItemDAO;
    }

    @ExoTransactional
    public GamificationContextEntity findGamificationContextByUsername(String username) {
        String string = username;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        return (GamificationContextEntity)ExoTransactionalAspect.aspectOf().around(new GamificationService$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
    }

    @ExoTransactional
    public void saveGamificationContext(GamificationContextHolder gamificationContextHolder) {
        GamificationContextHolder gamificationContextHolder2 = gamificationContextHolder;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)gamificationContextHolder2);
        Object[] objectArray = new Object[]{this, gamificationContextHolder2, joinPoint};
        ExoTransactionalAspect.aspectOf().around(new GamificationService$AjcClosure3(objectArray).linkClosureAndJoinPoint(69648));
    }

    @ExoTransactional
    public void updateUserGamificationContextScore(GamificationContextEntity gamificationContextEntity) {
        GamificationContextEntity gamificationContextEntity2 = gamificationContextEntity;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)gamificationContextEntity2);
        Object[] objectArray = new Object[]{this, gamificationContextEntity2, joinPoint};
        ExoTransactionalAspect.aspectOf().around(new GamificationService$AjcClosure5(objectArray).linkClosureAndJoinPoint(69648));
    }

    @ExoTransactional
    public long getUserGlobalScore(String username) {
        String string = username;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        return Conversions.longValue((Object)ExoTransactionalAspect.aspectOf().around(new GamificationService$AjcClosure7(objectArray).linkClosureAndJoinPoint(69648)));
    }

    @ExoTransactional
    public List<GamificationContextEntity> filter(GamificationSearch gamificationSearch) {
        GamificationSearch gamificationSearch2 = gamificationSearch;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)gamificationSearch2);
        Object[] objectArray = new Object[]{this, gamificationSearch2, joinPoint};
        return (List)ExoTransactionalAspect.aspectOf().around(new GamificationService$AjcClosure9(objectArray).linkClosureAndJoinPoint(69648));
    }

    @ExoTransactional
    public Set<GamificationContextItemEntity> getUserGamification(String userId) {
        String string = userId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        return (Set)ExoTransactionalAspect.aspectOf().around(new GamificationService$AjcClosure11(objectArray).linkClosureAndJoinPoint(69648));
    }

    private boolean checkElementExist(Set<GamificationContextItemEntity> gamificationContextItemEntities, String opType) {
        for (GamificationContextItemEntity item : gamificationContextItemEntities) {
            if (!item.getOpType().equalsIgnoreCase(opType)) continue;
            return false;
        }
        return true;
    }

    @ExoTransactional
    public List<Piechart> findStatsByUserId(String userId) {
        String string = userId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        return (List)ExoTransactionalAspect.aspectOf().around(new GamificationService$AjcClosure13(objectArray).linkClosureAndJoinPoint(69648));
    }

    @ExoTransactional
    public List<GamificationContextItemEntity> findGamificationItemsByUserIdAndDomain(String userId, String domain) {
        String string = userId;
        String string2 = domain;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)string, (Object)string2);
        Object[] objectArray = new Object[]{this, string, string2, joinPoint};
        return (List)ExoTransactionalAspect.aspectOf().around(new GamificationService$AjcClosure15(objectArray).linkClosureAndJoinPoint(69648));
    }

    @ExoTransactional
    public boolean deleteItem(GamificationContextItemEntity gamificationContextItemEntity) {
        GamificationContextItemEntity gamificationContextItemEntity2 = gamificationContextItemEntity;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object)gamificationContextItemEntity2);
        Object[] objectArray = new Object[]{this, gamificationContextItemEntity2, joinPoint};
        return Conversions.booleanValue((Object)ExoTransactionalAspect.aspectOf().around(new GamificationService$AjcClosure17(objectArray).linkClosureAndJoinPoint(69648)));
    }

    @ExoTransactional
    public int loadGamification(String username) {
        String string = username;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        return Conversions.intValue((Object)ExoTransactionalAspect.aspectOf().around(new GamificationService$AjcClosure19(objectArray).linkClosureAndJoinPoint(69648)));
    }

    static {
        GamificationService.ajc$preClinit();
        LOG = ExoLogger.getLogger(GamificationService.class);
    }

    static /* synthetic */ GamificationContextEntity findGamificationContextByUsername_aroundBody0(GamificationService ajc$this, String username, JoinPoint joinPoint) {
        GamificationContextEntity entity = null;
        try {
            entity = ajc$this.gamificationDAO.findGamificationContextByUsername(username);
        }
        catch (Exception e) {
            LOG.error("Error to find Gamification entity with username : {}", new Object[]{username, e});
        }
        return entity;
    }

    static /* synthetic */ void saveGamificationContext_aroundBody2(GamificationService ajc$this, GamificationContextHolder gamificationContextHolder, JoinPoint joinPoint) {
        try {
            if (gamificationContextHolder.isNew()) {
                ajc$this.gamificationDAO.create(gamificationContextHolder.getGamificationContextEntity());
            } else {
                ajc$this.gamificationDAO.update(gamificationContextHolder.getGamificationContextEntity());
            }
        }
        catch (Exception e) {
            LOG.error("Error to save GamificationUserReputation for user {}", new Object[]{gamificationContextHolder.getGamificationContextEntity().getUsername(), e});
        }
    }

    static /* synthetic */ void updateUserGamificationContextScore_aroundBody4(GamificationService ajc$this, GamificationContextEntity gamificationContextEntity, JoinPoint joinPoint) {
        try {
            ajc$this.gamificationDAO.update(gamificationContextEntity);
        }
        catch (Exception e) {
            LOG.error("Error to update GamificationUserReputation for username {}", new Object[]{gamificationContextEntity.getUsername(), e});
        }
    }

    static /* synthetic */ long getUserGlobalScore_aroundBody6(GamificationService ajc$this, String username, JoinPoint joinPoint) {
        long userScore = 0L;
        GamificationContextEntity entity = null;
        try {
            entity = ajc$this.gamificationDAO.getUserGlobalScore(username);
        }
        catch (Exception e) {
            LOG.error("Error to find Gamification entity with username : {}", new Object[]{username, e.getMessage()});
        }
        if (entity != null) {
            userScore = entity.getScore();
        }
        return userScore;
    }

    static /* synthetic */ List filter_aroundBody8(GamificationService ajc$this, GamificationSearch gamificationSearch, JoinPoint joinPoint) {
        List<GamificationContextEntity> gamificationContextEntities = null;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Filtering leaderboard based on domain name : {}", new Object[]{gamificationSearch.getDomain()});
        }
        try {
            if (gamificationSearch.getDomain().equalsIgnoreCase("all")) {
                gamificationContextEntities = ajc$this.gamificationDAO.findOverallLeaderboard();
            } else {
                List<GamificationContextEntity> leaderboardList = ajc$this.gamificationDAO.findLeaderboardByDomain(gamificationSearch.getDomain());
                gamificationContextEntities = new ArrayList<GamificationContextEntity>();
                if (leaderboardList != null && !leaderboardList.isEmpty()) {
                    GamificationContextEntity gamificationContextEntity = null;
                    ArrayList<String> red = null;
                    for (GamificationContextEntity leaderBoard : leaderboardList) {
                        Set<GamificationContextItemEntity> items = leaderBoard.getGamificationItems();
                        if (items == null || items.isEmpty()) continue;
                        red = new ArrayList<String>();
                        int userScore = 0;
                        for (GamificationContextItemEntity gamificationContextItemEntity : items) {
                            if (!gamificationContextItemEntity.getZone().equalsIgnoreCase(gamificationSearch.getDomain()) || red.contains(gamificationContextItemEntity.getOpType())) continue;
                            userScore += gamificationContextItemEntity.getScore();
                            red.add(gamificationContextItemEntity.getOpType());
                        }
                        gamificationContextEntity = new GamificationContextEntity();
                        gamificationContextEntity.setUsername(leaderBoard.getUsername());
                        gamificationContextEntity.setScore(userScore);
                        gamificationContextEntities.add(gamificationContextEntity);
                    }
                    gamificationContextEntities.sort((g1, g2) -> (int)g2.getScore() - (int)g1.getScore());
                }
            }
        }
        catch (Exception e) {
            LOG.error("Error to filter leaderboard by domain : {} and by netowrk : {}", new Object[]{gamificationSearch.getDomain(), gamificationSearch.getNetwork(), e});
        }
        return gamificationContextEntities;
    }

    static /* synthetic */ Set getUserGamification_aroundBody10(GamificationService ajc$this, String userId, JoinPoint joinPoint) {
        HashSet<GamificationContextItemEntity> gamificationContextItemEntitySet = null;
        try {
            GamificationContextEntity gamificationContextEntity = ajc$this.gamificationDAO.getUserGamification(userId);
            if (gamificationContextEntity != null) {
                gamificationContextItemEntitySet = new HashSet<GamificationContextItemEntity>();
                for (GamificationContextItemEntity item : gamificationContextEntity.getGamificationItems()) {
                    if (!ajc$this.checkElementExist(gamificationContextItemEntitySet, item.getOpType())) continue;
                    gamificationContextItemEntitySet.add(item);
                }
            }
        }
        catch (Exception e) {
            LOG.error("Error to load effective gamification for user {} ", new Object[]{userId, e});
        }
        return gamificationContextItemEntitySet;
    }

    static /* synthetic */ List findStatsByUserId_aroundBody12(GamificationService ajc$this, String userId, JoinPoint joinPoint) {
        List<Piechart> leaderboardList = null;
        try {
            leaderboardList = ajc$this.gamificationDAO.findStatsByUserId(userId);
        }
        catch (Exception e) {
            LOG.error("Error to load gamification stats for user {} ", new Object[]{userId, e});
        }
        return leaderboardList;
    }

    static /* synthetic */ List findGamificationItemsByUserIdAndDomain_aroundBody14(GamificationService ajc$this, String userId, String domain, JoinPoint joinPoint) {
        List<GamificationContextItemEntity> gamificationItems = null;
        try {
            gamificationItems = ajc$this.gamificationItemDAO.findGamificationItemsByUserIdAndDomain(userId, domain);
        }
        catch (Exception e) {
            LOG.error("Error to load gamification items for user {} ", new Object[]{userId, e});
        }
        return gamificationItems;
    }

    static /* synthetic */ boolean deleteItem_aroundBody16(GamificationService ajc$this, GamificationContextItemEntity gamificationContextItemEntity, JoinPoint joinPoint) {
        try {
            return ajc$this.gamificationItemDAO.deleteItem(gamificationContextItemEntity);
        }
        catch (Exception e) {
            LOG.error("Error to delete gamification item with Optype {} for user {} ", new Object[]{gamificationContextItemEntity.getOpType(), gamificationContextItemEntity.getGamificationUserEntity().getUsername(), e});
            return false;
        }
    }

    static /* synthetic */ int loadGamification_aroundBody18(GamificationService ajc$this, String username, JoinPoint joinPoint) {
        int rank = 0;
        Object entity = null;
        try {
            List<GamificationContextEntity> entities = ajc$this.gamificationDAO.findAllLeaderboard();
            GamificationContextEntity item = entities.stream().filter((? super T g) -> username.equals(g.getUsername())).findAny().orElse(null);
            return entities.indexOf(item) + 1;
        }
        catch (Exception e) {
            LOG.error("Error to find Gamification entity with username : {}", new Object[]{username, e.getMessage()});
            return rank;
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("GamificationService.java", GamificationService.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "findGamificationContextByUsername", "org.exoplatform.addons.gamification.service.effective.GamificationService", "java.lang.String", "username", "", "org.exoplatform.addons.gamification.entities.domain.effective.GamificationContextEntity"), 41);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "saveGamificationContext", "org.exoplatform.addons.gamification.service.effective.GamificationService", "org.exoplatform.addons.gamification.service.dto.effective.GamificationContextHolder", "gamificationContextHolder", "", "void"), 65);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateUserGamificationContextScore", "org.exoplatform.addons.gamification.service.effective.GamificationService", "org.exoplatform.addons.gamification.entities.domain.effective.GamificationContextEntity", "gamificationContextEntity", "", "void"), 89);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getUserGlobalScore", "org.exoplatform.addons.gamification.service.effective.GamificationService", "java.lang.String", "username", "", "long"), 103);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "filter", "org.exoplatform.addons.gamification.service.effective.GamificationService", "org.exoplatform.addons.gamification.service.effective.GamificationSearch", "gamificationSearch", "", "java.util.List"), 130);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getUserGamification", "org.exoplatform.addons.gamification.service.effective.GamificationService", "java.lang.String", "userId", "", "java.util.Set"), 207);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "findStatsByUserId", "org.exoplatform.addons.gamification.service.effective.GamificationService", "java.lang.String", "userId", "", "java.util.List"), 250);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "findGamificationItemsByUserIdAndDomain", "org.exoplatform.addons.gamification.service.effective.GamificationService", "java.lang.String:java.lang.String", "userId:domain", "", "java.util.List"), 266);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteItem", "org.exoplatform.addons.gamification.service.effective.GamificationService", "org.exoplatform.addons.gamification.entities.domain.effective.GamificationContextItemEntity", "gamificationContextItemEntity", "", "boolean"), 284);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "loadGamification", "org.exoplatform.addons.gamification.service.effective.GamificationService", "java.lang.String", "username", "", "int"), 301);
    }
}

