/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.gamification.entities.domain.effective;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.exoplatform.addons.gamification.entities.domain.effective.GamificationContextItemEntity;
import org.exoplatform.commons.api.persistence.ExoEntity;

@Entity(name="GamificationUserReputation")
@ExoEntity
@Table(name="GAMIFICATION_USER_REPUTATION")
@NamedQueries(value={@NamedQuery(name="GamificationUserReputation.findGamificationContextByUsername", query="SELECT game FROM GamificationUserReputation game where game.username = :username"), @NamedQuery(name="GamificationUserReputation.findLeaderboardByDomain", query="SELECT game FROM GamificationUserReputation game INNER JOIN game.gamificationItems item where item.zone = :domain GROUP BY item.gamificationUserEntity"), @NamedQuery(name="GamificationUserReputation.findOverallLeaderboard", query="SELECT game FROM GamificationUserReputation game ORDER BY game.score DESC"), @NamedQuery(name="GamificationUserReputation.findStatsByUserId", query="SELECT new org.exoplatform.addons.gamification.service.effective.PiechartLeaderboard(item.zone,sum(item.score)) FROM GamificationUserReputation game INNER JOIN game.gamificationItems item where game.username = :userId GROUP BY item.zone")})
public class GamificationContextEntity
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    protected Long id;
    @Column(name="USERNAME", unique=true, nullable=false)
    protected String username;
    @Column(name="SCORE")
    protected long score;
    @OneToMany(mappedBy="gamificationUserEntity", cascade={CascadeType.ALL}, orphanRemoval=true)
    private Set<GamificationContextItemEntity> gamificationItems = new HashSet<GamificationContextItemEntity>();

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public long getScore() {
        return this.score;
    }

    public void setScore(long score) {
        this.score = score;
    }

    public Set<GamificationContextItemEntity> getGamificationItems() {
        return this.gamificationItems;
    }

    public void setGamificationItems(Set<GamificationContextItemEntity> gamificationItems) {
        this.gamificationItems = gamificationItems;
    }

    public void addGamificationItem(GamificationContextItemEntity gamificationItem) {
        this.gamificationItems.add(gamificationItem);
        gamificationItem.setGamificationUserEntity(this);
    }

    public String toString() {
        return String.format("Gamification Entity[%d,%s,%d]", this.id, this.username, this.score);
    }

    public int hashCode() {
        HashCodeBuilder hcb = new HashCodeBuilder();
        hcb.append((Object)this.username);
        return hcb.toHashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof GamificationContextEntity)) {
            return false;
        }
        GamificationContextEntity that = (GamificationContextEntity)obj;
        EqualsBuilder eb = new EqualsBuilder();
        eb.append((Object)this.username, (Object)that.username);
        return eb.isEquals();
    }
}

