/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.gamification.service.setting.rule.impl;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.exoplatform.addons.gamification.service.configuration.RuleService;
import org.exoplatform.addons.gamification.service.dto.configuration.RuleDTO;
import org.exoplatform.addons.gamification.service.setting.rule.RuleRegistry;
import org.exoplatform.addons.gamification.service.setting.rule.model.RuleConfig;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.picocontainer.Startable;

public class RuleRegistryImpl
implements Startable,
RuleRegistry {
    private static final Log LOG = ExoLogger.getLogger(RuleRegistryImpl.class);
    public static final String GAMIFICATION_SETTINGS_RULE_KEY = "GAMIFICATION_SETTINGS_RULE_KEY";
    public static final String GAMIFICATION_SETTINGS_RULE_PROCESSING_DONE = "GAMIFICATION_SETTINGS_RULE_PROCESSING_DONE";
    private final Map<String, RuleConfig> ruleMap = new HashMap<String, RuleConfig>();
    protected RuleService ruleService;

    @Override
    public void addPlugin(RuleConfig rule) {
        this.ruleMap.put(rule.getTitle(), rule);
    }

    @Override
    public boolean remove(RuleConfig rule) {
        this.ruleMap.remove(rule.getTitle());
        return true;
    }

    public void start() {
        this.ruleService = (RuleService)CommonsUtils.getService(RuleService.class);
        try {
            for (RuleConfig rule : this.ruleMap.values()) {
                RuleDTO ruleDTO = this.ruleService.findRuleByTitle(rule.getTitle());
                if (ruleDTO != null) continue;
                this.store(rule);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error when processing Rules ", (Throwable)e);
        }
    }

    public void stop() {
    }

    private void store(RuleConfig ruleConfig) {
        RuleDTO ruleDto = new RuleDTO();
        ruleDto.setTitle(ruleConfig.getTitle());
        ruleDto.setScore(ruleConfig.getScore());
        ruleDto.setEnabled(ruleConfig.isEnable());
        ruleDto.setLastModifiedDate(new Date());
        ruleDto.setLastModifiedBy("Gamification");
        ruleDto.setCreatedBy("Gamification");
        ruleDto.setArea(ruleConfig.getZone());
        ruleDto.setDescription(ruleConfig.getDescription());
        ruleDto.setCreatedDate(new Date());
        ((RuleService)CommonsUtils.getService(RuleService.class)).addRule(ruleDto);
    }

    private boolean isRulesProcessingDone() {
        SettingValue setting = ((SettingService)CommonsUtils.getService(SettingService.class)).get(Context.GLOBAL, Scope.APPLICATION.id(GAMIFICATION_SETTINGS_RULE_KEY), GAMIFICATION_SETTINGS_RULE_PROCESSING_DONE);
        return setting != null && setting.getValue().equals("true");
    }

    private void setRuleProcessingSettingsDone() {
        ((SettingService)CommonsUtils.getService(SettingService.class)).set(Context.GLOBAL, Scope.APPLICATION.id(GAMIFICATION_SETTINGS_RULE_KEY), GAMIFICATION_SETTINGS_RULE_PROCESSING_DONE, SettingValue.create((String)"true"));
    }
}

