/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.gamification.storage.dao;

import java.util.Date;
import java.util.List;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceException;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.exoplatform.addons.gamification.entities.domain.effective.GamificationActionsHistory;
import org.exoplatform.addons.gamification.service.effective.PiechartLeaderboard;
import org.exoplatform.addons.gamification.service.effective.ProfileReputation;
import org.exoplatform.addons.gamification.service.effective.StandardLeaderboard;
import org.exoplatform.commons.persistence.impl.GenericDAOJPAImpl;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class GamificationHistoryDAO
extends GenericDAOJPAImpl<GamificationActionsHistory, Long> {
    private static final Log LOG = ExoLogger.getLogger(GamificationHistoryDAO.class);
    private int queryLimitOffset;

    public GamificationHistoryDAO(InitParams params) {
        ValueParam offsetLimit = params.getValueParam("query-limit-offset");
        try {
            if (offsetLimit != null) {
                this.queryLimitOffset = Integer.parseInt(offsetLimit.getValue());
            }
        }
        catch (NumberFormatException nfe) {
            this.queryLimitOffset = 20;
            LOG.error("Error while parsing query-limit-offset, the default value will be used {}", new Object[]{this.queryLimitOffset, nfe});
        }
    }

    public List<StandardLeaderboard> findAllActionsHistoryAgnostic() throws PersistenceException {
        List defaultLeaderboard = this.getEntityManager().createNamedQuery("GamificationActionsHistory.findAllActionsHistory").getResultList();
        try {
            return defaultLeaderboard;
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public List<GamificationActionsHistory> findActionsHistoryByUserId(String socialUserId) throws PersistenceException {
        List defaultLeaderboard = this.getEntityManager().createNamedQuery("GamificationActionsHistory.findActionsHistoryByUserId").setMaxResults(this.queryLimitOffset).setParameter("socialUserId", (Object)socialUserId).getResultList();
        try {
            return defaultLeaderboard;
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public List<StandardLeaderboard> findAllActionsHistory(boolean isGlobalContext) throws PersistenceException {
        Query query = this.getEntityManager().createNamedQuery("GamificationActionsHistory.findAllActionsHistory");
        if (isGlobalContext) {
            query.setMaxResults(this.queryLimitOffset);
        }
        List defaultLeaderboard = query.getResultList();
        try {
            return defaultLeaderboard;
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public List<StandardLeaderboard> findAllActionsHistoryByDomain(String domain, boolean isGlobalContext) throws PersistenceException {
        Query query = this.getEntityManager().createNamedQuery("GamificationActionsHistory.findAllActionsHistoryByDomain").setParameter("domain", (Object)domain);
        if (isGlobalContext) {
            query.setMaxResults(this.queryLimitOffset);
        }
        List defaultLeaderboard = query.getResultList();
        try {
            return defaultLeaderboard;
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public List<GamificationActionsHistory> findActionHistoryByDateBySocialId(Date date, String socialId) throws PersistenceException {
        TypedQuery query = this.getEntityManager().createNamedQuery("GamificationActionsHistory.findActionHistoryByDateBySocialId", GamificationActionsHistory.class).setParameter("date", (Object)date).setParameter("socialId", (Object)socialId);
        try {
            return query.getResultList();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public List<StandardLeaderboard> findActionsHistoryByDate(Date date, boolean isGlobalContext) throws PersistenceException {
        Query query = this.getEntityManager().createNamedQuery("GamificationActionsHistory.findActionsHistoryByDate");
        query.setParameter("date", (Object)date);
        if (isGlobalContext) {
            query.setMaxResults(this.queryLimitOffset);
        }
        List defaultLeaderboard = query.getResultList();
        try {
            return defaultLeaderboard;
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public List<StandardLeaderboard> findActionsHistoryByDateByDomain(Date date, String domain, boolean isGlobalContext) throws PersistenceException {
        Query query = this.getEntityManager().createNamedQuery("GamificationActionsHistory.findActionsHistoryByDateByDomain").setParameter("date", (Object)date).setParameter("domain", (Object)domain);
        if (isGlobalContext) {
            query.setMaxResults(this.queryLimitOffset);
        }
        List defaultLeaderboard = query.getResultList();
        try {
            return defaultLeaderboard;
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public List<PiechartLeaderboard> findStatsByUserId(String userSocialId) throws PersistenceException {
        List userStats = this.getEntityManager().createNamedQuery("GamificationActionsHistory.findStatsByUser").setParameter("userSocialId", (Object)userSocialId).getResultList();
        try {
            return userStats;
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public List<ProfileReputation> findDomainScoreByUserId(String userSocialId) throws PersistenceException {
        List profileReputation = this.getEntityManager().createNamedQuery("GamificationActionsHistory.findDomainScoreByUserId").setParameter("userSocialId", (Object)userSocialId).getResultList();
        try {
            return profileReputation;
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public long findUserReputationScoreBetweenDate(String userSocialId, Date fromDate, Date toDate) throws PersistenceException {
        long reupationScore = (Long)this.getEntityManager().createNamedQuery("GamificationActionsHistory.findUserReputationScoreBetweenDate").setParameter("userSocialId", (Object)userSocialId).setParameter("fromDate", (Object)fromDate).setParameter("toDate", (Object)toDate).getSingleResult();
        try {
            return reupationScore;
        }
        catch (NoResultException e) {
            return 0L;
        }
    }

    public long findUserReputationScoreByDomainBetweenDate(String userSocialId, String domain, Date fromDate, Date toDate) throws PersistenceException {
        long reupationScore = (Long)this.getEntityManager().createNamedQuery("GamificationActionsHistory.findUserReputationScoreByDomainBetweenDate").setParameter("userSocialId", (Object)userSocialId).setParameter("domain", (Object)domain).setParameter("fromDate", (Object)fromDate).setParameter("toDate", (Object)toDate).getSingleResult();
        try {
            return reupationScore;
        }
        catch (NoResultException e) {
            return 0L;
        }
    }
}

