/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.gamification.listener.social.activity;

import java.time.LocalDate;
import org.exoplatform.addons.gamification.entities.domain.effective.GamificationActionsHistory;
import org.exoplatform.addons.gamification.listener.GamificationListener;
import org.exoplatform.addons.gamification.service.configuration.RuleService;
import org.exoplatform.addons.gamification.service.dto.configuration.RuleDTO;
import org.exoplatform.addons.gamification.service.effective.GamificationProcessor;
import org.exoplatform.addons.gamification.service.effective.GamificationService;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.listener.Asynchronous;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.activity.ActivityLifeCycleEvent;
import org.exoplatform.social.core.activity.ActivityListenerPlugin;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.spi.SpaceService;

@Asynchronous
public class GamificationActivityListener
extends ActivityListenerPlugin
implements GamificationListener {
    private static final Log LOG = ExoLogger.getLogger(GamificationActivityListener.class);
    protected RuleService ruleService = (RuleService)CommonsUtils.getService(RuleService.class);
    protected GamificationProcessor gamificationProcessor = (GamificationProcessor)CommonsUtils.getService(GamificationProcessor.class);
    protected IdentityManager identityManager = (IdentityManager)CommonsUtils.getService(IdentityManager.class);
    protected SpaceService spaceService = (SpaceService)CommonsUtils.getService(SpaceService.class);
    protected GamificationService gamificationService = (GamificationService)CommonsUtils.getService(GamificationService.class);
    protected ActivityManager activityManager = (ActivityManager)CommonsUtils.getService(ActivityManager.class);

    public void saveActivity(ActivityLifeCycleEvent event) {
        ExoSocialActivity activity = (ExoSocialActivity)event.getSource();
        if (!activity.getType().equalsIgnoreCase("DEFAULT_ACTIVITY")) {
            return;
        }
        GamificationActionsHistory aHistory = null;
        RuleDTO ruleDto = null;
        if (this.isSpaceActivity(activity)) {
            ruleDto = this.ruleService.findEnableRuleByTitle("addActivityOnSpaceStream");
            if (ruleDto != null) {
                try {
                    aHistory = this.build(ruleDto, activity.getPosterId());
                    this.gamificationProcessor.execute(aHistory);
                    LOG.info("service=gamification operation=add-new-entry parameters=\"date:{},user_social_id:{},global_score:{},domain:{},action_title:{},action_score:{}\"", new Object[]{LocalDate.now(), aHistory.getUserSocialId(), aHistory.getGlobalScore(), ruleDto.getArea(), ruleDto.getTitle(), ruleDto.getScore()});
                }
                catch (Exception e) {
                    LOG.error("Error to process gamification for Rule {}", new Object[]{ruleDto.getTitle(), e});
                }
            }
            if ((ruleDto = this.ruleService.findEnableRuleByTitle("addActivityOnSpaceStreamTarget")) != null) {
                try {
                    aHistory = this.build(ruleDto, activity.getPosterId());
                    this.gamificationProcessor.execute(aHistory);
                    LOG.info("service=gamification operation=add-new-entry parameters=\"date:{},user_social_id:{},global_score:{},domain:{},action_title:{},action_score:{}\"", new Object[]{LocalDate.now(), aHistory.getUserSocialId(), aHistory.getGlobalScore(), ruleDto.getArea(), ruleDto.getTitle(), ruleDto.getScore()});
                }
                catch (Exception e) {
                    LOG.error("Error to process gamification for Rule {}", new Object[]{ruleDto.getTitle(), e});
                }
            }
        } else if (activity.getPosterId().equalsIgnoreCase(activity.getStreamId())) {
            ruleDto = this.ruleService.findEnableRuleByTitle("addActivityOnMyStream");
            if (ruleDto != null) {
                try {
                    aHistory = this.build(ruleDto, activity.getStreamId());
                    this.gamificationProcessor.execute(aHistory);
                    LOG.info("service=gamification operation=add-new-entry parameters=\"date:{},user_social_id:{},global_score:{},domain:{},action_title:{},action_score:{}\"", new Object[]{LocalDate.now(), aHistory.getUserSocialId(), aHistory.getGlobalScore(), ruleDto.getArea(), ruleDto.getTitle(), ruleDto.getScore()});
                }
                catch (Exception e) {
                    LOG.error("Error to process gamification for Rule {}", new Object[]{ruleDto.getTitle(), e});
                }
            }
        } else {
            ruleDto = this.ruleService.findEnableRuleByTitle("addActivityOnNetworkStream");
            if (ruleDto != null) {
                try {
                    aHistory = this.build(ruleDto, activity.getPosterId());
                    this.gamificationProcessor.execute(aHistory);
                    LOG.info("service=gamification operation=add-new-entry parameters=\"date:{},user_social_id:{},global_score:{},domain:{},action_title:{},action_score:{}\"", new Object[]{LocalDate.now(), aHistory.getUserSocialId(), aHistory.getGlobalScore(), ruleDto.getArea(), ruleDto.getTitle(), ruleDto.getScore()});
                }
                catch (Exception e) {
                    LOG.error("Error to process gamification for Rule {}", new Object[]{ruleDto.getTitle(), e});
                }
            }
            if ((ruleDto = this.ruleService.findEnableRuleByTitle("addActivityTargetUserStream")) != null) {
                try {
                    aHistory = this.build(ruleDto, activity.getStreamId());
                    this.gamificationProcessor.execute(aHistory);
                    LOG.info("service=gamification operation=add-new-entry parameters=\"date:{},user_social_id:{},global_score:{},domain:{},action_title:{},action_score:{}\"", new Object[]{LocalDate.now(), aHistory.getUserSocialId(), aHistory.getGlobalScore(), ruleDto.getArea(), ruleDto.getTitle(), ruleDto.getScore()});
                }
                catch (Exception e) {
                    LOG.error("Error to process gamification for Rule {}", new Object[]{ruleDto.getTitle(), e});
                }
            }
        }
    }

    public void updateActivity(ActivityLifeCycleEvent event) {
    }

    public void saveComment(ActivityLifeCycleEvent event) {
        ExoSocialActivity activity = (ExoSocialActivity)event.getSource();
        GamificationActionsHistory aHistory = null;
        RuleDTO ruleDto = null;
        ExoSocialActivity parent = this.activityManager.getParentActivity(activity);
        if (!parent.getType().equalsIgnoreCase("DEFAULT_ACTIVITY")) {
            return;
        }
        if (parent != null && this.isSpaceActivity(parent)) {
            ruleDto = this.ruleService.findEnableRuleByTitle("commentOnSpaceStream");
            if (ruleDto != null) {
                try {
                    aHistory = this.build(ruleDto, activity.getPosterId());
                    this.gamificationProcessor.execute(aHistory);
                    LOG.info("service=gamification operation=add-new-entry parameters=\"date:{},user_social_id:{},global_score:{},domain:{},action_title:{},action_score:{}\"", new Object[]{LocalDate.now(), aHistory.getUserSocialId(), aHistory.getGlobalScore(), ruleDto.getArea(), ruleDto.getTitle(), ruleDto.getScore()});
                }
                catch (Exception e) {
                    LOG.error("Error to process gamification for Rule {}", new Object[]{ruleDto.getTitle(), e});
                }
            }
        } else if (!activity.getPosterId().equalsIgnoreCase(activity.getStreamId()) && (ruleDto = this.ruleService.findEnableRuleByTitle("commentOnNetworkStream")) != null) {
            try {
                aHistory = this.build(ruleDto, activity.getPosterId());
                this.gamificationProcessor.execute(aHistory);
                LOG.info("service=gamification operation=add-new-entry parameters=\"date:{},user_social_id:{},global_score:{},domain:{},action_title:{},action_score:{}\"", new Object[]{LocalDate.now(), aHistory.getUserSocialId(), aHistory.getGlobalScore(), ruleDto.getArea(), ruleDto.getTitle(), ruleDto.getScore()});
            }
            catch (Exception e) {
                LOG.error("Error to process gamification for Rule {}", new Object[]{ruleDto.getTitle(), e});
            }
        }
    }

    public void likeActivity(ActivityLifeCycleEvent event) {
        ExoSocialActivity activity = (ExoSocialActivity)event.getSource();
        if (!activity.getType().equalsIgnoreCase("DEFAULT_ACTIVITY")) {
            return;
        }
        GamificationActionsHistory aHistory = null;
        RuleDTO ruleDto = null;
        if (this.isSpaceActivity(activity)) {
            ruleDto = this.ruleService.findEnableRuleByTitle("likeActivityOnSpaceStream");
            if (ruleDto != null) {
                try {
                    String[] likersId = activity.getLikeIdentityIds();
                    String liker = this.identityManager.getIdentity(likersId[likersId.length - 1], false).getId();
                    aHistory = this.build(ruleDto, liker);
                    this.gamificationProcessor.execute(aHistory);
                    LOG.info("service=gamification operation=add-new-entry parameters=\"date:{},user_social_id:{},global_score:{},domain:{},action_title:{},action_score:{}\"", new Object[]{LocalDate.now(), aHistory.getUserSocialId(), aHistory.getGlobalScore(), ruleDto.getArea(), ruleDto.getTitle(), ruleDto.getScore()});
                }
                catch (Exception e) {
                    LOG.error("Error to process gamification for Rule {}", new Object[]{ruleDto.getTitle(), e});
                }
            }
            if ((ruleDto = this.ruleService.findEnableRuleByTitle("likeActivityOnSpaceStreamTarget")) != null) {
                try {
                    aHistory = this.build(ruleDto, activity.getPosterId());
                    this.gamificationProcessor.execute(aHistory);
                    LOG.info("service=gamification operation=add-new-entry parameters=\"date:{},user_social_id:{},global_score:{},domain:{},action_title:{},action_score:{}\"", new Object[]{LocalDate.now(), aHistory.getUserSocialId(), aHistory.getGlobalScore(), ruleDto.getArea(), ruleDto.getTitle(), ruleDto.getScore()});
                }
                catch (Exception e) {
                    LOG.error("Error to process gamification for Rule {}", new Object[]{ruleDto.getTitle(), e});
                }
            }
        } else {
            String[] likersId = activity.getLikeIdentityIds();
            String liker = this.identityManager.getIdentity(likersId[likersId.length - 1], false).getId();
            if (!activity.getPosterId().equalsIgnoreCase(liker)) {
                ruleDto = this.ruleService.findEnableRuleByTitle("likeActivityOnNetworkStream");
                if (ruleDto != null) {
                    try {
                        aHistory = this.build(ruleDto, liker);
                        this.gamificationProcessor.execute(aHistory);
                        LOG.info("service=gamification operation=add-new-entry parameters=\"date:{},user_social_id:{},global_score:{},domain:{},action_title:{},action_score:{}\"", new Object[]{LocalDate.now(), aHistory.getUserSocialId(), aHistory.getGlobalScore(), ruleDto.getArea(), ruleDto.getTitle(), ruleDto.getScore()});
                    }
                    catch (Exception e) {
                        LOG.error("Error to process gamification for Rule {}", new Object[]{ruleDto.getTitle(), e});
                    }
                }
                if ((ruleDto = this.ruleService.findEnableRuleByTitle("likeActivityTargetUserStream")) != null) {
                    try {
                        aHistory = this.build(ruleDto, activity.getPosterId());
                        this.gamificationProcessor.execute(aHistory);
                        LOG.info("service=gamification operation=add-new-entry parameters=\"date:{},user_social_id:{},global_score:{},domain:{},action_title:{},action_score:{}\"", new Object[]{LocalDate.now(), aHistory.getUserSocialId(), aHistory.getGlobalScore(), ruleDto.getArea(), ruleDto.getTitle(), ruleDto.getScore()});
                    }
                    catch (Exception e) {
                        LOG.error("Error to process gamification for Rule {}", new Object[]{ruleDto.getTitle(), e});
                    }
                }
            }
        }
    }

    public void likeComment(ActivityLifeCycleEvent event) {
        ExoSocialActivity activity = (ExoSocialActivity)event.getSource();
        GamificationActionsHistory aHistory = null;
        RuleDTO ruleDto = null;
        if (this.isSpaceActivity(activity)) {
            ruleDto = this.ruleService.findEnableRuleByTitle("likeCommentOnspaceStream");
            if (ruleDto != null) {
                try {
                    aHistory = this.build(ruleDto, activity.getPosterId());
                    this.gamificationProcessor.execute(aHistory);
                    LOG.info("service=gamification operation=add-new-entry parameters=\"date:{},user_social_id:{},global_score:{},domain:{},action_title:{},action_score:{}\"", new Object[]{LocalDate.now(), aHistory.getUserSocialId(), aHistory.getGlobalScore(), ruleDto.getArea(), ruleDto.getTitle(), ruleDto.getScore()});
                }
                catch (Exception e) {
                    LOG.error("Error to process gamification for Rule {}", new Object[]{ruleDto.getTitle(), e});
                }
            }
        } else if (!activity.getPosterId().equalsIgnoreCase(activity.getStreamId()) && (ruleDto = this.ruleService.findEnableRuleByTitle("likeCommentOnNetworkStream")) != null) {
            try {
                aHistory = this.build(ruleDto, activity.getPosterId());
                this.gamificationProcessor.execute(aHistory);
                LOG.info("service=gamification operation=add-new-entry parameters=\"date:{},user_social_id:{},global_score:{},domain:{},action_title:{},action_score:{}\"", new Object[]{LocalDate.now(), aHistory.getUserSocialId(), aHistory.getGlobalScore(), ruleDto.getArea(), ruleDto.getTitle(), ruleDto.getScore()});
            }
            catch (Exception e) {
                LOG.error("Error to process gamification for Rule {}", new Object[]{ruleDto.getTitle(), e});
            }
        }
        if ((ruleDto = this.ruleService.findEnableRuleByTitle("likeComment")) != null) {
            String[] likersId = activity.getLikeIdentityIds();
            String liker = this.identityManager.getIdentity(likersId[likersId.length - 1], false).getId();
            try {
                aHistory = this.build(ruleDto, activity.getPosterId());
                this.gamificationProcessor.execute(aHistory);
                LOG.info("service=gamification operation=add-new-entry parameters=\"date:{},user_social_id:{},global_score:{},domain:{},action_title:{},action_score:{}\"", new Object[]{LocalDate.now(), aHistory.getUserSocialId(), aHistory.getGlobalScore(), ruleDto.getArea(), ruleDto.getTitle(), ruleDto.getScore()});
            }
            catch (Exception e) {
                LOG.error("Error to process gamification for Rule {}", new Object[]{ruleDto.getTitle(), e});
            }
        }
    }

    public boolean isSpaceActivity(ExoSocialActivity activity) {
        Identity id = this.identityManager.getOrCreateIdentity("space", activity.getStreamOwner(), false);
        return id != null;
    }
}

