/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.gamification.listener.forum;

import java.beans.PropertyChangeEvent;
import java.time.LocalDate;
import java.util.List;
import org.exoplatform.addons.gamification.entities.domain.effective.GamificationActionsHistory;
import org.exoplatform.addons.gamification.listener.GamificationListener;
import org.exoplatform.addons.gamification.listener.forum.ForumUtils;
import org.exoplatform.addons.gamification.service.configuration.RuleService;
import org.exoplatform.addons.gamification.service.dto.configuration.RuleDTO;
import org.exoplatform.addons.gamification.service.effective.GamificationProcessor;
import org.exoplatform.addons.gamification.service.effective.GamificationService;
import org.exoplatform.forum.service.Category;
import org.exoplatform.forum.service.Forum;
import org.exoplatform.forum.service.ForumEventListener;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.Post;
import org.exoplatform.forum.service.Topic;
import org.exoplatform.forum.service.Utils;
import org.exoplatform.services.listener.Asynchronous;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.spi.SpaceService;

@Asynchronous
public class GamificationForumListener
extends ForumEventListener
implements GamificationListener {
    private static final Log LOG = ExoLogger.getLogger(GamificationForumListener.class);
    protected RuleService ruleService;
    protected GamificationProcessor gamificationProcessor;
    protected IdentityManager identityManager;
    protected SpaceService spaceService;
    protected GamificationService gamificationService;
    protected ActivityManager activityManager;
    protected ForumService forumService;

    public GamificationForumListener(RuleService ruleService, GamificationProcessor gamificationProcessor, IdentityManager identityManager, SpaceService spaceService, GamificationService gamificationService, ActivityManager activityManager, ForumService forumService) {
        this.ruleService = ruleService;
        this.gamificationProcessor = gamificationProcessor;
        this.identityManager = identityManager;
        this.spaceService = spaceService;
        this.gamificationService = gamificationService;
        this.activityManager = activityManager;
        this.forumService = forumService;
    }

    public void saveCategory(Category category) {
    }

    public void saveForum(Forum forum) {
    }

    public void addPost(Post post) {
        GamificationActionsHistory aHistory = null;
        RuleDTO ruleDto = null;
        ruleDto = this.ruleService.findEnableRuleByTitle("addForumPost");
        if (ruleDto != null) {
            try {
                String receiver = this.identityManager.getOrCreateIdentity("organization", post.getOwner(), false).getId();
                aHistory = this.build(ruleDto, this.identityManager.getOrCreateIdentity("organization", post.getOwner(), false).getId(), receiver, ForumUtils.createdSubForumLink(post.toString(), post.getTopicId(), true));
                this.gamificationProcessor.execute(aHistory);
                LOG.info("service=gamification operation=add-new-entry parameters=\"date:{},user_social_id:{},global_score:{},domain:{},action_title:{},action_score:{}\"", new Object[]{LocalDate.now(), aHistory.getUserSocialId(), aHistory.getGlobalScore(), ruleDto.getArea(), ruleDto.getTitle(), ruleDto.getScore()});
            }
            catch (Exception e) {
                LOG.error("Error to process gamification for Rule {}", new Object[]{ruleDto.getTitle(), e});
            }
        }
    }

    public void updatePost(Post post) {
    }

    public void updatePost(Post post, int type) {
    }

    public void addTopic(Topic topic) {
        GamificationActionsHistory aHistory = null;
        RuleDTO ruleDto = null;
        ruleDto = this.ruleService.findEnableRuleByTitle("addForumTopic");
        if (ruleDto != null) {
            try {
                String receiver = this.identityManager.getOrCreateIdentity("organization", topic.getOwner(), false).getId();
                aHistory = this.build(ruleDto, this.identityManager.getOrCreateIdentity("organization", topic.getOwner(), false).getId(), receiver, ForumUtils.createdSubForumLink(topic.toString(), topic.getId(), true));
                this.gamificationProcessor.execute(aHistory);
                LOG.info("service=gamification operation=add-new-entry parameters=\"date:{},user_social_id:{},global_score:{},domain:{},action_title:{},action_score:{}\"", new Object[]{LocalDate.now(), aHistory.getUserSocialId(), aHistory.getGlobalScore(), ruleDto.getArea(), ruleDto.getTitle(), ruleDto.getScore()});
            }
            catch (Exception e) {
                LOG.error("Error to process gamification for Rule {}", new Object[]{ruleDto.getTitle(), e});
            }
        }
    }

    public void updateTopic(Topic topic) {
        PropertyChangeEvent[] events = topic.getChangeEvent();
        for (int i = 0; i < events.length; ++i) {
            this.processUpdateTopicType(events[i], topic);
        }
    }

    public void updateTopics(List<Topic> topics, boolean isLock) {
    }

    public void moveTopic(Topic topic, String toCategoryName, String toForumName) {
    }

    public void mergeTopic(Topic newTopic, String removeActivityId1, String removeActivityId2) {
    }

    public void splitTopic(Topic newTopic, Topic splitedTopic, String removeActivityId) {
    }

    public void removeActivity(String activityId) {
    }

    public void removeComment(String activityId, String commentId) {
    }

    public void movePost(List<Post> list, List<String> list1, String s) {
    }

    public void openTopic(String userId, String topicId) {
        GamificationActionsHistory aHistory = null;
        Topic topic = new Topic();
        RuleDTO ruleDto = null;
        ruleDto = this.ruleService.findEnableRuleByTitle("openForumTopic");
        String topicOwner = null;
        if (ruleDto != null) {
            try {
                topicOwner = ((Topic)this.forumService.getObjectNameById(topicId, Utils.TOPIC)).getOwner();
                if (topicOwner != null && topicOwner.length() != 0 && !topicOwner.equals(userId)) {
                    aHistory = this.build(ruleDto, this.identityManager.getOrCreateIdentity("organization", userId, false).getId(), this.identityManager.getOrCreateIdentity("organization", topicOwner, false).getId(), ForumUtils.createdSubForumLink(topic.toString(), topicId, true));
                    this.gamificationProcessor.execute(aHistory);
                    LOG.info("service=gamification operation=add-new-entry parameters=\"date:{},user_social_id:{},global_score:{},domain:{},action_title:{},action_score:{}\"", new Object[]{LocalDate.now(), aHistory.getUserSocialId(), aHistory.getGlobalScore(), ruleDto.getArea(), ruleDto.getTitle(), ruleDto.getScore()});
                }
            }
            catch (Exception e) {
                LOG.error("Error to process gamification for Rule {}", new Object[]{ruleDto.getTitle(), e});
            }
        }
    }

    private void processUpdateTopicType(PropertyChangeEvent event, Topic topic) {
        if (Topic.TOPIC_RATING.equals(event.getPropertyName())) {
            GamificationActionsHistory aHistory = null;
            RuleDTO ruleDto = null;
            ruleDto = this.ruleService.findEnableRuleByTitle("voteForumTopic");
            if (ruleDto != null) {
                try {
                    String receiver = this.identityManager.getOrCreateIdentity("organization", topic.getOwner(), false).getId();
                    aHistory = this.build(ruleDto, this.identityManager.getOrCreateIdentity("organization", topic.getOwner(), false).getId(), receiver, ForumUtils.createdSubForumLink(topic.toString(), topic.getId(), true));
                    this.gamificationProcessor.execute(aHistory);
                    LOG.info("service=gamification operation=add-new-entry parameters=\"date:{},user_social_id:{},global_score:{},domain:{},action_title:{},action_score:{}\"", new Object[]{LocalDate.now(), aHistory.getUserSocialId(), aHistory.getGlobalScore(), ruleDto.getArea(), ruleDto.getTitle(), ruleDto.getScore()});
                }
                catch (Exception e) {
                    LOG.error("Error to process gamification for Rule {}", new Object[]{ruleDto.getTitle(), e});
                }
            }
        }
    }
}

