/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.gamification.rest;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.addons.gamification.GamificationUtils;
import org.exoplatform.addons.gamification.entities.domain.effective.GamificationActionsHistory;
import org.exoplatform.addons.gamification.rest.ManageBadgesEndpoint;
import org.exoplatform.addons.gamification.service.effective.GamificationService;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.manager.RelationshipManager;

@Path(value="/gamification/gameficationinformationsboard")
@Produces(value={"application/json"})
@RolesAllowed(value={"users"})
public class GamificationInformationsEndpoint
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(ManageBadgesEndpoint.class);
    private final CacheControl cacheControl = new CacheControl();
    protected IdentityManager identityManager = null;
    protected GamificationService gamificationService = null;
    protected RelationshipManager relationshipManager;

    public GamificationInformationsEndpoint() {
        this.cacheControl.setNoCache(true);
        this.cacheControl.setNoStore(true);
        this.identityManager = (IdentityManager)CommonsUtils.getService(IdentityManager.class);
        this.gamificationService = (GamificationService)CommonsUtils.getService(GamificationService.class);
        this.relationshipManager = (RelationshipManager)CommonsUtils.getService(RelationshipManager.class);
    }

    @GET
    @Path(value="history/all")
    public Response getAllLeadersByRank(@Context UriInfo uriInfo, @QueryParam(value="capacity") String capacity, @QueryParam(value="url") String url) {
        ConversationState conversationState = ConversationState.getCurrent();
        String profileOwner = GamificationUtils.extractProfileOwnerFromUrl(url, "/");
        if (conversationState != null) {
            boolean isOwner = false;
            ArrayList<GamificationHistoryInfo> historyList = new ArrayList<GamificationHistoryInfo>();
            Identity identity = this.identityManager.getOrCreateIdentity("organization", conversationState.getIdentity().getUserId(), false);
            String actorId = this.identityManager.getOrCreateIdentity("organization", profileOwner, false).getId();
            if (actorId.equals(identity.getId()) || conversationState.getIdentity().isMemberOf("/platform/administrators")) {
                isOwner = true;
            }
            try {
                List<GamificationActionsHistory> ss;
                int loadCapacity = 10;
                if (StringUtils.isNotBlank((CharSequence)capacity)) {
                    loadCapacity = Integer.parseInt(capacity);
                }
                if ((ss = this.gamificationService.findActionsHistoryByReceiverId(actorId, true, loadCapacity)) == null) {
                    return Response.ok(new ArrayList(), (String)"application/json").cacheControl(this.cacheControl).build();
                }
                for (GamificationActionsHistory element : ss) {
                    identity = this.identityManager.getIdentity(element.getUserSocialId(), true);
                    Profile profile = identity.getProfile();
                    GamificationHistoryInfo gamificationHistoryInfo = new GamificationHistoryInfo();
                    gamificationHistoryInfo.setSocialId(identity.getId());
                    gamificationHistoryInfo.setReceiver(element.getReceiver());
                    gamificationHistoryInfo.setRemoteId(identity.getRemoteId());
                    gamificationHistoryInfo.setFullname(profile.getFullName());
                    gamificationHistoryInfo.setAvatarUrl(profile.getAvatarUrl());
                    gamificationHistoryInfo.setProfileUrl(profile.getUrl());
                    gamificationHistoryInfo.setActionScore(element.getActionScore());
                    gamificationHistoryInfo.setActionTitle(element.getActionTitle());
                    gamificationHistoryInfo.setContext(element.getContext());
                    gamificationHistoryInfo.setCreatedDate(element.getCreatedDate().toGMTString());
                    gamificationHistoryInfo.setDomain(element.getDomain());
                    gamificationHistoryInfo.setGlobalScore(element.getGlobalScore());
                    if (isOwner) {
                        gamificationHistoryInfo.setObjectId(element.getObjectId());
                    }
                    historyList.add(gamificationHistoryInfo);
                }
                return Response.ok(historyList, (String)"application/json").cacheControl(this.cacheControl).build();
            }
            catch (Exception e) {
                LOG.error((Object)"Error building My points history ", (Throwable)e);
                return Response.serverError().cacheControl(this.cacheControl).entity((Object)"Error building My points history").build();
            }
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).cacheControl(this.cacheControl).entity((Object)"Unauthorized user").build();
    }

    public static class GamificationHistoryInfo {
        String socialId;
        String avatarUrl;
        String remoteId;
        String fullname;
        String profileUrl;
        String createdDate;
        long globalScore;
        String actionTitle;
        String domain;
        String context;
        long actionScore;
        private int loadCapacity = 10;
        private String receiver;
        private String objectId;

        public int getLoadCapacity() {
            return this.loadCapacity;
        }

        public void setLoadCapacity(String loadCapacity) {
            this.loadCapacity = Integer.parseInt(loadCapacity);
        }

        public String getAvatarUrl() {
            return this.avatarUrl;
        }

        public void setAvatarUrl(String avatarUrl) {
            this.avatarUrl = avatarUrl;
        }

        public String getRemoteId() {
            return this.remoteId;
        }

        public void setRemoteId(String remoteId) {
            this.remoteId = remoteId;
        }

        public String getFullname() {
            return this.fullname;
        }

        public void setFullname(String fullname) {
            this.fullname = fullname;
        }

        public String getProfileUrl() {
            return this.profileUrl;
        }

        public void setProfileUrl(String profileUrl) {
            this.profileUrl = profileUrl;
        }

        public String getSocialId() {
            return this.socialId;
        }

        public void setSocialId(String socialId) {
            this.socialId = socialId;
        }

        public long getGlobalScore() {
            return this.globalScore;
        }

        public void setGlobalScore(long globalScore) {
            this.globalScore = globalScore;
        }

        public String getActionTitle() {
            return this.actionTitle;
        }

        public void setActionTitle(String actionTitle) {
            this.actionTitle = actionTitle;
        }

        public String getDomain() {
            return this.domain;
        }

        public void setDomain(String domain) {
            this.domain = domain;
        }

        public String getContext() {
            return this.context;
        }

        public void setContext(String context) {
            this.context = context;
        }

        public long getActionScore() {
            return this.actionScore;
        }

        public void setActionScore(long actionScore) {
            this.actionScore = actionScore;
        }

        public String getCreatedDate() {
            return this.createdDate;
        }

        public void setCreatedDate(String createdDate) {
            this.createdDate = createdDate;
        }

        public String getReceiver() {
            return this.receiver;
        }

        public void setReceiver(String receiver) {
            this.receiver = receiver;
        }

        public String getObjectId() {
            return this.objectId;
        }

        public void setObjectId(String objectId) {
            this.objectId = objectId;
        }
    }
}

