/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.gamification.listener.generic;

import java.time.LocalDate;
import java.util.Map;
import org.exoplatform.addons.gamification.entities.domain.effective.GamificationActionsHistory;
import org.exoplatform.addons.gamification.service.configuration.RuleService;
import org.exoplatform.addons.gamification.service.dto.configuration.RuleDTO;
import org.exoplatform.addons.gamification.service.effective.GamificationProcessor;
import org.exoplatform.addons.gamification.service.effective.GamificationService;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.manager.IdentityManager;

public class GamificationGenericListener
extends Listener<Map<String, String>, String> {
    private static final Log LOG = ExoLogger.getLogger(GamificationGenericListener.class);
    protected RuleService ruleService;
    protected GamificationProcessor gamificationProcessor;
    protected IdentityManager identityManager;
    protected GamificationService gamificationService;

    public GamificationGenericListener(RuleService ruleService, GamificationProcessor gamificationProcessor, IdentityManager identityManager, GamificationService gamificationService) {
        this.ruleService = ruleService;
        this.gamificationProcessor = gamificationProcessor;
        this.identityManager = identityManager;
        this.gamificationService = gamificationService;
    }

    public void onEvent(Event<Map<String, String>, String> event) throws Exception {
        GamificationActionsHistory aHistory = null;
        RuleDTO ruleDto = null;
        String ruleTitle = (String)((Map)event.getSource()).get("ruleTitle");
        String senderId = (String)((Map)event.getSource()).get("senderId");
        String receiverId = (String)((Map)event.getSource()).get("receiverId");
        String obj = (String)((Map)event.getSource()).get("object");
        ruleDto = this.ruleService.findEnableRuleByTitle(ruleTitle);
        if (ruleDto != null) {
            try {
                String sender = this.identityManager.getOrCreateIdentity("organization", senderId, false).getId();
                String receiver = this.identityManager.getOrCreateIdentity("organization", receiverId, false).getId();
                aHistory = senderId != receiverId ? this.gamificationService.build(ruleDto, receiver, receiver, obj) : this.gamificationService.build(ruleDto, sender, receiver, obj);
                this.gamificationProcessor.execute(aHistory);
                LOG.info("service=gamification operation=add-new-entry parameters=\"date:{},user_social_id:{},global_score:{},domain:{},action_title:{},action_score:{}\"", new Object[]{LocalDate.now(), aHistory.getUserSocialId(), aHistory.getGlobalScore(), ruleDto.getArea(), ruleDto.getTitle(), ruleDto.getScore()});
            }
            catch (Exception e) {
                LOG.error("Error to process gamification for Rule {}", new Object[]{ruleDto.getTitle(), e});
            }
        }
    }
}

