/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.gamification.storage.dao;

import java.util.Date;
import java.util.List;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceException;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.addons.gamification.entities.domain.effective.GamificationActionsHistory;
import org.exoplatform.addons.gamification.service.effective.PiechartLeaderboard;
import org.exoplatform.addons.gamification.service.effective.ProfileReputation;
import org.exoplatform.addons.gamification.service.effective.StandardLeaderboard;
import org.exoplatform.addons.gamification.storage.dao.GamificationHistoryDAO$AjcClosure1;
import org.exoplatform.addons.gamification.storage.dao.GamificationHistoryDAO$AjcClosure3;
import org.exoplatform.addons.gamification.storage.dao.GamificationHistoryDAO$AjcClosure5;
import org.exoplatform.commons.api.persistence.ExoTransactional;
import org.exoplatform.commons.persistence.impl.ExoTransactionalAspect;
import org.exoplatform.commons.persistence.impl.GenericDAOJPAImpl;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class GamificationHistoryDAO
extends GenericDAOJPAImpl<GamificationActionsHistory, Long> {
    private static final Log LOG;
    private int queryLimitOffset;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

    public GamificationHistoryDAO(InitParams params) {
        ValueParam offsetLimit = params.getValueParam("query-limit-offset");
        try {
            if (offsetLimit != null) {
                this.queryLimitOffset = Integer.parseInt(offsetLimit.getValue());
            }
        }
        catch (NumberFormatException nfe) {
            this.queryLimitOffset = 20;
            LOG.error("Error while parsing query-limit-offset, the default value will be used {}", new Object[]{this.queryLimitOffset, nfe});
        }
    }

    public List<StandardLeaderboard> findAllActionsHistoryAgnostic() throws PersistenceException {
        List defaultLeaderboard = this.getEntityManager().createNamedQuery("GamificationActionsHistory.findAllActionsHistory").getResultList();
        try {
            return defaultLeaderboard;
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public List<StandardLeaderboard> findAllActionsHistoryByDateByDomain(Date date, String domain) throws PersistenceException {
        try {
            List defaultLeaderboard = this.getEntityManager().createNamedQuery("GamificationActionsHistory.findAllActionsHistoryByDateByDomain").setParameter("date", (Object)date).setParameter("domain", (Object)domain).getResultList();
            return defaultLeaderboard;
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public List<StandardLeaderboard> findAllActionsHistoryByDomain(String domain) throws PersistenceException {
        try {
            List defaultLeaderboard = this.getEntityManager().createNamedQuery("GamificationActionsHistory.findAllActionsHistoryByDomain").setParameter("domain", (Object)domain).getResultList();
            return defaultLeaderboard;
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public List<StandardLeaderboard> findAllActionsHistoryByDate(Date date) throws PersistenceException {
        try {
            List defaultLeaderboard = this.getEntityManager().createNamedQuery("GamificationActionsHistory.findActionsHistoryByDate").setParameter("date", (Object)date).getResultList();
            return defaultLeaderboard;
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public List<GamificationActionsHistory> findActionsHistoryByUserId(String socialUserId) throws PersistenceException {
        List defaultLeaderboard = this.getEntityManager().createNamedQuery("GamificationActionsHistory.findActionsHistoryByUserId").setMaxResults(this.queryLimitOffset).setParameter("socialUserId", (Object)socialUserId).getResultList();
        try {
            return defaultLeaderboard;
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public List<StandardLeaderboard> findAllActionsHistory(boolean isGlobalContext, int loadCapacity) throws PersistenceException {
        Query query = this.getEntityManager().createNamedQuery("GamificationActionsHistory.findAllActionsHistory");
        if (isGlobalContext) {
            query.setMaxResults(loadCapacity);
        }
        List defaultLeaderboard = query.getResultList();
        try {
            return defaultLeaderboard;
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public List<StandardLeaderboard> findAllActionsHistoryByDomain(String domain, boolean isGlobalContext, int loadCapacity) throws PersistenceException {
        Query query = this.getEntityManager().createNamedQuery("GamificationActionsHistory.findAllActionsHistoryByDomain").setParameter("domain", (Object)domain);
        if (isGlobalContext) {
            query.setMaxResults(loadCapacity);
        }
        List defaultLeaderboard = query.getResultList();
        try {
            return defaultLeaderboard;
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public List<GamificationActionsHistory> findActionHistoryByDateBySocialId(Date date, String socialId) throws PersistenceException {
        TypedQuery query = this.getEntityManager().createNamedQuery("GamificationActionsHistory.findActionHistoryByDateBySocialId", GamificationActionsHistory.class).setParameter("date", (Object)date).setParameter("socialId", (Object)socialId);
        try {
            return query.getResultList();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public List<StandardLeaderboard> findActionsHistoryByDate(Date date, boolean isGlobalContext, int loadCapacity) throws PersistenceException {
        Query query = this.getEntityManager().createNamedQuery("GamificationActionsHistory.findActionsHistoryByDate");
        query.setParameter("date", (Object)date);
        if (isGlobalContext) {
            query.setMaxResults(loadCapacity);
        }
        List defaultLeaderboard = query.getResultList();
        try {
            return defaultLeaderboard;
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public List<StandardLeaderboard> findActionsHistoryByDateByDomain(Date date, String domain, boolean isGlobalContext, int loadCapacity) throws PersistenceException {
        Query query = this.getEntityManager().createNamedQuery("GamificationActionsHistory.findActionsHistoryByDateByDomain").setParameter("date", (Object)date).setParameter("domain", (Object)domain);
        if (isGlobalContext) {
            query.setMaxResults(loadCapacity);
        }
        List defaultLeaderboard = query.getResultList();
        try {
            return defaultLeaderboard;
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public List<PiechartLeaderboard> findStatsByUserId(String userSocialId) throws PersistenceException {
        List userStats = this.getEntityManager().createNamedQuery("GamificationActionsHistory.findStatsByUser").setParameter("userSocialId", (Object)userSocialId).getResultList();
        try {
            return userStats;
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public List<ProfileReputation> findDomainScoreByUserId(String userSocialId) throws PersistenceException {
        List profileReputation = this.getEntityManager().createNamedQuery("GamificationActionsHistory.findDomainScoreByUserId").setParameter("userSocialId", (Object)userSocialId).getResultList();
        try {
            return profileReputation;
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public long findUserReputationScoreBetweenDate(String userSocialId, Date fromDate, Date toDate) throws PersistenceException {
        Long reupationScore = (Long)this.getEntityManager().createNamedQuery("GamificationActionsHistory.findUserReputationScoreBetweenDate").setParameter("userSocialId", (Object)userSocialId).setParameter("fromDate", (Object)fromDate).setParameter("toDate", (Object)toDate).getSingleResult();
        try {
            return reupationScore == null ? 0L : reupationScore;
        }
        catch (NoResultException e) {
            return 0L;
        }
        catch (Exception e) {
            LOG.error((Object)e);
            return 0L;
        }
    }

    public long findUserReputationScoreByMonth(String userSocialId, Date currentMonth) throws PersistenceException {
        Long reupationScore = (Long)this.getEntityManager().createNamedQuery("GamificationActionsHistory.findUserReputationScoreByMonth").setParameter("userSocialId", (Object)userSocialId).setParameter("currentMonth", (Object)currentMonth).getSingleResult();
        try {
            return reupationScore == null ? 0L : reupationScore;
        }
        catch (NoResultException e) {
            return 0L;
        }
    }

    public long findUserReputationScoreByDomainBetweenDate(String userSocialId, String domain, Date fromDate, Date toDate) throws PersistenceException {
        Long reupationScore = (Long)this.getEntityManager().createNamedQuery("GamificationActionsHistory.findUserReputationScoreByDomainBetweenDate").setParameter("userSocialId", (Object)userSocialId).setParameter("domain", (Object)domain).setParameter("fromDate", (Object)fromDate).setParameter("toDate", (Object)toDate).getSingleResult();
        try {
            return reupationScore == null ? 0L : reupationScore;
        }
        catch (NoResultException e) {
            return 0L;
        }
    }

    public List<StandardLeaderboard> findAllLeaderboardBetweenDate(Date fromDate, Date toDate) throws PersistenceException {
        Query query = this.getEntityManager().createNamedQuery("GamificationActionsHistory.findAllLeaderboardBetweenDate").setParameter("fromDate", (Object)fromDate).setParameter("toDate", (Object)toDate);
        try {
            return query.getResultList();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public List<GamificationActionsHistory> findActionsHistoryByReceiverIdSortedByDate(String Receiver, boolean isGlobalContext, int loadCapacity) throws PersistenceException {
        Query query = this.getEntityManager().createNamedQuery("GamificationActionsHistory.findActionsHistoryByReceiverIdSortedByDate").setParameter("receiver", (Object)Receiver);
        if (isGlobalContext) {
            query.setMaxResults(loadCapacity);
        }
        List gamificationActionsHistoryList = query.getResultList();
        try {
            return gamificationActionsHistoryList;
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public long computeTotalScore(String actorIdentityId) {
        TypedQuery query = this.getEntityManager().createNamedQuery("GamificationActionsHistory.computeTotalScore", Long.class);
        query.setParameter("socialUserId", (Object)actorIdentityId);
        try {
            Long result = (Long)query.getSingleResult();
            return result == null ? 0L : result;
        }
        catch (NoResultException e) {
            return 0L;
        }
    }

    @ExoTransactional
    public List<GamificationActionsHistory> getAllPointsByDomain(String domain) throws PersistenceException {
        String string = domain;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this), (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        return (List)ExoTransactionalAspect.aspectOf().around(new GamificationHistoryDAO$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
    }

    @ExoTransactional
    public List<GamificationActionsHistory> getAllPointsWithNullDomain() throws PersistenceException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)this));
        Object[] objectArray = new Object[]{this, joinPoint};
        return (List)ExoTransactionalAspect.aspectOf().around(new GamificationHistoryDAO$AjcClosure3(objectArray).linkClosureAndJoinPoint(69648));
    }

    @ExoTransactional
    public List<String> getDomainList() throws PersistenceException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)((Object)this), (Object)((Object)this));
        Object[] objectArray = new Object[]{this, joinPoint};
        return (List)ExoTransactionalAspect.aspectOf().around(new GamificationHistoryDAO$AjcClosure5(objectArray).linkClosureAndJoinPoint(69648));
    }

    static {
        GamificationHistoryDAO.ajc$preClinit();
        LOG = ExoLogger.getLogger(GamificationHistoryDAO.class);
    }

    static /* synthetic */ List getAllPointsByDomain_aroundBody0(GamificationHistoryDAO ajc$this, String domain, JoinPoint joinPoint) {
        TypedQuery query = ajc$this.getEntityManager().createNamedQuery("GamificationActionsHistory.getAllPointsByDomain", GamificationActionsHistory.class).setParameter("domain", (Object)domain);
        try {
            return query.getResultList();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    static /* synthetic */ List getAllPointsWithNullDomain_aroundBody2(GamificationHistoryDAO ajc$this, JoinPoint joinPoint) {
        TypedQuery query = ajc$this.getEntityManager().createNamedQuery("GamificationActionsHistory.getAllPointsWithNullDomain", GamificationActionsHistory.class);
        try {
            return query.getResultList();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    static /* synthetic */ List getDomainList_aroundBody4(GamificationHistoryDAO ajc$this, JoinPoint joinPoint) {
        TypedQuery query = ajc$this.getEntityManager().createNamedQuery("GamificationActionsHistory.getDomainList", String.class);
        try {
            return query.getResultList();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("GamificationHistoryDAO.java", GamificationHistoryDAO.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getAllPointsByDomain", "org.exoplatform.addons.gamification.storage.dao.GamificationHistoryDAO", "java.lang.String", "domain", "javax.persistence.PersistenceException", "java.util.List"), 480);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getAllPointsWithNullDomain", "org.exoplatform.addons.gamification.storage.dao.GamificationHistoryDAO", "", "", "javax.persistence.PersistenceException", "java.util.List"), 495);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getDomainList", "org.exoplatform.addons.gamification.storage.dao.GamificationHistoryDAO", "", "", "javax.persistence.PersistenceException", "java.util.List"), 506);
    }
}

