/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.gamification.service.configuration;

import java.util.List;
import javax.persistence.EntityExistsException;
import javax.persistence.EntityNotFoundException;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.addons.gamification.entities.domain.configuration.BadgeEntity;
import org.exoplatform.addons.gamification.service.configuration.BadgeService$AjcClosure1;
import org.exoplatform.addons.gamification.service.configuration.BadgeService$AjcClosure11;
import org.exoplatform.addons.gamification.service.configuration.BadgeService$AjcClosure13;
import org.exoplatform.addons.gamification.service.configuration.BadgeService$AjcClosure15;
import org.exoplatform.addons.gamification.service.configuration.BadgeService$AjcClosure3;
import org.exoplatform.addons.gamification.service.configuration.BadgeService$AjcClosure5;
import org.exoplatform.addons.gamification.service.configuration.BadgeService$AjcClosure7;
import org.exoplatform.addons.gamification.service.configuration.BadgeService$AjcClosure9;
import org.exoplatform.addons.gamification.service.dto.configuration.BadgeDTO;
import org.exoplatform.addons.gamification.service.mapper.BadgeMapper;
import org.exoplatform.addons.gamification.storage.dao.BadgeDAO;
import org.exoplatform.commons.api.persistence.ExoTransactional;
import org.exoplatform.commons.persistence.impl.ExoTransactionalAspect;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class BadgeService {
    private static final Log LOG;
    protected final BadgeDAO badgeStorage = (BadgeDAO)((Object)CommonsUtils.getService(BadgeDAO.class));
    protected final BadgeMapper badgeMapper = (BadgeMapper)CommonsUtils.getService(BadgeMapper.class);
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;

    @ExoTransactional
    public BadgeDTO findBadgeByTitle(String badgeTitle) {
        String string = badgeTitle;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        return (BadgeDTO)ExoTransactionalAspect.aspectOf().around(new BadgeService$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
    }

    public List<BadgeDTO> getAllBadges() {
        try {
            List<BadgeEntity> badges = this.badgeStorage.getAllBadges();
            if (badges != null) {
                return this.badgeMapper.badgesToBadgeDTOs(badges);
            }
        }
        catch (Exception e) {
            LOG.error("Error to find Badges", new Object[]{e.getMessage()});
        }
        return null;
    }

    public List<BadgeDTO> getAllBadgesbyDomain() {
        try {
            List<BadgeEntity> badges = this.badgeStorage.getAllBadges();
            if (badges != null) {
                return this.badgeMapper.badgesToBadgeDTOs(badges);
            }
        }
        catch (Exception e) {
            LOG.error("Error to find Badges", new Object[]{e.getMessage()});
        }
        return null;
    }

    @ExoTransactional
    public BadgeDTO addBadge(BadgeDTO badgeDTO) {
        BadgeDTO badgeDTO2 = badgeDTO;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)badgeDTO2);
        Object[] objectArray = new Object[]{this, badgeDTO2, joinPoint};
        return (BadgeDTO)ExoTransactionalAspect.aspectOf().around(new BadgeService$AjcClosure3(objectArray).linkClosureAndJoinPoint(69648));
    }

    @ExoTransactional
    public BadgeDTO updateBadge(BadgeDTO badgeDTO) {
        BadgeDTO badgeDTO2 = badgeDTO;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)badgeDTO2);
        Object[] objectArray = new Object[]{this, badgeDTO2, joinPoint};
        return (BadgeDTO)ExoTransactionalAspect.aspectOf().around(new BadgeService$AjcClosure5(objectArray).linkClosureAndJoinPoint(69648));
    }

    @ExoTransactional
    public void deleteBadge(Long id) {
        Long l = id;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)l);
        Object[] objectArray = new Object[]{this, l, joinPoint};
        ExoTransactionalAspect.aspectOf().around(new BadgeService$AjcClosure7(objectArray).linkClosureAndJoinPoint(69648));
    }

    @ExoTransactional
    public List<BadgeDTO> findBadgesByDomain(String badgeDomain) {
        String string = badgeDomain;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        return (List)ExoTransactionalAspect.aspectOf().around(new BadgeService$AjcClosure9(objectArray).linkClosureAndJoinPoint(69648));
    }

    @ExoTransactional
    public List<BadgeDTO> findEnabledBadgesByDomain(String badgeDomain) {
        String string = badgeDomain;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        return (List)ExoTransactionalAspect.aspectOf().around(new BadgeService$AjcClosure11(objectArray).linkClosureAndJoinPoint(69648));
    }

    @ExoTransactional
    public List<BadgeDTO> getAllBadgesWithNullDomain() throws Exception {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        return (List)ExoTransactionalAspect.aspectOf().around(new BadgeService$AjcClosure13(objectArray).linkClosureAndJoinPoint(69648));
    }

    @ExoTransactional
    public List<String> getDomainListFromBadges() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        return (List)ExoTransactionalAspect.aspectOf().around(new BadgeService$AjcClosure15(objectArray).linkClosureAndJoinPoint(69648));
    }

    static {
        BadgeService.ajc$preClinit();
        LOG = ExoLogger.getLogger(BadgeService.class);
    }

    static /* synthetic */ BadgeDTO findBadgeByTitle_aroundBody0(BadgeService ajc$this, String badgeTitle, JoinPoint joinPoint) {
        try {
            BadgeEntity entity = ajc$this.badgeStorage.findBadgeByTitle(badgeTitle);
            if (entity != null) {
                return ajc$this.badgeMapper.badgeToBadgeDTO(entity);
            }
        }
        catch (Exception e) {
            LOG.error("Error to find Badge entity with title : {}", new Object[]{badgeTitle, e.getMessage()});
        }
        return null;
    }

    static /* synthetic */ BadgeDTO addBadge_aroundBody2(BadgeService ajc$this, BadgeDTO badgeDTO, JoinPoint joinPoint) {
        BadgeEntity badgeEntity;
        block6: {
            badgeEntity = null;
            try {
                badgeEntity = ajc$this.badgeStorage.findBadgeByTitle(badgeDTO.getTitle());
                if (badgeEntity == null) {
                    if (!badgeDTO.getDomainDTO().isEnabled()) {
                        badgeDTO.setEnabled(false);
                    }
                    badgeEntity = (BadgeEntity)ajc$this.badgeStorage.create(ajc$this.badgeMapper.badgeDTOToBadge(badgeDTO));
                    break block6;
                }
                if (badgeEntity.isDeleted()) {
                    Long id = badgeEntity.getId();
                    badgeEntity = ajc$this.badgeMapper.badgeDTOToBadge(badgeDTO);
                    badgeEntity.setId(id);
                    if (!badgeDTO.getDomainDTO().isEnabled()) {
                        badgeDTO.setEnabled(false);
                    }
                    badgeEntity = (BadgeEntity)ajc$this.badgeStorage.update(badgeEntity);
                    break block6;
                }
                throw new EntityExistsException();
            }
            catch (Exception e) {
                LOG.error("Error to create badge with title {}", new Object[]{badgeDTO.getTitle(), e});
            }
        }
        return ajc$this.badgeMapper.badgeToBadgeDTO(badgeEntity);
    }

    static /* synthetic */ BadgeDTO updateBadge_aroundBody4(BadgeService ajc$this, BadgeDTO badgeDTO, JoinPoint joinPoint) {
        BadgeEntity badgeEntity = null;
        try {
            if (!badgeDTO.getDomainDTO().isEnabled()) {
                badgeDTO.setEnabled(false);
            }
            badgeEntity = (BadgeEntity)ajc$this.badgeStorage.update(ajc$this.badgeMapper.badgeDTOToBadge(badgeDTO));
        }
        catch (Exception e) {
            LOG.error("Error to update with title {}", new Object[]{badgeDTO.getTitle(), e});
        }
        return ajc$this.badgeMapper.badgeToBadgeDTO(badgeEntity);
    }

    static /* synthetic */ void deleteBadge_aroundBody6(BadgeService ajc$this, Long id, JoinPoint joinPoint) {
        try {
            BadgeEntity badgeEntity = (BadgeEntity)ajc$this.badgeStorage.find(id);
            if (badgeEntity == null) {
                LOG.warn("Badge {} not Found", new Object[]{id});
                throw new EntityNotFoundException();
            }
            badgeEntity.setDeleted(true);
            ajc$this.badgeStorage.update(badgeEntity);
        }
        catch (Exception e) {
            LOG.error("Error to delete badge with title {}", new Object[]{id, e});
        }
    }

    static /* synthetic */ List findBadgesByDomain_aroundBody8(BadgeService ajc$this, String badgeDomain, JoinPoint joinPoint) {
        try {
            List<BadgeEntity> badges = ajc$this.badgeStorage.findBadgesByDomain(badgeDomain);
            if (badges != null) {
                return ajc$this.badgeMapper.badgesToBadgeDTOs(badges);
            }
        }
        catch (Exception e) {
            LOG.error("Error to find badges within domain {}", new Object[]{badgeDomain, e});
        }
        return null;
    }

    static /* synthetic */ List findEnabledBadgesByDomain_aroundBody10(BadgeService ajc$this, String badgeDomain, JoinPoint joinPoint) {
        try {
            List<BadgeEntity> badges = ajc$this.badgeStorage.findEnabledBadgesByDomain(badgeDomain);
            if (badges != null) {
                return ajc$this.badgeMapper.badgesToBadgeDTOs(badges);
            }
        }
        catch (Exception e) {
            LOG.error("Error to find badges within domain {}", new Object[]{badgeDomain, e});
        }
        return null;
    }

    static /* synthetic */ List getAllBadgesWithNullDomain_aroundBody12(BadgeService ajc$this, JoinPoint joinPoint) {
        try {
            List<BadgeEntity> rules = ajc$this.badgeStorage.getAllBadgesWithNullDomain();
            if (rules != null) {
                return ajc$this.badgeMapper.badgesToBadgeDTOs(rules);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error to find Badges", (Throwable)e);
            throw e;
        }
        return null;
    }

    static /* synthetic */ List getDomainListFromBadges_aroundBody14(BadgeService ajc$this, JoinPoint joinPoint) {
        return ajc$this.badgeStorage.getDomainList();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("BadgeService.java", BadgeService.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "findBadgeByTitle", "org.exoplatform.addons.gamification.service.configuration.BadgeService", "java.lang.String", "badgeTitle", "", "org.exoplatform.addons.gamification.service.dto.configuration.BadgeDTO"), 39);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "addBadge", "org.exoplatform.addons.gamification.service.configuration.BadgeService", "org.exoplatform.addons.gamification.service.dto.configuration.BadgeDTO", "badgeDTO", "", "org.exoplatform.addons.gamification.service.dto.configuration.BadgeDTO"), 98);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateBadge", "org.exoplatform.addons.gamification.service.configuration.BadgeService", "org.exoplatform.addons.gamification.service.dto.configuration.BadgeDTO", "badgeDTO", "", "org.exoplatform.addons.gamification.service.dto.configuration.BadgeDTO"), 134);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteBadge", "org.exoplatform.addons.gamification.service.configuration.BadgeService", "java.lang.Long", "id", "", "void"), 158);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "findBadgesByDomain", "org.exoplatform.addons.gamification.service.configuration.BadgeService", "java.lang.String", "badgeDomain", "", "java.util.List"), 180);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "findEnabledBadgesByDomain", "org.exoplatform.addons.gamification.service.configuration.BadgeService", "java.lang.String", "badgeDomain", "", "java.util.List"), 198);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getAllBadgesWithNullDomain", "org.exoplatform.addons.gamification.service.configuration.BadgeService", "", "", "java.lang.Exception", "java.util.List"), 219);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getDomainListFromBadges", "org.exoplatform.addons.gamification.service.configuration.BadgeService", "", "", "", "java.util.List"), 238);
    }
}

